* this file produces table 6: annual forecast accuracy in the online appendix.

#delimit;
clear all;
set more off;

*change this directory first;
qui: cd "/Users/johanneswieland/Dropbox/uni/Work/Research/PhD/Brookings/Hausman_Wieland_Data_Programs/Stata/Code";
*qui: cd "~/Dropbox/Brookings/Hausman_Wieland_Data_Programs/Stata/Code";

* setting paths;
qui: do paths;

* variables to be used;
local cefevars gdp cpi cons ip;

* location of variables in excel file;
local sheetlist "GDP" "CPI" "Consumption" "Industrial Production";


********************************************************************************
*
* Consensus forecasts for Japan: annual forecasts
*
********************************************************************************;

local zz = 1;

foreach var in `cefevars' {;
	
	local sheetname: word `zz' of "`sheetlist'";
	display "`sheetname'";

	qui: cd "$DataPath/Consensus";
	import excel using "JAPAN Extended.xls", sheet("Annual `sheetname'") firstrow case(lower);
	*drop if _n==1;
	destring, replace;
	
	
	
	tostring fyear fmonth, generate(fyear_string fmonth_string);
	gen surveydate = fyear_string + "m" + fmonth_string;
    
	drop fyear fyear_string fmonth fmonth_string;
	
	
	foreach vary of varlist y* {;

		local yearst = substr("`vary'",2,4);
		disp "`yearst'";
		rename `vary' `var'`yearst';
			};
	
	
	reshape long `var', i(surveydate) j(date) string;
	
	* new date variable;
	destring date, replace;
	
	* new survey variable;
	gen survey = monthly(surveydate,"YM");
	format survey %tm;
	drop surveydate;
	
	save "$StDataPath/jpcea`var'", replace;
	clear all;
	
	local zz = `zz' + 1;
};

qui: cd "$CodePath";

* merging data;
use "$StDataPath/jpceagdp";
merge m:1 survey date using "$StDataPath/jpceacons", gen(_mergececons);
merge m:1 survey date using "$StDataPath/jpceacpi", gen(_mergececpi);
merge m:1 survey date using "$StDataPath/jpceaip", gen(_mergeceip);

order survey date, before(gdp);


* forecast horizon (years) Note the horizon is made the same for the April
*and October forecasts.;
gen horizon = date - yofd(dofm(survey)) - (month(dofm(survey))-10)/12;
gen thorizon= -horizon;
gen mth = month(dofm(survey));

replace thorizon = thorizon*2;

/*Trick to allow panel data setting - set date to be 100 years
in the future for October surveys. */
*replace date = date+100 if mth==10;
sort date survey;
xtset date thorizon;


save "$StDataPath/jpceannual_pooled", replace;

********************************************************************************
*
* Accuracy analysis
*
********************************************************************************;


* forecast changes: are revisions realized?;
eststo clear;
use "$StDataPath/jpceannual_pooled", clear;
	foreach var in `cefevars' {;
		gen d2`var' = S2.`var';
		forvalues jj=0(1)4 {;
		
			local lag = (3+`jj')*2;
			gen d`lag'`var' = S`lag'.`var';
			
			local zz = `jj'*2;
		
			qui: regress F4.d`lag'`var' L`zz'.d2`var' if horizon==0 | horizon==0.5, robust;
			local r2_temp_`zz' = e(r2);
			*list date F2.d`lag'`var' L`jj'.d`var' if horizon==0;
		};
		
		
		forvalues jj=0(1)4 {;
			local lag = (3+`jj')*2;			
			local zz = `jj'*2;
			
			gen f4d`lag'`var' = F4.d`lag'`var';
			gen lag`zz'd2`var' = L`zz'.d2`var';
			
			sort thorizon date;
			tsset thorizon date, quarterly;
			newey f4d`lag'`var' lag`zz'd2`var' if horizon==0 | horizon==0.5, lag(2) force;
			eststo, addscalars(r2 `r2_temp_`zz'');
			sort date thorizon;
			tsset date thorizon;
			
		};
	
	
	esttab using "$StTabPath/forecastad`var'panel_newey.tex", b(2) se(2) r2 label title(Forecasting Bias\label{tab:ceabias`var'}) ///
    legend nonotes starlevels( \sym{+} 0.10 \sym{*} 0.05 \sym{**} 0.010) ///
    coeflabels("") ///
    rename(lag2d2`var' lag0d2`var' lag4d2`var' lag0d2`var' lag6d2`var' lag0d2`var' lag8d2`var' lag0d2`var') ///                                   
    noconstant fragment nolines nonum nomtitles ///
    substitute(\_ _ < \textless [1em] "" Observations N lag0d2`var' "\multirow{2}{*}{$\hat{\beta}_{1}$}") wrap compress replace;
	

	eststo clear;
	
};
