*This compares the path of industrial production in 1933 versus that in the first year of Abenomics;

#delimit;
clear all;
set more off;

*change this directory first;
qui: cd "/Users/johanneswieland/Dropbox/uni/Work/Research/PhD/Brookings/Hausman_Wieland_Data_Programs/Stata/Code";
*qui: cd "~/Dropbox/Brookings/Hausman_Wieland_Data_Programs/Stata/Code";

* setting paths;
qui: do paths;


//get U.S. seasonally adjusted IP data from FRED. ;
freduse INDPRO;

drop date;
gen date = mofd(daten);

tsset date;
sort date;
format date %tm;

rename INDPRO ip_us;

sort date;

save "$StDataPath/us_1933", replace;

//get Japanese IP;
clear all;

import excel using "$DataPath/IP/b2010_gsm1e_apr2014.xls", sheet(for_stata) first;
drop if ip==.;

gen date = ym(year, month);
drop year month;

sort date;

merge 1:1 date using "$StDataPath/us_1933";

sort date;
format date %tm;

local fdr_date = "1933m3";
local abe_date = "2012m12";

local mindat = date[1];
local fdr_obs = tm(`fdr_date') - `mindat' +1;
local abe_obs = tm(`abe_date') - `mindat' +1;
local lag_length = `abe_obs' - `fdr_obs';

*make each series equal to 100 at regime change start;
gen ip_us_index = 100*(ip_us / ip_us[`fdr_obs']);
gen ip_index = 100*(ip / ip[`abe_obs']);


gen ip_align = F`lag_length'.ip_index;

//Make index equal to zero in 12/12 for graph;
gen index = _n;
gen months = index - `fdr_obs';

* labeling;
label var ip_us_index "FDR, 3/1933";
label var ip_align "Abe, 12/2012";
cd "$StGrphPath";

line ip_align ip_us_index  months if months>-25 & months<24, name(fdr_abe) xlabel(-24(6)24 , ) ///
 plotregion(style(none)) clcolor(blue) legend(cols(1) ring(0) position(5) ) ytitle("Industrial production (SA)") ///
 xtitle("Months before / after regime change") lwidth(medthick medthick) clcolor(blue red) clpattern(solid dash) graphregion(color(white));
graph export fdr_abe.eps, replace;

