#delimit;
clear all;
set more off;

********************************************************************************
*
* The purpose of this file is to determine return predictability 
*
********************************************************************************;

*change this directory first;
qui: cd "/Users/johanneswieland/Dropbox/uni/Work/Research/PhD/Brookings/Hausman_Wieland_Data_Programs/Stata/Code";
*qui: cd "~/Dropbox/Brookings/Hausman_Wieland_Data_Programs/Stata/Code";

* setting paths;
qui: do paths;

* get price data;
cd "$DataPath/MSCI";
import excel using "msciprice.xls", cellrange(A7:B536) firstrow case(lower);
qui: rename japanstandardlargemidcap msciprice;
cd "$StDataPath";
save msciprice, replace;
clear all;


* get net return data;
cd "$DataPath/MSCI";
import excel using "mscireturn.xls", cellrange(A7:B536) firstrow case(lower);
qui: rename japanstandardlargemidcap mscireturn;
cd "$StDataPath";
save mscireturn, replace;
clear all;

* get gross return data;
cd "$DataPath/MSCI";
import excel using "mscigross.xls", cellrange(A7:B536) firstrow case(lower);
qui: rename japanstandardlargemidcap mscigross;
cd "$StDataPath";
save mscigross, replace;


* merge data;
merge m:1 date using mscireturn, gen(_merge);
merge m:1 date using msciprice, gen(_merge2);
qui: drop _merge*;



********************************************************************************
*
* Generating other campbell variables;   
*
********************************************************************************;

qui: gen datem = mofd(date);
qui: gen dateq = qofd(date);
qui: gen datey = yofd(date);
tsset datem, monthly;

* monthly dividend yield: calculated based on simple average of past 12 months of dividends;
qui: gen dym 	=	mscireturn/L.mscireturn / (msciprice/L.msciprice) - 1;
qui: gen dygm 	=	mscigross/L.mscigross / (msciprice/L.msciprice) - 1;

* monthly dividends: assume that dividends are approximately constant over last 12 months as in Campbell;
qui: gen dm		=	msciprice*dym;
qui: gen dgm	=	msciprice*dygm;

* quarterly sum of dividends;
qui: by dateq, sort: egen dq		=	sum(dm);
qui: by dateq, sort: egen dgq	=	sum(dgm);
qui: by datey, sort: egen dy		=	sum(dm);
qui: by datey, sort: egen dgy	=	sum(dgm);
qui: replace dq 	= . if dateq==yq(1969,4);
qui: replace dgq = . if dateq==yq(1969,4);
qui: sort datem;

* after 2001 dividends are no longer calculated as an average over 12 months;
* create new variable that averages dividends over last 12 months;
foreach var in d dg {;
	qui: gen `var'qa = `var'q if dateq<=yq(2000,4);
	qui: tssmooth ma ma`var'm = `var'm, window(11 1);
	qui: by dateq, sort: egen `var'qatemp = sum(ma`var'm);
	qui: sort datem;
	qui: replace `var'qa = `var'qatemp if dateq>yq(2001,4);
	
	* during 2001 we use a weighted average based on 2000 average dividends and 2001 actual dividends;
	* weights are calculated based on payout rates in the 2001 quarter.;
	local factor = 0;
	forvalues jj=3(3)12 {;
		local factor = `var'q[373+`jj']/`var'y[373+`jj'];
		qui: replace `var'qa = 3/12 * `var'q   + (1-`factor')*L`jj'.`var'qa if datem==ym(2001,`jj');
	};
};

* change in dividends and prices since October 2012;
foreach var in dqa dgqa msciprice {;
	local inc`var' = `var'[529]/`var'[515];
	display "`inc`var''";
};

qui: sort datem;

* dropping intermediate dates;
drop if dateq[_n]==dateq[_n+1];
drop date;
rename dateq date;
tsset date, quarterly;

* returns;
qui: gen retnom	=   mscireturn/L.mscireturn;
qui: gen rtgq 	=	(msciprice+dgqa)/L.msciprice;
qui: gen rtq 	=	(msciprice+dqa)/L.msciprice;

correlate retnom rt*;

* dividend price ratio;
qui: gen dpgq		=	(dgqa+L.dgqa+L2.dgqa+L3.dgqa)/msciprice;
qui: gen dpq		=	(dqa+L.dqa+L2.dqa+L3.dqa)/msciprice;

* change in dividends and prices since Q3 2012;
foreach var in dqa dgqa msciprice dpgq dpq {;
	local inc`var' = `var'[177]/`var'[172];
	display "`inc`var''";
};



********************************************************************************
*
* Forecasting;   
*
********************************************************************************;

* generating forecasting variables;

* logs:;
foreach var of varlist rtq rtgq dqa dgqa dpgq dpq {;
	qui: gen l`var' = ln(`var');
};

* growth:;
foreach var of varlist dqa dgqa {;
	qui: gen dl`var' = S.l`var';
};



* future variables:;
forvalues horizon=20(10)80 {;
	foreach qjyn in q gq {;
		foreach var of varlist lrt`qjyn' dld`qjyn'a {;
			qui: su ldp`qjyn';
			local ldpmean `r(mean)';
			local rho = 1/(1+exp(`ldpmean'));
		
			qui: gen `var'_`horizon' = 0;
			qui: replace `var'_`horizon' = . if F`horizon'.`var'==.;
			
			forvalues jj=1(1)`horizon' {;
				qui: replace `var'_`horizon' = `var'_`horizon' + `rho'^(`jj'-1)*F`jj'.`var';
			};
			
			local neweylag = `horizon';
			
			* this regression implements s.e. corrections for overlapping data;
			ivreg2 `var'_`horizon' ldp`qjyn' , bw(`neweylag') kernel(tru);
			eststo `var'`horizon';
		};
	};
};


* tabulating results;
cd "$StTabPath";

esttab lrtq40 dldqa40 lrtq60 dldqa60 lrtq80 dldqa80 using csnet.tex, ///
	b(2) se(2) nocons label title(Campbell-Shiller Decomposition\label{tab:csdcnet}) ///
	mtitles("$ b_{r}^{h}$" "$ b_{d}^{h}$" "$ b_{r}^{h}$" "$ b_{d}^{h}$" "$ b_{r}^{h}$" "$ b_{d}^{h}$")  ///
	mgroups(" $ h$ = 10 years" " $ h$ = 15 years" " $ h$ = 20 years", pattern(1 0 1 0 1 0 1 0) prefix(\multicolumn{@span}{c}{) suffix(}) span erepeat(\cmidrule(lr){@span}))   ///                                          
    legend nonotes starlevels( \sym{+} 0.10 \sym{*} 0.05 \sym{**} 0.010) ///
    drop(_cons ) nonum noobs ///
    addnote("Newey-West standard errors in parentheses (bandwidth = h).") ///
    substitute(\_ _ < \textless 1em 0.1em) ///
    rename(ldpq "Net Returns") ///
     wrap compress replace fragment
    ;
    
esttab lrtgq40 dldgqa40 lrtgq60 dldgqa60 lrtgq80 dldgqa80 using csgross.tex, ///
	b(2) se(2) nocons label title(Campbell-Shiller Decomposition\label{tab:csdcnet}) ///
	legend nonotes starlevels( \sym{+} 0.10 \sym{*} 0.05 \sym{**} 0.010) ///
    drop(_cons ) nonum nomtitles ///
    addnote("Newey-West standard errors in parentheses (bandwidth = h).") ///
    substitute(\_ _ < \textless 1em 0.1em \hline "" Observations " \hline N") ///
    rename(ldpgq "Gross Returns") ///
     wrap compress replace fragment
    ;
    
    
********************************************************************************
*
* Relationship between GDP and annual dividends;   
*
********************************************************************************;
    
preserve;
gen year = yofd(dofq(date));
keep year dgm;
collapse (sum) dgm, by(year);
keep if year>=1970;
tsset year, yearly;

merge m:1 year using "$StDataPath/jp_output_gap", gen(_merge);
tsset year, yearly;

local lag 1;

foreach var in spliced dgm {;
	gen l`var'=ln(`var');
	gen d`lag'l`var' = S`lag'.l`var';
};

su d`lag'l* if d`lag'lspliced<.;
su d`lag'l* if year==2009;

* display correlation between dividend growth and output;
correl d`lag'l*;

restore;
