*This uses a three variable var to get measures of expected inflation and expected output growth.;


#delimit;
clear all;
set more off;

*change this directory first;
qui: cd "/Users/johanneswieland/Dropbox/uni/Work/Research/PhD/Brookings/Hausman_Wieland_Data_Programs/Stata/Code";
*qui: cd "~/Dropbox/Brookings/Hausman_Wieland_Data_Programs/Stata/Code";

* setting paths;
qui: do paths;

*get annual GNP / GDP data. (GNP from Romer (1989) pre 1929, thereafter BEA GDP.);
import excel using "$DataPath/annual_data_2.xlsx", sheet("data") firstrow;
sort year;
save "$StDataPath/annual_data_1933", replace;

clear;

*get FRED series for the CPI and interest rates. Both series are monthly, nsa;
freduse CPIAUCNS M1333AUSM156NNBR;

rename CPIAUCNS cpi;
rename M1333AUSM156NNBR lt_rate;

drop date;
gen date = mofd(daten);
drop daten;

tsset date;
sort date;
format date %tm;

gen year = yofd(dofm(date));

*make series annual;
collapse (mean) cpi lt_rate, by(year);
sort year;

*merge with output data;
merge year using "$StDataPath/annual_data_1933";
drop if _merge !=3;
keep year cpi lt_rate spliced;
rename spliced rgdp;
tsset year;

foreach var in rgdp cpi {;
	gen pch_`var' = 100*(`var' / l.`var' -1);
	*gen ln_`var' =ln(`var');
	*gen dln_`var' = 100*d.ln_`var';
	};


gen dlt_rate = d.lt_rate;
	
save "$StDataPath/annual_data_1933", replace;



var pch_rgdp pch_cpi dlt_rate if tin(1919,1940), lags(1) ; 



*get summary statistics used in dY/dr table;

*pre expectations;
fcast compute for_, step(13) dynamic(1933) replace; 

*inflation expectation - average 1933-42;
sum for_pch_cpi if tin(1933,1942);
disp r(mean);

*output expectation - obs. 20 is 1932;
gen rgdp_index = 100*(rgdp/rgdp[20]);

gen y_pre_expect = rgdp_index;
replace y_pre_expect = l.y_pre_expect*(1+for_pch_rgdp/100) if for_pch_rgdp !=.;

gen dY= y_pre_expect / rgdp_index -1;
gen dY2= rgdp_index / y_pre_expect - 1; // using forecasts as a base;

list y_pre_expect if year==1939;
list dY if year==1939;
list dY2 if year==1939;


//see how forecast levels compare to actual;
label var rgdp_index "Actual real GDP";
labe var y_pre_expect "Prediction as of 1932";
tsline rgdp_index y_pre_expect if tin(1931,1940);


*See what this exercise implies that inflation expectations were in 1934, after the regime change
var pch_rgdp pch_cpi dlt_rate if tin(1919,1940), lags(1) ; 
fcast compute for_, step(13) dynamic(1935) replace; 

*inflation expectation - average 1935-44;
sum for_pch_cpi if tin(1935,1944);
disp r(mean);

