function [ X1 ] = DistMarkups( X0 , M )
%DistMarkups Distributes the markups in M across the columns of X0
%   Here it is...

    NegativeMarkups = -1.*M.*(M < 0);
    PositiveMarkups = (M > 0);
    PositiveMarkups = PositiveMarkups./(kron(ones(size(PositiveMarkups,1),1),sum(PositiveMarkups,1)));
    PositiveMarkups(isnan(PositiveMarkups)) = 0;
    SharesX0 = X0./kron(ones(1,size(X0,2)),sum(X0,2));
    SharesX0( isnan( SharesX0 ) ) = 0;
    X1 = X0;
    
    for icol = 1:size(M,2)
    
        RedistNegativeMarkups = SharesX0.*kron(ones(1,size(X0,2)),NegativeMarkups(:,icol));
        RedistPositiveMarkups = kron(ones(size(RedistNegativeMarkups,1),1),sum(RedistNegativeMarkups,1)).* ...
                                kron(PositiveMarkups(:,icol),ones(1,size(X0,2)));
                                
        X1 = X1 + RedistNegativeMarkups + RedistPositiveMarkups;                        
                                
    end
    
end

