classdef IOYear < handle
    %IOYEAR IOTables object for a particular year
    %   Provides access to the IO tables manipulation for a year
    %
    %   Properties
    %   ----------
    %   Year            Year for which the object contructed
    %   Settings        Model parameters
    %   Matrices        All the matrices used for the calculations
    %   SupplyChain     Set of methods used to calculate supply chain
    %                   statistics
    %
        
    properties
           
    end
    
    properties ( SetAccess = private , Hidden = false )
    
        Year
        Settings
        Matrices
        SupplyChain
        
    end
    
    properties ( Dependent = true , SetAccess = private )
            
        
    end
    
    methods 
       
        function obj = IOYear( val )
            obj.Year = val;
            obj.Settings = IOtables.Settings( obj );
            obj.Matrices = IOtables.Matrices( obj );
            obj.SupplyChain = IOtables.SupplyChain( obj );
        end                                              
            
    end
    
end

