% Execution file for static optimal tax model
%Universals
close all
clear all
warning off
options=optimset('TolCon',1e-13,'TolFun',1e-13,'TolX',1e-13,'Display','none','MaxFunEvals',10000000,'MaxIter',2000); 
cutoff=1;
%% SQ setup
mmat=[  0.0216	0.0203	0.0189	0.0189	0.0189	0.0162	0.0148	0.0135	0.0121	0.0107
        0.0234	0.0220	0.0205	0.0205	0.0205	0.0176	0.0162	0.0147	0.0132	0.0118
        0.0254	0.0238	0.0222	0.0222	0.0222	0.0191	0.0176	0.0160	0.0145	0.0129
        0.0274	0.0257	0.0241	0.0241	0.0241	0.0208	0.0191	0.0174	0.0158	0.0141
        0.0295	0.0278	0.0260	0.0260	0.0260	0.0225	0.0207	0.0190	0.0172	0.0155
        0.0320	0.0301	0.0282	0.0282	0.0282	0.0245	0.0226	0.0207	0.0189	0.0170
        0.0348	0.0328	0.0308	0.0308	0.0308	0.0267	0.0247	0.0227	0.0207	0.0187
        0.0378	0.0356	0.0335	0.0335	0.0335	0.0292	0.0271	0.0249	0.0228	0.0206
        0.0411	0.0388	0.0365	0.0365	0.0365	0.0319	0.0296	0.0273	0.0250	0.0227
        0.0446	0.0422	0.0397	0.0397	0.0397	0.0348	0.0324	0.0299	0.0275	0.0250
        0.0487	0.0461	0.0435	0.0435	0.0435	0.0382	0.0356	0.0330	0.0303	0.0277
        0.0534	0.0505	0.0477	0.0477	0.0477	0.0421	0.0392	0.0364	0.0336	0.0308
        0.0584	0.0554	0.0523	0.0523	0.0523	0.0463	0.0432	0.0402	0.0372	0.0341
        0.0639	0.0606	0.0573	0.0573	0.0573	0.0508	0.0476	0.0443	0.0411	0.0378
        0.0698	0.0663	0.0628	0.0628	0.0628	0.0559	0.0524	0.0489	0.0454	0.0419
        0.0766	0.0729	0.0691	0.0691	0.0691	0.0616	0.0579	0.0541	0.0504	0.0466
        0.0843	0.0803	0.0762	0.0762	0.0762	0.0682	0.0641	0.0601	0.0560	0.0520
        0.0928	0.0884	0.0841	0.0841	0.0841	0.0753	0.0710	0.0666	0.0623	0.0579
        0.1020	0.0973	0.0926	0.0926	0.0926	0.0832	0.0785	0.0739	0.0692	0.0645
        0.1120	0.1070	0.1020	0.1020	0.1020	0.0919	0.0869	0.0819	0.0769	0.0718
        0.1232	0.1178	0.1124	0.1124	0.1124	0.1016	0.0962	0.0908	0.0854	0.0800
        0.1356	0.1298	0.1240	0.1240	0.1240	0.1124	0.1066	0.1009	0.0951	0.0893
        0.1494	0.1432	0.1370	0.1370	0.1370	0.1245	0.1183	0.1121	0.1058	0.0996
        0.1645	0.1579	0.1512	0.1512	0.1512	0.1378	0.1312	0.1245	0.1178	0.1111
        0.1810	0.1739	0.1668	0.1668	0.1668	0.1525	0.1453	0.1382	0.1310	0.1239
        0.1989	0.1912	0.1836	0.1836	0.1836	0.1684	0.1607	0.1531	0.1455	0.1378
        0.2179	0.2098	0.2017	0.2017	0.2017	0.1855	0.1774	0.1693	0.1611	0.1530
        0.2382	0.2296	0.2210	0.2210	0.2210	0.2038	0.1952	0.1866	0.1780	0.1694
        0.2596	0.2505	0.2414	0.2414	0.2414	0.2233	0.2142	0.2052	0.1961	0.1870
        0.2820	0.2724	0.2629	0.2629	0.2629	0.2439	0.2343	0.2248	0.2153	0.2058
        0.3039	0.2940	0.2841	0.2841	0.2841	0.2643	0.2544	0.2445	0.2345	0.2246
        0.3250	0.3148	0.3046	0.3046	0.3046	0.2842	0.2740	0.2637	0.2535	0.2433
        0.3448	0.3344	0.3240	0.3240	0.3240	0.3032	0.2927	0.2823	0.2719	0.2615
        0.3630	0.3525	0.3419	0.3419	0.3419	0.3209	0.3103	0.2998	0.2893	0.2788
        0.3790	0.3685	0.3580	0.3580	0.3580	0.3369	0.3264	0.3159	0.3053	0.2948]; %Mortality rates
scalefactor=1/(50*8*5) %to make variables per working hour, as in std optimal tax model with y/w in hours
BSQvec= scalefactor*[3086	4965	6813	9122	11180	14016	15717	17831	19273	23868 ]; %SQ benefits inferred from SSK
Avec=   scalefactor*[ 6938	35383	60339	104069	124883	172543	178416	231727	313594	545321 ]; %Non-SS and non-DB net worth at retirement from SSK
DBvec= scalefactor*[0	0	0	1259	2504	3872	4756	6058	8883	10779]; %annual benefit from DB assets, from SSK
[T,I]=size(mmat); %maximum number of retirement years, and number of types
p=  1/I*ones(1,I);  %pop proportions 
minben=scalefactor*0;
G=0; %Required revenue
beta=[0.96	0.96 0.96 0.96	0.96 0.96	0.96 0.96	0.96 0.96] ; %uniform time discounting, baseline 0.96
R=1/(sum(beta)/I); %uniform gross rate of return to capital
gamma=3; %risk aversion
crra=1; %Utility functional form parameter, 1 if c()-1, 0 if c()
LifeUadj=0; %-1/(1-gamma) for expected and experienced retirement utility calcs if crra=0; 0 for crra=1
beqmotvec=[0 0 0 0 0 0 0 0 0 0 ] ; %positive elements to make a bequest motive
epsilon=gamma; %bequest risk aversion
pos=0.01; %to make assets nonnegative for bequest motive
for t=1:T
    pvfactor(t)=(1/R)^(t-1);
end
for t=1:T
    for i=1:I
        discountmat(t,i)=beta(i)^(t-1);
    end
end
pbbalivemat(1:T,1:I)=1;
for i=1:I
    for t=1:T-1
        pbbalivemat(t+1,i)=pbbalivemat(t,i)*(1-mmat(t,i));
    end
end
for i=1:I
    for t=1:T
    pbbdiemat(t,i)=mmat(t,i)*pbbalivemat(t,i); %share of type i who lives t years
    end
end

%Individuals choose consumption paths
lb =.01*ones(1,T);
ub =[inf]*ones(1,T);
guess= 10*ones(1,T);
for i=1:I
    for t=1:T
        BSQmat(t,i)=BSQvec(i);
        DBmat(t,i)=DBvec(i);
    end
end

for i=1:I
    m=mmat(:,i);
    pbbalive=pbbalivemat(:,i);
    discount=discountmat(:,i);
    pbbdie=pbbdiemat(:,i);
    A=Avec(i);
    BSQ=BSQmat(:,i);
    DB=DBmat(:,i);
    beqmot=beqmotvec(i);
    [z,fval,exitflag,output,lambda]=fmincon('socsecobj051214',guess,[],[],[],[],lb,ub,...
        'socsecconstr051214',options,m,pbbalive,pbbdie,BSQ,DB,A,G,T,discount,pvfactor,R,gamma,crra,beqmot,epsilon,pos,minben);
    for t=1:T
            c(t)=z(t);
            U(t)=  1/(1-gamma)*(c(t)^(1-gamma)-crra);     
%             U(t)=  log(c(t));     
    end
    Assets(1)=A;
        for t=1:T-1
            Assets(t+1)=(Assets(t)+DB(t)+max(minben,BSQ(t))-c(t))*R;
            beqU(t)=beqmot*1/(1-epsilon)*((pos+Assets(t))^(1-epsilon)-crra);
        end
     beqU(T)=beqmot*1/(1-epsilon)*((pos+Assets(T)+DB(T)+max(minben,BSQ(T))-c(T))^(1-epsilon)-crra);
    EU=sum((LifeUadj+U).*pbbalive'.*discount')+sum(beqU.*pbbdie'.*discount');    
    
    cmat(:,i)=c';
    Umat(:,i)=U';
    beqUmat(:,i)=beqU';
    EUmat(i)=EU;
    Assetsmat(:,i)=Assets';
end
for i=1:I
    for t=1:T-1
        foctest(i,t)=cmat(t,i)^(-gamma)-beta(i)*(1-mmat(t,i))*cmat(t+1,i)^(-gamma);
%         foctest(i,t)=1/cmat(t,i)-beta*(1-mmat(t,i))/cmat(t+1,i);
    end
end

for i=1:I
    for t=1:T
%        LifeUbymort(t,i)=sum(discount(1:t).*(LifeUadj+Umat(1:t,i))');
        LifeUbymort(t,i)=sum(discountmat(1:t,i)'.*(LifeUadj+Umat(1:t,i))')+discountmat(t,i)*beqUmat(t,i);
    end
end

for i=1:I
    for t=1:T
        if cmat(t,i)<=max(minben,BSQvec(i))*1.01
            borrcon(t,i)=1;
        else borrcon(t,i)=0;
        end
    end
end

shareborrcon=[sum(borrcon')/I]';
sum(shareborrcon)/T;

%% Reform setup R1
'R1 analysis'
piR1=0.0037*ones(1,T);
piR1tfactor=0*ones(1,T);
for t=2:T
    piR1tfactor(t)=(1+piR1tfactor(t-1))*(1+piR1(t))-1;
end
%Now, finding [lamb,pi] reform parameters that yield budget balance when
%agents optimize
lb =1*ones(1,T);
ub =[inf]*ones(1,T);
BpvdiffR1=100;
lambR1=1.00;
while abs(BpvdiffR1)>cutoff
    if abs(BpvdiffR1)>50
        lambR1=lambR1-sign(BpvdiffR1)*0.01
    elseif abs(BpvdiffR1)>10
        lambR1=lambR1-sign(BpvdiffR1)*0.001
    else lambR1=lambR1-sign(BpvdiffR1)*0.0001
    end
         for i=1:I
            for t=1:T
                BR1mat(t,i)=BSQvec(i)*lambR1*(1+piR1tfactor(t));
            end
         end
            for i=1:I
                m=mmat(:,i);
                discount=discountmat(:,i);
                pbbalive=(pbbalivemat(:,i));
                pbbdie=(pbbdiemat(:,i));
                A=Avec(i);
                BR1=BR1mat(:,i);
                DB=DBmat(:,i);
                beqmot=beqmotvec(i);
                guess=cmat(:,i);
                [z,fval,exitflag,output,lambda]=fmincon('socsecobj051214',guess,[],[],[],[],lb,ub,...
                    'socsecconstr051214',options,m,pbbalive,pbbdie,BR1,DB,A,G,T,discount,pvfactor,R,gamma,crra,beqmot,epsilon,pos,minben);
                for t=1:T
                        cR1(t)=z(t);
                        UR1(t)=  1/(1-gamma)*(cR1(t)^(1-gamma)-crra);
%                         UR1(t)=  log(cR1(t));
                end
                    AssetsR1(1)=A;
                        for t=1:T-1
                            AssetsR1(t+1)=(AssetsR1(t)+DB(t)+max(minben,BR1(t))-cR1(t))*R;
                            beqUR1(t)=beqmot*1/(1-epsilon)*((pos+AssetsR1(t))^(1-epsilon)-crra);
                        end
                beqUR1(T)=beqmot*1/(1-epsilon)*((pos+Assets(T)+DB(T)+max(minben,BR1(T))-c(T))^(1-epsilon)-crra);

                %EUR1=sum((LifeUadj+UR1).*pbbalive'.*discount);    
                EUR1=sum((LifeUadj+UR1).*pbbalive'.*discount')+sum(beqUR1.*pbbdie'.*discount');    
                cmatR1(:,i)=cR1';
                UmatR1(:,i)=UR1';
                beqUmatR1(:,i)=beqUR1';
                EUmatR1(i)=EUR1;
                BmatR1(:,i)=BR1';
                AssetsmatR1(:,i)=AssetsR1';

            end

            BpvdiffR1step1=sum((pbbalivemat.*(BmatR1-BSQmat))');
            BpvdiffR1=sum(pvfactor.*BpvdiffR1step1)
end            
            
            
for i=1:I
    for t=1:T-1
        foctestR1(i,t)=cmatR1(t,i)^(-gamma)-beta(i)*(1-mmat(i))*cmatR1(t+1,i)^(-gamma);
%         foctestR1(i,t)=1/cmatR1(t,i)-beta*(1-mmat(i))/cmatR1(t+1,i);
    end
end

for i=1:I
    for t=1:T
%        LifeUbymortR1(t,i)=sum(discount(1:t).*(LifeUadj+UmatR1(1:t,i))');
        LifeUbymortR1(t,i)=sum(discountmat(1:t,i)'.*(LifeUadj+UmatR1(1:t,i))')+discountmat(t,i)*beqUmatR1(t,i);
    end
end

for i=1:I
    for t=1:T
        if cmatR1(t,i)<=max(minben,BR1mat(t,i))*1.01
           borrconR1(t,i)=1;
        else borrconR1(t,i)=0;
        end
   end
end
shareborrconR1=[sum(borrconR1')/I]';
sum(shareborrconR1)/T;

%% Reform setup R2
piR2=-0.0027*ones(1,T);
piR2tfactor=0*ones(1,T);
for t=2:T
    piR2tfactor(t)=(1+piR2tfactor(t-1))*(1+piR2(t))-1;
end
%Now, finding [lamb,pi] reform parameters that yield budget balance when
%agents optimize
lb =1*ones(1,T);
ub =[inf]*ones(1,T);
BpvdiffR2=100;
lambR2=1.00;
while abs(BpvdiffR2)>cutoff
    if abs(BpvdiffR2)>50
        lambR2=lambR2-sign(BpvdiffR2)*0.01
    elseif abs(BpvdiffR2)>10
        lambR2=lambR2-sign(BpvdiffR2)*0.001
    else lambR2=lambR2-sign(BpvdiffR2)*0.0001
    end
         for i=1:I
            for t=1:T
                BR2mat(t,i)=BSQvec(i)*lambR2*(1+piR2tfactor(t));
            end
         end       
            for i=1:I
                m=mmat(:,i);
                discount=discountmat(:,i);
                pbbalive=(pbbalivemat(:,i));
                pbbdie=(pbbdiemat(:,i));
                A=Avec(i);
                BR2=BR2mat(:,i);
                DB=DBmat(:,i);
                beqmot=beqmotvec(i);
                guess=cmat(:,i);
                [z,fval,exitflag,output,lambda]=fmincon('socsecobj051214',guess,[],[],[],[],lb,ub,...
                    'socsecconstr051214',options,m,pbbalive,pbbdie,BR2,DB,A,G,T,discount,pvfactor,R,gamma,crra,beqmot,epsilon,pos,minben);
                for t=1:T
                        cR2(t)=z(t);
                        UR2(t)=  1/(1-gamma)*(cR2(t)^(1-gamma)-crra);     
%                         UR2(t)=  log(cR2(t));     
                end
                    AssetsR2(1)=A;
                        for t=1:T-1
                            AssetsR2(t+1)=(AssetsR2(t)+DB(t)+max(minben,BR2(t))-cR2(t))*R;
                            beqUR2(t)=beqmot*1/(1-epsilon)*((pos+AssetsR2(t))^(1-epsilon)-crra);
                        end
               beqUR2(T)=beqmot*1/(1-epsilon)*((pos+Assets(T)+DB(T)+max(minben,BR2(T))-c(T))^(1-epsilon)-crra);

                %Total expected utility for i
                %EUR2=sum((LifeUadj+UR2).*pbbalive'.*discount);    
                EUR2=sum((LifeUadj+UR2).*pbbalive'.*discount')+sum(beqUR2.*pbbdie'.*discount');    
                cmatR2(:,i)=cR2';
                UmatR2(:,i)=UR2';
                beqUmatR2(:,i)=beqUR2';
                EUmatR2(i)=EUR2;
                BmatR2(:,i)=BR2';
                AssetsmatR2(:,i)=AssetsR2';

            end            
            
            BpvdiffR2step1=sum((pbbalivemat.*(BmatR2-BSQmat))');
            BpvdiffR2=sum(pvfactor.*BpvdiffR2step1)
end            
                        
for i=1:I
    for t=1:T-1
        foctestR2(i,t)=cmatR2(t,i)^(-gamma)-beta(i)*(1-mmat(i))*cmatR2(t+1,i)^(-gamma);
%         foctestR2(i,t)=1/cmatR2(t,i)-beta*(1-mmat(i))/cmatR2(t+1,i);
    end
end

for i=1:I
    for t=1:T
%        LifeUbymortR2(t,i)=sum(discount(1:t).*(LifeUadj+UmatR2(1:t,i))');
        LifeUbymortR2(t,i)=sum(discountmat(1:t,i)'.*(LifeUadj+UmatR2(1:t,i))')+discountmat(t,i)*beqUmatR2(t,i);
    end
end

for i=1:I
    for t=1:T
        if cmatR2(t,i)<=max(minben,BR2mat(t,i))*1.01
           borrconR2(t,i)=1;
        else borrconR2(t,i)=0;
        end
   end
end
shareborrconR2=[sum(borrconR2')/I]';
sum(shareborrconR2)/T;


%% Reform setup R3
%Commented-out variant with no FL to test whether it's the v-shape
%or the redistribution that makes this proposal attractive
         for i=1:I
            for t=1:10
                piR3mat(t,i)=-0.0027 ;
%                 piR3mat(t,i)=0 ;
            end
            for t=11:20
                piR3mat(t,i)=-0.0027+.05/10*(mean(BSQvec)/(BSQvec(i)));
%                 piR3mat(t,i)=0+.05/10*(mean(BSQvec)/(BSQvec(i)));
            end
            for t=21:30
                piR3mat(t,i)=-0.0027 ;
%                 piR3mat(t,i)=0 ;
            end
            for t=31:T
                piR3mat(t,i)=-0.0027+.05/10*(mean(BSQvec)/(BSQvec(i)));
%                 piR3mat(t,i)=0+.05/10*(mean(BSQvec)/(BSQvec(i)));
            end
         end
piR3tfactor=0*ones(T,I);
for i=1:I
    for t=2:T
    piR3tfactor(t,i)=(1+piR3tfactor(t-1,i))*(1+piR3mat(t,i))-1;
    end
end;

%Now, finding [lamb,pi] reform parameters that yield budget balance when
%agents optimize
options=optimset('TolCon',1e-9,'TolFun',1e-9,'TolX',1e-9,'Display','none','MaxFunEvals',10000000,'MaxIter',2000); 

lb =1*ones(1,T);
ub =[inf]*ones(1,T);
BpvdiffR3=100;
lambR3=1.00;
while abs(BpvdiffR3)>cutoff
    if abs(BpvdiffR3)>50
        lambR3=lambR3-sign(BpvdiffR3)*0.01
    elseif abs(BpvdiffR3)>10
        lambR3=lambR3-sign(BpvdiffR3)*0.001
    else lambR3=lambR3-sign(BpvdiffR3)*0.0001
    end
         for i=1:I
            for t=1:T
                BR3mat(t,i)=BSQvec(i)*lambR3*(1+piR3tfactor(t,i));
            end
         end
       
            for i=1:I
                m=mmat(:,i);
                discount=discountmat(:,i);
                pbbalive=(pbbalivemat(:,i));
                pbbdie=(pbbdiemat(:,i));
                A=Avec(i);
                BR3=BR3mat(:,i);
                DB=DBmat(:,i);
                beqmot=beqmotvec(i);
                guess=cmat(:,i);
                [z,fval,exitflag,output,lambda]=fmincon('socsecobj051214',guess,[],[],[],[],lb,ub,...
                    'socsecconstr051214',options,m,pbbalive,pbbdie,BR3,DB,A,G,T,discount,pvfactor,R,gamma,crra,beqmot,epsilon,pos,minben);
                for t=1:T
                        cR3(t)=z(t);
                        UR3(t)=  1/(1-gamma)*(cR3(t)^(1-gamma)-crra);     
%                         UR3(t)=  log(cR3(t));     
                end
                    AssetsR3(1)=A;
                        for t=1:T-1
                            AssetsR3(t+1)=(AssetsR3(t)+DB(t)+max(minben,BR3(t))-cR3(t))*R;
                            beqUR3(t)=beqmot*1/(1-epsilon)*((pos+AssetsR3(t))^(1-epsilon)-crra);
                        end
                beqUR3(T)=beqmot*1/(1-epsilon)*((pos+Assets(T)+DB(T)+max(minben,BR3(T))-c(T))^(1-epsilon)-crra);

                %Total expected utility for i
%                EUR3=sum((LifeUadj+UR3).*pbbalive'.*discount);    
                EUR3=sum((LifeUadj+UR3).*pbbalive'.*discount')+sum(beqUR3.*pbbdie'.*discount');    
                cmatR3(:,i)=cR3';
                UmatR3(:,i)=UR3';
                beqUmatR3(:,i)=beqUR3';
                EUmatR3(i)=EUR3;
                BmatR3(:,i)=BR3';
                AssetsmatR3(:,i)=AssetsR3';

            end

            BpvdiffR3step1=sum((pbbalivemat.*(BmatR3-BSQmat))');
            BpvdiffR3=sum(pvfactor.*BpvdiffR3step1)
end            
            
            
for i=1:I
    for t=1:T-1
        foctestR3(i,t)=cmatR3(t,i)^(-gamma)-beta(i)*(1-mmat(i))*cmatR3(t+1,i)^(-gamma);
%         foctestR3(i,t)=1/cmatR3(t,i)-beta*(1-mmat(i))/cmatR3(t+1,i);
    end
end

for i=1:I
    for t=1:T
%        LifeUbymortR3(t,i)=sum(discount(1:t).*(LifeUadj+UmatR3(1:t,i))');
        LifeUbymortR3(t,i)=sum(discountmat(1:t,i)'.*(LifeUadj+UmatR3(1:t,i))')+discountmat(t,i)*beqUmatR3(t,i);
    end
end

for i=1:I
    for t=1:T
        if cmatR3(t,i)<=max(minben,BR3mat(t,i))*1.01
           borrconR3(t,i)=1;
        else borrconR3(t,i)=0;
        end
   end
end
shareborrconR3=[sum(borrconR3')/I]';
sum(shareborrconR3)/T;


save latestresults.mat


%% Plots
for t=1:T
    age(t)=64+t;
end
%% Benefit paths
hold off
hold on
box on
% axmax=300000;
% vec45=[0:10000:axmax];
% axis([0 axmax 0 1])
xlabel('Benefits year');
ylabel('Thousands of $2005');
plottype=5;
plotT=T;
plot(age(1:plotT),BSQmat(1:plotT,plottype),'-k','LineWidth',2);
plot(age(1:plotT),BR1mat(1:plotT,plottype),'--k','LineWidth',2);
plot(age(1:plotT),BR2mat(1:plotT,plottype),':k','LineWidth',2); 
% plot (YSBBBB(:,4),margtaxSBBBB(:,4),':k','LineWidth',2); 
% plot (vec45,vec45,'-k'); 
% refline(0,0);
legend('Status Quo','Reform 1 (CPI-E)','Reform 2 (Chained CPI-U)','Location','southwest');
'EUs'
 [EUmat(plottype) EUmatR1(plottype) EUmatR2(plottype)]
'LifeUbymorts'
[age(:) LifeUbymortR1(:,plottype)-LifeUbymort(:,plottype) LifeUbymortR2(:,plottype)-LifeUbymort(:,plottype)] 
%% Benefit paths by decile
hold off
hold on
box on
% axmax=300000;
% vec45=[0:10000:axmax];
% axis([0 axmax 0 1])
xlabel('Benefits year');
ylabel('Thousands of $2005');
plotT=T;

subplot(2,2,1);
hold on
plottype=1;
plot(age(1:plotT),BSQmat(1:plotT,plottype)*.001/scalefactor,'-k','LineWidth',2);
plot(age(1:plotT),BR1mat(1:plotT,plottype)*.001/scalefactor,'--k','LineWidth',2);
plot(age(1:plotT),BR2mat(1:plotT,plottype)*.001/scalefactor,':k','LineWidth',2); 
plot(age(1:plotT),BR3mat(1:plotT,plottype)*.001/scalefactor,'-.k','LineWidth',2); 
title('Lowest decile')

subplot(2,2,2);
hold on
plottype=2;
plot(age(1:plotT),BSQmat(1:plotT,plottype)*.001/scalefactor,'-k','LineWidth',2);
plot(age(1:plotT),BR1mat(1:plotT,plottype)*.001/scalefactor,'--k','LineWidth',2);
plot(age(1:plotT),BR2mat(1:plotT,plottype)*.001/scalefactor,':k','LineWidth',2); 
plot(age(1:plotT),BR3mat(1:plotT,plottype)*.001/scalefactor,'-.k','LineWidth',2); 
title('Second decile')

subplot(2,2,3);
hold on
plottype=5;
plot(age(1:plotT),BSQmat(1:plotT,plottype)*.001/scalefactor,'-k','LineWidth',2);
plot(age(1:plotT),BR1mat(1:plotT,plottype)*.001/scalefactor,'--k','LineWidth',2);
plot(age(1:plotT),BR2mat(1:plotT,plottype)*.001/scalefactor,':k','LineWidth',2); 
plot(age(1:plotT),BR3mat(1:plotT,plottype)*.001/scalefactor,'-.k','LineWidth',2); 
title('Fifth decile')

subplot(2,2,4);
hold on
plottype=10;
plot(age(1:plotT),BSQmat(1:plotT,plottype)*.001/scalefactor,'-k','LineWidth',2);
plot(age(1:plotT),BR1mat(1:plotT,plottype)*.001/scalefactor,'--k','LineWidth',2);
plot(age(1:plotT),BR2mat(1:plotT,plottype)*.001/scalefactor,':k','LineWidth',2); 
plot(age(1:plotT),BR3mat(1:plotT,plottype)*.001/scalefactor,'-.k','LineWidth',2); 
title('Top decile')



%% Benefit change surfaces
hold off;
surf(age(1:plotT),1:I,(1/scalefactor)*(BR1mat(1:plotT,1:I)'-BSQmat(1:plotT,1:I)'))
hold on;
xlabel('Age');
ylabel('Income decile');
zlabel('Change in Benefits ($2005)');
colormap(winter);
freezeColors;
surf(age(1:plotT),1:I,(1/scalefactor)*(BR2mat(1:plotT,1:I)'-BSQmat(1:plotT,1:I)'))
colormap(autumn);
freezeColors;
surf(age(1:plotT),1:I,(1/scalefactor)*(BR3mat(1:plotT,1:I)'-BSQmat(1:plotT,1:I)'))
colormap(summer);
freezeColors;
surf(age(1:plotT),1:I,0*cmat(1:plotT,1:I)')
 colormap(white);
legend('Reform 1 (CPI-E)','Reform 2 (Chained CPI-U)','Reform 3','Location','south');

%% Consumption change surfaces
hold off;
surf(age(1:plotT),1:I,(1/scalefactor)*(cmatR1(1:plotT,1:I)'-cmat(1:plotT,1:I)'))
hold on;
xlabel('Age');
ylabel('Income decile');
zlabel('Change in consumption ($2005)');
colormap(winter);
freezeColors;
surf(age(1:plotT),1:I,(1/scalefactor)*(cmatR2(1:plotT,1:I)'-cmat(1:plotT,1:I)'))
colormap(autumn);
freezeColors;
surf(age(1:plotT),1:I,(1/scalefactor)*(cmatR3(1:plotT,1:I)'-cmat(1:plotT,1:I)'))
colormap(summer);
freezeColors;
surf(age(1:plotT),1:I,0*cmat(1:plotT,1:I)')
 colormap(white);
legend('Reform 1 (CPI-E)','Reform 2 (Chained CPI-U)','Reform 3','Location','south');

%% Consumption change plots

subplot(2,2,1);
hold on
plottype=1;
plot(age(1:plotT),(cmatR1(1:plotT,plottype)'-cmat(1:plotT,plottype)')*.001/scalefactor,'--k','LineWidth',2);
plot(age(1:plotT),(cmatR2(1:plotT,plottype)'-cmat(1:plotT,plottype)')*.001/scalefactor,':k','LineWidth',2);
plot(age(1:plotT),(cmatR3(1:plotT,plottype)'-cmat(1:plotT,plottype)')*.001/scalefactor,'-.k','LineWidth',2); 
title('Lowest decile')

subplot(2,2,2);
hold on
plottype=2;
plot(age(1:plotT),(cmatR1(1:plotT,plottype)'-cmat(1:plotT,plottype)')*.001/scalefactor,'--k','LineWidth',2);
plot(age(1:plotT),(cmatR2(1:plotT,plottype)'-cmat(1:plotT,plottype)')*.001/scalefactor,':k','LineWidth',2);
plot(age(1:plotT),(cmatR3(1:plotT,plottype)'-cmat(1:plotT,plottype)')*.001/scalefactor,'-.k','LineWidth',2); 
title('Second decile')

subplot(2,2,3);
hold on
plottype=5;
plot(age(1:plotT),(cmatR1(1:plotT,plottype)'-cmat(1:plotT,plottype)')*.001/scalefactor,'--k','LineWidth',2);
plot(age(1:plotT),(cmatR2(1:plotT,plottype)'-cmat(1:plotT,plottype)')*.001/scalefactor,':k','LineWidth',2);
plot(age(1:plotT),(cmatR3(1:plotT,plottype)'-cmat(1:plotT,plottype)')*.001/scalefactor,'-.k','LineWidth',2); 
title('Fifth decile')

subplot(2,2,4);
hold on
plottype=10;
plot(age(1:plotT),(cmatR1(1:plotT,plottype)'-cmat(1:plotT,plottype)')*.001/scalefactor,'--k','LineWidth',2);
plot(age(1:plotT),(cmatR2(1:plotT,plottype)'-cmat(1:plotT,plottype)')*.001/scalefactor,':k','LineWidth',2);
plot(age(1:plotT),(cmatR3(1:plotT,plottype)'-cmat(1:plotT,plottype)')*.001/scalefactor,'-.k','LineWidth',2); 
title('Top decile')
%% Consumption  plots

subplot(2,2,1);
hold on
plottype=1;
plot(age(1:plotT),(cmat(1:plotT,plottype)')*.001/scalefactor,'-k','LineWidth',2);
plot(age(1:plotT),(cmatR1(1:plotT,plottype)')*.001/scalefactor,'--k','LineWidth',2);
plot(age(1:plotT),(cmatR2(1:plotT,plottype)')*.001/scalefactor,':k','LineWidth',2);
plot(age(1:plotT),(cmatR3(1:plotT,plottype)')*.001/scalefactor,'-.k','LineWidth',2); 
title('Lowest decile')

subplot(2,2,2);
hold on
plottype=2;
plot(age(1:plotT),(cmat(1:plotT,plottype)')*.001/scalefactor,'-k','LineWidth',2);
plot(age(1:plotT),(cmatR1(1:plotT,plottype)')*.001/scalefactor,'--k','LineWidth',2);
plot(age(1:plotT),(cmatR2(1:plotT,plottype)')*.001/scalefactor,':k','LineWidth',2);
plot(age(1:plotT),(cmatR3(1:plotT,plottype)')*.001/scalefactor,'-.k','LineWidth',2); 
title('Second decile')

subplot(2,2,3);
hold on
plottype=5;
plot(age(1:plotT),(cmat(1:plotT,plottype)')*.001/scalefactor,'-k','LineWidth',2);
plot(age(1:plotT),(cmatR1(1:plotT,plottype)')*.001/scalefactor,'--k','LineWidth',2);
plot(age(1:plotT),(cmatR2(1:plotT,plottype)')*.001/scalefactor,':k','LineWidth',2);
plot(age(1:plotT),(cmatR3(1:plotT,plottype)')*.001/scalefactor,'-.k','LineWidth',2); 
title('Fifth decile')

subplot(2,2,4);
hold on
plottype=10;
plot(age(1:plotT),(cmat(1:plotT,plottype)')*.001/scalefactor,'-k','LineWidth',2);
plot(age(1:plotT),(cmatR1(1:plotT,plottype)')*.001/scalefactor,'--k','LineWidth',2);
plot(age(1:plotT),(cmatR2(1:plotT,plottype)')*.001/scalefactor,':k','LineWidth',2);
plot(age(1:plotT),(cmatR3(1:plotT,plottype)')*.001/scalefactor,'-.k','LineWidth',2); 
title('Top decile')



%% Utility change surfaces
hold off;
surf(age(1:plotT),1:I,(UmatR1(1:plotT,1:I)'-Umat(1:plotT,1:I)'))
hold on;
xlabel('Age');
ylabel('Income decile');
zlabel('Change in annual utility');
colormap(winter);
freezeColors;
surf(age(1:plotT),1:I,(UmatR2(1:plotT,1:I)'-Umat(1:plotT,1:I)'))
colormap(autumn);
freezeColors;
surf(age(1:plotT),1:I,(UmatR3(1:plotT,1:I)'-Umat(1:plotT,1:I)'))
colormap(summer);
freezeColors;
surf(age(1:plotT),1:I,0*Umat(1:plotT,1:I)')
 colormap(white);   
legend('Reform 1 (CPI-E)','Reform 2 (Chained CPI-U)','Reform 3','Location','south');

%% Expected utility levels
hold off
hold on
box on
xlabel('Lifetime-earnings decile');
ylabel('Expected Utility Differences from Status Quo');
plot(1:10,EUmatR1(1:10)-EUmat(1:10),'--k','LineWidth',2);
plot(1:10,EUmatR2(1:10)-EUmat(1:10),':k','LineWidth',2); 
plot(1:10,EUmatR3(1:10)-EUmat(1:10),'-.k','LineWidth',2); 
plot(1:10,0*EUmat(1:10),'-k','LineWidth',1);
legend('Reform 1 (CPI-E)','Reform 2 (Chained CPI-U)','Reform 3','Location','best');

%% Experienced utility surfaces
hold off;
surf(age(1:plotT),1:I,(LifeUbymortR1(1:plotT,1:I)'-LifeUbymort(1:plotT,1:I)')./LifeUbymort(1:plotT,1:I)')
hold on;
xlabel('Age');
ylabel('Income decile');
zlabel('Change in Retirement Utility');
colormap(winter);
freezeColors;
surf(age(1:plotT),1:I,(LifeUbymortR2(1:plotT,1:I)'-LifeUbymort(1:plotT,1:I)')./LifeUbymort(1:plotT,1:I)')
colormap(autumn);
freezeColors;
surf(age(1:plotT),1:I,(LifeUbymortR3(1:plotT,1:I)'-LifeUbymort(1:plotT,1:I)')./LifeUbymort(1:plotT,1:I)')
colormap(summer);
freezeColors;
surf(age(1:plotT),1:I,0*LifeUbymort(1:plotT,1:I)')
 colormap(white);
legend('Reform 1 (CPI-E)','Reform 2 (Chained CPI-U)','Reform 3','Location','south');

%% Experienced utility  plots

 subplot(2,2,1);
hold on
plottype=1;
% plot(age(1:plotT),(LifeUbymort(1:plotT,plottype)'),'-k','LineWidth',2);
plot(age(1:plotT),(LifeUbymortR1(1:plotT,plottype)'-LifeUbymort(1:plotT,plottype)'),'--k','LineWidth',2);
plot(age(1:plotT),(LifeUbymortR2(1:plotT,plottype)'-LifeUbymort(1:plotT,plottype)'),':k','LineWidth',2);
plot(age(1:plotT),(LifeUbymortR3(1:plotT,plottype)'-LifeUbymort(1:plotT,plottype)'),'-.k','LineWidth',2); 
title('Lowest decile')
% 
subplot(2,2,2);
hold on
plottype=2;
% plot(age(1:plotT),(LifeUbymort(1:plotT,plottype)'),'-k','LineWidth',2);
plot(age(1:plotT),(LifeUbymortR1(1:plotT,plottype)'-LifeUbymort(1:plotT,plottype)'),'--k','LineWidth',2);
plot(age(1:plotT),(LifeUbymortR2(1:plotT,plottype)'-LifeUbymort(1:plotT,plottype)'),':k','LineWidth',2);
plot(age(1:plotT),(LifeUbymortR3(1:plotT,plottype)'-LifeUbymort(1:plotT,plottype)'),'-.k','LineWidth',2); 
title('Second decile')

subplot(2,2,3);
hold on
plottype=5;
% plot(age(1:plotT),(LifeUbymort(1:plotT,plottype)'),'-k','LineWidth',2);
plot(age(1:plotT),(LifeUbymortR1(1:plotT,plottype)'-LifeUbymort(1:plotT,plottype)'),'--k','LineWidth',2);
plot(age(1:plotT),(LifeUbymortR2(1:plotT,plottype)'-LifeUbymort(1:plotT,plottype)'),':k','LineWidth',2);
plot(age(1:plotT),(LifeUbymortR3(1:plotT,plottype)'-LifeUbymort(1:plotT,plottype)'),'-.k','LineWidth',2); 
title('Fifth decile')

subplot(2,2,4);
hold on
plottype=10;
% plot(age(1:plotT),(LifeUbymort(1:plotT,plottype)'),'-k','LineWidth',2);
plot(age(1:plotT),(LifeUbymortR1(1:plotT,plottype)'-LifeUbymort(1:plotT,plottype)'),'--k','LineWidth',2);
plot(age(1:plotT),(LifeUbymortR2(1:plotT,plottype)'-LifeUbymort(1:plotT,plottype)'),':k','LineWidth',2);
plot(age(1:plotT),(LifeUbymortR3(1:plotT,plottype)'-LifeUbymort(1:plotT,plottype)'),'-.k','LineWidth',2); 
title('Top decile')
% 
% 
%% Experienced utility surfaces
hold off;
surf(age(1:plotT),1:I,LifeUbymortR1(1:plotT,1:I)'-LifeUbymort(1:plotT,1:I)')
hold on;
xlabel('Age');
ylabel('Income decile');
zlabel('Change in Retirement Utility');
colormap(winter);
freezeColors;
surf(age(1:plotT),1:I,LifeUbymortR2(1:plotT,1:I)'-LifeUbymort(1:plotT,1:I)')
colormap(autumn);
freezeColors;
surf(age(1:plotT),1:I,0*LifeUbymort(1:plotT,1:I)')
 colormap(white);
legend('Reform 1 (CPI-E)','Reform 2 (Chained CPI-U)','Location','south');

%% Survivorship
hold off;
surf(age(1:plotT),1:I,pbbalivemat(1:plotT,1:I)')
hold on;
xlabel('Age');
ylabel('Income decile');
zlabel('Probability of being alive');
colormap(gray);

%% Survivorship-and-PV-Adjusted consumption changes
sadjcmatR1=1/scalefactor*discountmat.*pbbalivemat.*(cmatR1-cmat);
sadjcmatR2=1/scalefactor*discountmat.*pbbalivemat.*(cmatR2-cmat);
sadjcmatR3=1/scalefactor*discountmat.*pbbalivemat.*(cmatR3-cmat);
hold off;
surf(age(1:plotT),1:I,sadjcmatR1(1:plotT,1:I)')
hold on;
xlabel('Age');
ylabel('Income decile'); 
zlabel('Present value change in consumption, scaled by survivorship probability ($2005)');
colormap(winter);
freezeColors;
surf(age(1:plotT),1:I,sadjcmatR2(1:plotT,1:I)')
colormap(autumn);
freezeColors;
surf(age(1:plotT),1:I,sadjcmatR3(1:plotT,1:I)')
colormap(summer);
freezeColors;
surf(age(1:plotT),1:I,0*sadjcmatR2(1:plotT,1:I)')
 colormap(white);
legend('Reform 1 (CPI-E)','Reform 2 (Chained CPI-U)','Reform 3','Location','south');

%% Welfare weights
hold off;
utilwt=cmat.^(-gamma);
utilwtscaled=cmat.^(-gamma)*1./max(max(utilwt')');

LifeUgamma=3;
for i=1:I
    for t=1:T
    lifeutilmu(t,i)=LifeUbymort(t,i)^(-LifeUgamma); %marginal utility of person of type i who lives t years
    end
end
for i=1:I
    for t=1:T
    pbblifeutil(t,i)=mmat(t,i)*pbbalivemat(t,i); %share of type i who lives t years
    end
end
for i=1:I
    for t=1:T
    lifeutilwt(t,i)=sum(pbblifeutil(t:T,i).*lifeutilmu(t:T,i))/sum(pbblifeutil(t:T,i));%*cmat(t,i)^(-gamma);%average MSWW on people of type i alive in year t
    end
end
for i=1:I
    for t=1:T
    lifeutilwtscaled(t,i)=lifeutilwt(t,i)*1./max(max(lifeutilwt')');
    end
end


for i=1:I
    for t=1:T
        if cmat(t,i)<1.01*BSQmat(t,i)
            elderlypovwt(t,i)=1; %1 in old version, could be cmat(t,i)^(-gamma)
        else elderlypovwt(t,i)=0;
        end
    end
end
for i=1:I
    for t=1:T
    elderlypovwtscaled(t,i)=elderlypovwt(t,i)*1./max(max(elderlypovwt')');
    end
end
for i=1:I
    for t=1:T
        rawlswt(t,i)=0;
    end
end
rawlswt(1,11)=1;
rawlswt(1,1)=1;
for i=1:I
    for t=1:T
    rawlswtscaled(t,i)=rawlswt(t,i)*1./max(max(rawlswt')');
    end
end
hold on;

%% Welfare calcs 
rawlswt=.91
utilwt=1-rawlswt;
SQwtvec=[0.0 	 rawlswt 	 0.00 	 utilwt];
SQwt=SQwtvec(1)*elderlypovwtscaled+SQwtvec(2)*rawlswtscaled+SQwtvec(3)*lifeutilwtscaled+SQwtvec(4)*utilwtscaled;
for i=1:I
    for t=1:T
    SQwtscaled(t,i)=SQwt(t,i)*1./max(max(SQwt')');
    end
end
mixwtvec=[0.0 	 .35 	 0.00 	 .65];
mixwt=mixwtvec(1)*elderlypovwtscaled+mixwtvec(2)*rawlswtscaled+mixwtvec(3)*lifeutilwtscaled+mixwtvec(4)*utilwtscaled;
for i=1:I
    for t=1:T
    mixwtscaled(t,i)=mixwt(t,i)*1./max(max(mixwt')');
    end
end

R1WelfareUtil=sum(sum(utilwtscaled.*(sadjcmatR1/(1/scalefactor)))');
R1WelfareLifetimeutil=sum(sum(lifeutilwtscaled.*(sadjcmatR1/(1/scalefactor)))');
R1WelfareElderlyPoverty=sum(sum(elderlypovwtscaled.*(sadjcmatR1/(1/scalefactor)))');
R1WelfareRawls=sum(sum(rawlswtscaled.*(sadjcmatR1/(1/scalefactor)))');
R1Welfaremix=sum(sum(mixwtscaled.*(sadjcmatR1/(1/scalefactor)))');
R1WelfareSQ=sum(sum(SQwtscaled.*(sadjcmatR1/(1/scalefactor)))');

R2WelfareUtil=sum(sum(utilwtscaled.*(sadjcmatR2/(1/scalefactor)))');
R2WelfareLifetimeutil=sum(sum(lifeutilwtscaled.*(sadjcmatR2/(1/scalefactor)))');
R2WelfareElderlyPoverty=sum(sum(elderlypovwtscaled.*(sadjcmatR2/(1/scalefactor)))');
R2WelfareRawls=sum(sum(rawlswtscaled.*(sadjcmatR2/(1/scalefactor)))');
R2Welfaremix=sum(sum(mixwtscaled.*(sadjcmatR2/(1/scalefactor)))');
R2WelfareSQ=sum(sum(SQwtscaled.*(sadjcmatR2/(1/scalefactor)))');

R3WelfareUtil=sum(sum(utilwtscaled.*(sadjcmatR3/(1/scalefactor)))');
R3WelfareLifetimeutil=sum(sum(lifeutilwtscaled.*(sadjcmatR3/(1/scalefactor)))');
R3WelfareElderlyPoverty=sum(sum(elderlypovwtscaled.*(sadjcmatR3/(1/scalefactor)))');
R3WelfareRawls=sum(sum(rawlswtscaled.*(sadjcmatR3/(1/scalefactor)))');
R3Welfaremix=sum(sum(mixwtscaled.*(sadjcmatR3/(1/scalefactor)))');
R3WelfareSQ=sum(sum(SQwtscaled.*(sadjcmatR3/(1/scalefactor)))');

'util retutil eldpov rawls mix SQ'
[R1WelfareUtil R1WelfareLifetimeutil R1WelfareElderlyPoverty R1WelfareRawls R1Welfaremix R1WelfareSQ]
[R2WelfareUtil R2WelfareLifetimeutil R2WelfareElderlyPoverty R2WelfareRawls R2Welfaremix R2WelfareSQ]
[R3WelfareUtil R3WelfareLifetimeutil R3WelfareElderlyPoverty R3WelfareRawls R3Welfaremix R3WelfareSQ]

%% Plots of welfare weights

subplot(2,2,1);
surf(age(1:plotT),1:I,utilwtscaled(1:plotT,1:I)');
xlabel('Age');
ylabel('Income decile');
zlabel('Annual utilitarian g');
colormap(winter);
freezeColors;
subplot(2,2,2)
surf(age(1:plotT),1:I,rawlswtscaled(1:plotT,1:I)');
% xlabel('Age');
% ylabel('Income decile');
zlabel('Rawlsian g');
colormap(autumn);
freezeColors;
subplot(2,2,3)
surf(age(1:plotT),1:I,SQwtscaled(1:plotT,1:I)');
% xlabel('Age');
% ylabel('Income decile');
zlabel('SQ-optimal g');
colormap(spring);
freezeColors;
subplot(2,2,4)
surf(age(1:plotT),1:I,mixwtscaled(1:plotT,1:I)');
% xlabel('Age');
% ylabel('Income decile');
zlabel('Survey-based g');
colormap(summer);
% legend('Annual utilitarian','Retirement utilitarian','Elderly poverty weight','Rawls','Location','northwest');

%% c-equiv gains
TargetWmat=[R1WelfareUtil   R1WelfareRawls R1Welfaremix
            R2WelfareUtil   R2WelfareRawls R2Welfaremix
            R3WelfareUtil   R3WelfareRawls R3Welfaremix];
weightsmat=[utilwtscaled   rawlswtscaled mixwtscaled];
cfactorguess=1;
lb =0.01;
ub =[inf];
[M,N]=size(TargetWmat);

for m=1:M
    for n=1:N
        lowbound=(n-1)*I+1;
        upbound=n*I;
        weights=weightsmat(:,lowbound:upbound);
        cfactor(m,n)=fsolve('cfactorsolveSS',cfactorguess,options,cmat,TargetWmat(m,n),weights,crra,gamma,pbbalivemat,discountmat,LifeUadj,T,I,p);
    end
end

cfactor

%% Years left
yearsleft=[ 11.45971895	12.0475332	12.67502156	12.67502156	12.67502156	14.06414631	14.8345447	15.662293	16.55333755	17.51444149	14.74898551	15.28198126	16.43504551	17.05980376	17.38539061	17.72026922	17.72026922	17.72026922	19.16084171	22.6307833
            10.7380497	11.3078027	11.91679128	11.91679128	11.91679128	13.26755933	14.01807943	14.82546816	15.69566058	16.63540823	13.93756187	14.45855651	15.58710109	16.19933601	16.51859425	16.84709922	16.84709922	16.84709922	18.26172056	21.67750191
            10.03264314	10.58369828	11.1735081	11.1735081	11.1735081	12.48442764	13.21425312	14.00041657	14.84883984	15.76626098	13.13854687	13.64698199	14.74983165	15.3489255	15.66153855	15.98334807	15.98334807	15.98334807	17.37067762	20.72934864
            9.344441861	9.876165067	10.44611598	10.44611598	10.44611598	11.71568068	12.42398128	13.18803497	14.01374816	14.9078431	12.35284974	12.84814825	13.92408362	14.50939308	14.81503063	15.12980854	15.12980854	15.12980854	16.48844174	19.78689069
            8.674374253	9.186140786	9.735558211	9.735558211	9.735558211	10.96226038	11.64819826	12.38924503	13.19128912	14.06103426	11.58143699	12.06300487	13.1107653	13.68162249	13.97994094	14.28733708	14.28733708	14.28733708	15.61580608	18.8507567
            8.02335802	8.514559464	9.042781348	9.042781348	9.042781348	10.22512553	10.88786183	11.60499825	12.38240222	13.22675587	10.82533456	11.29256321	12.31085067	12.8665647	13.15720778	13.45685857	13.45685857	13.45685857	14.7536337	17.92164361
            7.392353342	7.862403409	8.368785858	8.368785858	8.368785858	9.505299477	10.1439992	10.83632006	11.58810499	12.40601088	10.08565615	10.53792433	11.52540642	12.06526434	12.34786353	12.6393922	12.6393922	12.6393922	13.90288198	17.00033689
            6.782396868	7.230737156	7.71465998	7.71465998	7.71465998	8.803903486	9.417739994	10.08434229	10.80952475	11.5999148	9.363611838	9.800288274	10.75560241	11.2788708	11.55304585	11.83606298	11.83606298	11.83606298	13.06461491	16.08772364
            6.194554566	6.620662782	7.081537661	7.081537661	7.081537661	8.122120486	8.710283127	9.350273356	10.04787229	10.80967295	8.660453378	9.080902385	10.00266624	10.50859593	10.7739572	11.04806288	11.04806288	11.04806288	12.23997121	15.1847755
            5.629868017	6.033268377	6.470549442	6.470549442	6.470549442	7.461151428	8.022856256	8.635361048	9.304408204	10.03655061	7.977421002	8.381010619	9.267838029	9.755671835	10.01182402	10.27661155	10.27661155	10.27661155	11.43013135	14.29252952
            5.089351602	5.469625853	5.882820976	5.882820976	5.882820976	6.822215528	7.356717016	7.940894821	8.580446327	9.281877655	7.315746957	7.701857539	8.552375332	9.021356191	9.267902343	9.522962178	9.522962178	9.522962178	10.63632444	13.41209688
            4.574039911	4.930838325	5.319520342	5.319520342	5.319520342	6.206597275	6.713199758	7.26825216	7.877399584	8.547093712	6.67673661	7.044767895	7.85762928	8.307006485	8.543550975	8.78847359	8.78847359	8.78847359	9.859895501	12.54471786
            4.085002228	4.418055669	4.781874766	4.781874766	4.781874766	5.615665668	6.093736124	6.61892052	7.196803311	7.833772861	6.061806424	6.411185037	7.185083693	7.614119358	7.840270934	8.074649763	8.074649763	8.074649763	9.102344977	11.69179953
            3.623259854	3.932394058	4.271092781	4.271092781	4.271092781	5.050802932	5.499787703	5.9944344	6.540257218	7.143570963	5.47237203	5.802563302	6.536256953	6.944237654	7.159615205	7.383052339	7.383052339	7.383052339	8.365253066	10.85486713
            3.189704743	3.474855648	3.788285391	3.788285391	3.788285391	4.513330082	4.932774577	5.396307396	5.909361506	6.478166425	4.909738681	5.220261612	5.912602902	6.298855485	6.503096004	6.715210199	6.715210199	6.715210199	7.650199374	10.0355083
            2.785086004	3.046314717	3.334452137	3.334452137	3.334452137	4.004493679	4.39406288	4.826020898	5.305707047	5.839252194	4.375110472	4.665552593	5.315520068	5.679427662	5.872194361	6.072629204	6.072629204	6.072629204	6.958773564	9.235386358
            2.410049912	2.647557391	2.910520652	2.910520652	2.910520652	3.525505525	3.885004783	4.285064507	4.73091636	5.228577422	3.86967821	4.139709543	4.74643666	5.087453589	5.268443424	5.45687489	5.45687489	5.45687489	6.292655264	8.45631244
            2.065142796	2.279284561	2.517349918	2.517349918	2.517349918	3.077547497	3.40694463	3.774943832	4.186653439	4.647959685	3.394671331	3.644059161	4.206865024	4.524532622	4.693484267	4.869628726	4.869628726	4.869628726	5.653672052	7.70030593
            1.750715376	1.942014831	2.155632381	2.155632381	2.155632381	2.661674046	2.961122764	3.297086501	3.674532868	4.099198199	2.951291833	3.179917945	3.69834406	3.99231003	4.14901377	4.312637996	4.312637996	4.312637996	5.043758301	6.969575436
            1.466831986	1.635990224	1.825796674	1.825796674	1.825796674	2.278710836	2.548573283	2.85273992	3.196018592	3.583974704	2.540619612	2.748499322	3.222351376	3.492392435	3.636701892	3.787635049	3.787635049	3.787635049	4.464883669	6.266472555
            1.213247226	1.361148429	1.527975726	1.527975726	1.527975726	1.929215758	2.170082256	2.442927339	2.752378561	3.103807525	2.163551196	2.350852677	2.780244272	3.026290506	3.158135416	3.296282226	3.296282226	3.296282226	3.919004153	5.593462044
            0.989408001	1.117120023	1.261999303	1.261999303	1.261999303	1.613462862	1.826167932	2.068424855	2.344659167	2.660024207	1.820737528	1.987800218	2.373196287	2.595356166	2.714755715	2.840110331	2.840110331	2.840110331	3.408005007	4.953082182
            0.794449103	0.903218301	1.027378134	1.027378134	1.027378134	1.331415579	1.517049003	1.729725228	1.97364527	2.253718551	1.51251561	1.659866158	2.002123022	2.200707652	2.307783667	2.420443594	2.420443594	2.420443594	2.933627798	4.347886493
            0.627178419	0.718417243	0.823274479	0.823274479	0.823274479	1.082682579	1.242593413	1.426980063	1.639796363	1.885681589	1.238836909	1.367200634	1.667598614	1.843143172	1.93813219	2.038311253	2.038311253	2.038311253	2.497380299	3.780362613
            0.48606243	0.561328127	0.648469448	0.648469448	0.648469448	0.866465671	1.002256442	1.159928247	1.343165749	1.556312137	0.999201319	1.109506845	1.369770419	1.52305017	1.60631302	1.694352054	1.694352054	1.694352054	2.100433975	3.25282909
            0.369225978	0.43018935	0.50134203	0.50134203	0.50134203	0.681515106	0.795023353	0.927825641	1.083317223	1.265520674	0.792607893	0.885982595	1.108282746	1.240320657	1.312348044	1.388721704	1.388721704	1.388721704	1.743517773	2.767314812
            0.27447955	0.322883963	0.379875579	0.379875579	0.379875579	0.52611025	0.619375443	0.729395579	0.859259247	1.012646703	0.617533062	0.695287422	0.882221351	0.994284414	1.055696912	1.121014982	1.121014982	1.121014982	1.426819323	2.325428991
            0.19937904	0.236991501	0.281699991	0.281699991	0.281699991	0.398077097	0.473292574	0.562814678	0.669412475	0.796406577	0.471944417	0.535544262	0.690089159	0.783671109	0.835212256	0.890214008	0.890214008	0.890214008	1.14990544	1.928231979
            0.141314282	0.169871909	0.20416903	0.20416903	0.20416903	0.294845831	0.354297312	0.425741133	0.511619729	0.614882756	0.353353543	0.404380475	0.529820519	0.606609732	0.6491314	0.694672046	0.694672046	0.694672046	0.911672851	1.576118523
            0.0976178	0.118774247	0.144466983	0.144466983	0.144466983	0.213546277	0.259540726	0.315387848	0.38320327	0.4655619	0.258906565	0.299008441	0.398837359	0.460670302	0.495110305	0.532139342	0.532139342	0.532139342	0.710338399	1.268726067
            0.065680392	0.080957302	0.099732574	0.099732574	0.099732574	0.151131791	0.185922178	0.228634868	0.281066264	0.345421378	0.185505514	0.216340393	0.294145376	0.342947812	0.370300647	0.399832825	0.399832825	0.399832825	0.543474296	1.004879927
            0.043041364	0.053786824	0.067161706	0.067161706	0.067161706	0.104486629	0.130194767	0.162129325	0.201783011	0.251004979	0.129915788	0.153090792	0.212419472	0.250135464	0.271415946	0.294494458	0.294494458	0.294494458	0.408028233	0.782502334
            0.027478787	0.034838526	0.044122654	0.044122654	0.044122654	0.070561986	0.089108839	0.112433522	0.141747937	0.17856826	0.088907965	0.105919883	0.150144203	0.178659697	0.194862796	0.212517877	0.212517877	0.212517877	0.300423201	0.598612089
            0.017098688	0.022006425	0.028284587	0.028284587	0.028284587	0.046546493	0.05960332	0.076236164	0.097404974	0.124323387	0.05944279	0.071630901	0.103831168	0.124904782	0.13696816	0.150177726	0.150177726	0.150177726	0.216787165	0.449505599];

Assetsmat./yearsleft;        

% share borr con when die
diezeroassets=sum(p.*sum(pbblifeutil.*borrcon))
%% mixed map

%% Experienced utility surfaces
hold off;
surf(age(1:plotT),1:I,mixwtscaled(1:plotT,1:I)')
hold on;
xlabel('Age');
ylabel('Income decile');
zlabel('Mixed criterion g');
colormap(gray);
freezeColors;

%% u'(c)  plots

subplot(2,2,1);
hold on
plottype=1;
plot(age(1:plotT),(utilwtscaled(1:plotT,plottype)'),'-k','LineWidth',2);
title('Lowest decile')
axis([60 100 0 1])

subplot(2,2,2);
hold on
plottype=2;
plot(age(1:plotT),(utilwtscaled(1:plotT,plottype)'),'-k','LineWidth',2);
title('Second decile')
axis([60 100 0 1])

subplot(2,2,3);
hold on
plottype=5;
plot(age(1:plotT),(utilwtscaled(1:plotT,plottype)'),'-k','LineWidth',2);
title('Fifth decile')
axis([60 100 0 1])

subplot(2,2,4);
hold on
plottype=10;
plot(age(1:plotT),(utilwtscaled(1:plotT,plottype)'),'-k','LineWidth',2);
title('Top decile')
axis([60 100 0 1])

%% c-equiv gains
TargetUmat=Umat;
weightsmat=[utilwtscaled lifeutilwtscaled elderlypovwtscaled rawlswtscaled mixwtscaled];
cfactorguess=1;
lb =0.01;
ub =[inf];
[M,N]=size(TargetWmat);

for m=1:M
    for n=1:N
        lowbound=(n-1)*20+1;
        upbound=n*20;
        weights=weightsmat(:,lowbound:upbound);
        cfactor(m,n)=fsolve('cfactorsolveSS',cfactorguess,options,cmat,TargetWmat(m,n),weights,crra,gamma,pbbalivemat,discount,LifeUadj,T,I,p);
    end
end

cfactor


%% converting du to dc for revision
for t=1:T
    for i=1:I
        cchangeR1(t,i)=((LifeUbymortR1(t,i)-LifeUbymort(t,i))/(cmatR1(t,i)^(-gamma)))/(sum(discountmat(1:t,i).*cmatR1(1:t,i)));
        cchangeR2(t,i)=((LifeUbymortR2(t,i)-LifeUbymort(t,i))/(cmatR2(t,i)^(-gamma)))/(sum(discountmat(1:t,i).*cmatR2(1:t,i)));
        cchangeR3(t,i)=((LifeUbymortR3(t,i)-LifeUbymort(t,i))/(cmatR3(t,i)^(-gamma)))/(sum(discountmat(1:t,i).*cmatR3(1:t,i)));
    end
end

        
subplot(2,2,1);
hold on
plottype=1;
plotT=35;
% plot(age(1:plotT),(LifeUbymort(1:plotT,plottype)'),'-k','LineWidth',2);
plot(age(1:plotT),(cchangeR1(1:plotT,plottype)'),'--k','LineWidth',2);
plot(age(1:plotT),(cchangeR2(1:plotT,plottype)'),':k','LineWidth',2);
plot(age(1:plotT),(cchangeR3(1:plotT,plottype)'),'-.k','LineWidth',2); 
title('Lowest decile')
% 
subplot(2,2,2);
hold on
plottype=2;
% plot(age(1:plotT),(LifeUbymort(1:plotT,plottype)'),'-k','LineWidth',2);
plot(age(1:plotT),(cchangeR1(1:plotT,plottype)'),'--k','LineWidth',2);
plot(age(1:plotT),(cchangeR2(1:plotT,plottype)'),':k','LineWidth',2);
plot(age(1:plotT),(cchangeR3(1:plotT,plottype)'),'-.k','LineWidth',2); 
title('Second decile')

subplot(2,2,3);
hold on
plottype=5;
% plot(age(1:plotT),(LifeUbymort(1:plotT,plottype)'),'-k','LineWidth',2);
plot(age(1:plotT),(cchangeR1(1:plotT,plottype)'),'--k','LineWidth',2);
plot(age(1:plotT),(cchangeR2(1:plotT,plottype)'),':k','LineWidth',2);
plot(age(1:plotT),(cchangeR3(1:plotT,plottype)'),'-.k','LineWidth',2); 
title('Fifth decile')

subplot(2,2,4);
hold on
plottype=10;
% plot(age(1:plotT),(LifeUbymort(1:plotT,plottype)'),'-k','LineWidth',2);
plot(age(1:plotT),(cchangeR1(1:plotT,plottype)'),'--k','LineWidth',2);
plot(age(1:plotT),(cchangeR2(1:plotT,plottype)'),':k','LineWidth',2);
plot(age(1:plotT),(cchangeR3(1:plotT,plottype)'),'-.k','LineWidth',2); 
title('Top decile')
% 
