***********************
* Early Impact of ACA *
* Amanda Kowalski     *
*                     *
* 13 October 2014     *
***********************

**************************************************************
* PURPOSE: Estimate state group regression model (univariate)
*           and generate bootstrapped CIs
**************************************************************

clear
set matsize 2000
set type double
set more off, permanently

local tag "regs_univar"
capture log close `tag'
log using "logs/`tag'.log", replace name(`tag')

timer clear 1
timer on 1

set seed 777

************************************
* Specify data and regression 
************************************

forvalues i = 1/4 {
	local data`i' "output/reg_dataset_`i'.dta"
}

foreach tau in "1000" "1500" "2000" {

	foreach rhs in "dir_enf" "stex" "glitches" "mcaid" "gf" "cr" "gi" "firm_ct" {

		local regression "reg w_full_`tau' `rhs' [aweight = coverage]"

		forvalues n = 1/4 {
			local data = "`data`n''"
			
			local round ".01"
			local reps "1000"

************************************
* Bootstrap by block and present results
************************************

	set matsize 11000
	matrix allreps=[.]
	foreach i of num 1/`reps' {
		use "`data'", clear
		destring, ignore(",") replace
		*Exclude CA, MA, NJ from analysis
		drop if inlist(state, "CA*", "CA", "MA*", "MA", "NJ*", "NJ")
		qui bsample
		qui `regression'
		display "i=`i'"
		qui matrix current=e(b)
		qui if (`i'==1) matrix allreps=e(b)
		qui if (`i'>1) matrix allreps=[allreps \ current]
		}
	local consnumber=colsof(allreps)
	matname allreps constant, column(`consnumber') explicit
	clear
	svmat allreps, names(col)
	
	local i=1
	local allvar ""
	foreach var of varlist _all {
		local allvar "`allvar' `var'"
		replace `var'=. if `var'==0
		egen l90`var'=pctile(`var'), p(5)
		egen u90`var'=pctile(`var'), p(95)
		egen l95`var'=pctile(`var'), p(2.5)
		local lb`var'=l95`var' in 1
		local lb`var' : display %9.2f `lb`var''
		egen u95`var'=pctile(`var'), p(97.5)
		local ub`var'=u95`var' in 1
		local ub`var' : display %9.2f `ub`var''
		egen l99`var'=pctile(`var'), p(0.5)
		egen u99`var'=pctile(`var'), p(99.5)
		gen onestar`var'=( (l90`var'<0 & u90`var'<0) | (l90`var'>0 & u90`var'>0) )
		local onestar`var'=onestar`var' in 1	
		gen twostar`var'=( (l95`var'<0 & u95`var'<0) | (l95`var'>0 & u95`var'>0) )
		local twostar`var'=twostar`var' in 1	
		gen threestar`var'=( (l99`var'<0 & u99`var'<0) | (l99`var'>0 & u99`var'>0) )
		local threestar`var'=threestar`var' in 1	
		*drop l90`var' u90`var' l95`var' u95`var' l99`var' u99`var' onestar`var' twostar`var' threestar`var'
		}
	
	use "`data'", clear
	destring, ignore(",") replace
	drop if inlist(state, "CA*", "CA", "MA*", "MA", "NJ*", "NJ")
	`regression'

	qui foreach var of local allvar {
		local coeff`var'=_b[_cons]
		capture local coeff`var'=_b[`var']
		local coeff`var' : display %9.2f `coeff`var''
		}

	gen variables=""
	gen coefficients=""
	local i=0
	qui foreach var of local allvar {
		local i=`i'+2
		local j=`i'-1
		replace variables="`var'" in `j'
		
		replace coefficients="c`coeff`var''" in `j'
		replace variables="`var'_ci" in `i'
		replace coefficients="[`lb`var'',`ub`var'']" in `i'
		if (`onestar`var''==1)	replace coefficients="[`lb`var'',`ub`var'']*" in `i'
		if (`twostar`var''==1)	replace coefficients="[`lb`var'',`ub`var'']**" in `i'
		if (`threestar`var''==1) replace coefficients="[`lb`var'',`ub`var'']***" in `i'
		}	

	keep variables coefficients
	keep in 1/`i'

	*Add leading zero
	qui replace coefficients=subinstr(coefficients,  "[."  ,  "[0."  ,1)
	qui replace coefficients=subinstr(coefficients,  "[-."  ,  "[-0."  ,1)
	qui replace coefficients=subinstr(coefficients,  ",."  ,  ",0."  ,1)
	qui replace coefficients=subinstr(coefficients,  ",-."  ,  ",-0."  ,1)
	qui replace coefficients=subinstr(coefficients,  "c."  ,  "0."  ,1)
	qui replace coefficients=subinstr(coefficients,  "c-."  ,  "-0."  ,1)
	qui replace coefficients=subinstr(coefficients,  "c"  ,  ""  ,1)

	*Remove spaces
	replace coefficients = subinstr(coefficients, " ", "", .)
	
	list variables coefficients, clean noheader noobs
	display "`reps' bootstrap replications"
	
	*Save output
	save "output/regs/`tag'/regs_`n'_`tau'_`rhs'.dta", replace
	
	*Timer
	qui timer off 1
	qui timer list 1
	display `r(t1)'/60 " minutes to run" 
	}
}
}

log close `tag'
