***********************
* Early Impact of ACA *
* Amanda Kowalski     *
*                     *
* 13 October 2014     *
***********************

*****************************************
* PURPOSE: Plot graphs for presentation *
*		i.   State group graphs *
*		ii.  State graphs       *
*****************************************

clear
set matsize 2000
set type double
set more off, permanently

local tag "graphs_presentation"
capture log close `tag'
log using "logs/`tag'.log", replace name(`tag')

set scheme kate

*************************
* i. State group graphs *
*************************
* local stategrouplist "gf cr gi st_mkpl implmd dir_enf glitches firm_ct"
local stategrouplist "dir_enf glitches_alt"
foreach var of local stategrouplist {

	*Import data
	use "data/processed/coll_by_`var'.dta", clear
	replace tI1 = tI1 / 1000
	
	*Set time-series for graphs
	if "`var'" != "glitches_alt" {
		encode `var'_label, gen(code)
	}
	else if "`var'" == "glitches_alt" {
		encode glitches_label, gen(code)
	}
	xtset code yrqtr
	
	foreach v in "P" "AC" "I" {
		*Titles
		local titleP	"Premium"
		local titleAC	"Average Cost"
		local titleI	"Coverage"
		local ytitleP	"Monthly Average, $"
		local ytitleAC	"Monthly Average, $"
		local ytitleI	"Monthly Average, millions of persons"
		
		*y-axis labels for AC, P
		if "`var'" != "glitches_alt" {
			local yminP  = 100
			local ymedP  = 100
			local ymaxP  = 300
			local yminAC = 100
			local ymedAC = 100
			local ymaxAC = 300
			local yminI  = 0
			local ymedI  = 5.0
			local ymaxI  = 10
		}
		else if "`var'" == "glitches_alt" {
			local yminP  = 150
			local ymedP  = 100
			local ymaxP  = 350
			local yminAC = 150
			local ymaxAC = 350
			local ymedAC = 100
			local yminI  = 0
			local ymedI  = 0.75
			local ymaxI  = 1.50
		}

		*Legend names -- use different names for firm_ct
		if "`var'" == "firm_ct" {
			local legend1 "Above-Median"
			local legend2 "Below-Median"
		}
		else {
			local legend1 "States With"
			local legend2 "States Without"
		}
		
		*Generate graph
		if "`var'" != "glitches_alt" {
			twoway (tsline t`v'1 if code == 2, recast(connected) lwidth(thick) msize(medium)) ///
				   (tsline t`v'1 if code == 3, recast(connected) lwidth(thick) msize(medium) lpattern(dash)), ///
					xlabel(,labsize(vlarge)) ///
					xtitle("") ylabel(`ymin`v''(`ymed`v'')`ymax`v'', grid gmax format(%15.0fc) labsize(vlarge)) ///
					ytitle("`ytitle`v''", size(large) height(7))  ///
					legend(label(1 "`legend1'") label(2 "`legend2'") size(vlarge) region(lwidth(none)))
		}
		else if "`var'" == "glitches_alt" {
			twoway (tsline t`v'1 if code == 1, recast(connected) lwidth(thick) msize(medium)) ///
			   	   (tsline t`v'1 if code == 2, recast(connected) lwidth(thick) msize(medium) lpattern(dash)), ///
					xlabel(,labsize(vlarge)) ///
					xtitle("") ylabel(`ymin`v''(`ymed`v'')`ymax`v'', grid gmax format(%15.0fc) labsize(vlarge)) ///
					ytitle("`ytitle`v''", size(large) height(7))  ///
					legend(label(1 "`legend1'") label(2 "`legend2'") size(vlarge) region(lwidth(none)))
		}
		graph export `var'_`v'_ppt.png, replace width(5120)
	}
}

********************
* ii. State graphs *
********************
use "data/processed/collapse_data.dta", clear

*Set time-series for graphs
encode state_ab, gen(code)
xtset code yrqtr

* local statelist "TX NY FL IL CT DC"
local statelist "NY CT DC IL MI"
foreach state of local statelist {
	foreach v in "P" "AC" "I" {
		*Titles
		local titleP	"Premium"
		local titleAC	"Average Cost"
		local titleI	"Coverage"
		local ytitleP	"Monthly Average, $"
		local ytitleAC	"Monthly Average, $"
		local ytitleI	"Monthly Average, '000s of Persons"
		
		*y-axis labels for AC, P
		local yminP  = 100
		local ymedP  = 150
		local ymaxP  = 400
		local yminAC = 100
		local ymedAC = 150
		local ymaxAC = 400
		local yminI  = 0
		local ymedI  = 750
		local ymaxI  = 1500
		
		*Generate graph
		tsline t`v'1 if state_ab == "`state'", ///
			recast(connected) lwidth(thick) msize(small) ///
			xlabel(,labsize(vlarge)) ///
			xtitle("") ylabel(`ymin`v''(`ymed`v'')`ymax`v'', grid gmax format(%15.0fc) labsize(vlarge)) ///
			ytitle("`ytitle`v''", size(large) height(7))
		
		*NY, CT, DC Coverage (different axis scaling)
		if "`v'" == "I" & "`state'" == "NY" {
			tsline t`v'1 if state_ab == "`state'", ///
				recast(connected) lwidth(thick) msize(medium) ///
				xlabel(,labsize(vlarge)) ///
				xtitle("") ylabel(0(250)500, grid gmax format(%15.0fc) labsize(vlarge)) ///
				ytitle("`ytitle`v''", size(large) height(7))
		}
		else if "`v'" == "I" & "`state'" == "CT" {
			tsline t`v'1 if state_ab == "`state'", ///
				recast(connected) lwidth(thick) msize(medium) ///
				xlabel(,labsize(vlarge)) ///
				xtitle("") ylabel(0(75)150, grid gmax format(%15.0fc) labsize(vlarge)) ///
				ytitle("`ytitle`v''", size(large) height(7))
		}
		else if "`v'" == "I" & "`state'" == "DC" {
			tsline t`v'1 if state_ab == "`state'", ///
				recast(connected) lwidth(thick) msize(medium) ///
				xlabel(,labsize(vlarge)) ///
				xtitle("") ylabel(0(20)40, grid gmax format(%15.0fc) labsize(vlarge)) ///
				ytitle("`ytitle`v''", size(large) height(7))
		}
		else if "`v'" == "I" & "`state'" == "IL" {
			tsline t`v'1 if state_ab == "`state'", ///
				recast(connected) lwidth(thick) msize(medium) ///
				xlabel(,labsize(vlarge)) ///
				xtitle("") ylabel(0(300)600, grid gmax format(%15.0fc) labsize(vlarge)) ///
				ytitle("`ytitle`v''", size(large) height(7))
		}
		else if "`v'" == "I" & "`state'" == "MI" {
			tsline t`v'1 if state_ab == "`state'", ///
				recast(connected) lwidth(thick) msize(medium) ///
				xlabel(,labsize(vlarge)) ///
				xtitle("") ylabel(0(250)500, grid gmax format(%15.0fc) labsize(vlarge)) ///
				ytitle("`ytitle`v''", size(large) height(7))
		}
		graph export `state'_`v'_ppt.png, replace width(5120)
	}
}

log close
