***********************
* Early Impact of ACA *
* Amanda Kowalski     *
*                     *
* 13 October 2014     *
***********************

*************************************
* PURPOSE: Plot graphs for appendix *
*               i.   State graphs   *
*************************************

clear
set matsize 2000
set type double
set more off, permanently

local tag "graphs_appendix"
capture log close `tag'
log using "logs/`tag'.log", replace name(`tag')

set scheme kate

*******************
* i. State graphs *
*******************

use "data/processed/collapse_data.dta", clear

rename yrqtr yq
format yq %tq

rename state_ab state

gen e = tenr2 / 10^3
gen e_imp = tenr1 / 10^3
gen P = tP2
gen P_imp = tP1
gen C = tAC2
gen C_imp = tAC1

*Scale mm to MONTHLY average
gen mm = tmm2 / 10^3 / 3
gen mm_imp = tmm1 / 10^3 / 3

*Label variables
label var e "E (raw)"
label var e_imp "E"
label var mm "I (raw)"
label var mm_imp "I"
label var P "P (raw)"
label var P_imp "P"
label var C "C (raw)"
label var C_imp "C"
label var yq ""

encode state, gen(state_c)

*Order data
sort state state_c yq
order state state_c yq

compress

*Set panel data
xtset state_c yq

*Change to output directory
cd "graphs/appendix"

local titlee	"Enrollment"
local titlemm 	"Coverage"
local titleP	"Premium"
local titleC	"Average Cost"

levelsof state, local(states)
foreach state of local states {
	local i = 0
	local mkgraph "graph combine"
	foreach var in "e" "mm" "P" "C" {
		local i = `i' + 1
		tsline `var'_imp `var' ///
			if state == "`state'", ///
			title("`title`var''") ///
			subtitle("`state'") ///
			ylabel(#3) ///
			xtitle("") ///
			recast(connected) ///
			legend(region(lwidth(none))) ///
			name(graph`i', replace)
		local mkgraph "`mkgraph' graph`i'"
	}
	`mkgraph'
	graph export "`state'.eps", replace
}

!find . -name "*.eps" -exec epstopdf {} \;
!rm -f "raw_v_imp_graphs.pdf"
!pdftk *.pdf cat output "raw_v_imp_graphs.pdf"

cd ../..

log close `tag'
