***********************
* Early Impact of ACA *
* Amanda Kowalski     *
*                     *
* 13 October 2014     *
***********************

**********************************************************
* PURPOSE: Collapse data to state and state-group levels *
*		i.   State level collapse                *
*		ii.  State-group level collapse          *
**********************************************************

clear
set matsize 2000
set type double
set more off, permanently

local tag "data_collapse"
capture log close `tag'
log using "logs/`tag'.log", replace name(`tag')

***************************
* i. State level collapse *
***************************
use "data/intermediate/data_allocated.dta", clear

rename state state_ab
drop yrqtr
rename yq yrqtr

*Merge firm data
merge m:1 id using "data/intermediate/firms_exch.dta"
assert _merge != 1
keep if _merge == 3
drop _merge

*Collapse
collapse (sum) tenr1 = e_imp ///
	 (sum) tmm1 = mm_imp ///
	 (sum) tp1agg = p_imp ///
	 (sum) tc1agg = c_imp ///
	 (sum) tenr2 = e ///
	 (sum) tmm2 = mm ///
	 (sum) tp2agg = p ///
	 (sum) tc2agg = c ///
	 (mean) firm_exch ///
	 (mean) HMO, ///
	 by(yrqtr yr qtr state_ab)

*Variations to "base" model

*Q1 ONLY
gen tenr3  = tenr1
gen tmm3   = tmm1
gen tp3agg = tp1agg
gen tc3agg = tc1agg
foreach v in "tenr3" "tmm3" "tp3agg" "tc3agg" {
	replace `v' = . if yrqtr == yq(2014, 2)
}

*Q2 ONLY
gen tenr4  = tenr1
gen tmm4   = tmm1
gen tp4agg = tp1agg
gen tc4agg = tc1agg
foreach v in "tenr4" "tmm4" "tp4agg" "tc4agg" {
	replace `v' = . if yrqtr == yq(2014, 1)
}

*Compute averages
forval k = 1/4 {
	*Premium
	gen tp`k' = tp`k'agg / tmm`k' * 10^3
	gen tP`k' = tp`k'
	*Average Cost
	gen tc`k' = tc`k'agg / tmm`k' * 10^3
	gen tAC`k' = tc`k'
	*Coverage
	gen tam`k'= tmm`k' / 3
	gen tI`k' = tam`k' / 10^3
	*Enrollment
	gen tE`k' = tenr`k' / 10^3
}

*Merge state-group data
merge 1:1 state_ab yr qtr using "data/intermediate/unins_cr_gi.dta"
assert _merge != 1
keep if _merge == 3
drop _merge

*Merge population data
merge m:1 state_name yr using "data/intermediate/popdata.dta"
assert _merge != 1
keep if _merge == 3
drop _merge state_name state_n

*nonma
gen nonma = 1
replace nonma = 2 if state_ab == "MA"

*exenroll
merge m:1 state_ab using "data/intermediate/aspe_appendix_e.dta"
assert _merge == 3
drop _merge

*Replace st_mkpl implmd with new data
drop st_mkpl implmd
merge m:1 state_ab using "data/intermediate/grouping.dta"
assert _merge == 3
drop _merge
drop state_name

*Save
compress
save "data/processed/collapse_data.dta", replace

**********************************
* ii. State-group level collapse *
**********************************

*Import data
use "data/intermediate/data_allocated.dta", clear

rename state state_ab
drop yrqtr

*Merge data on firms with plans on exchanges
merge m:1 id using "data/intermediate/firms_exch.dta"
assert _merge != 1
keep if _merge == 3
drop _merge

*Obtain firm count by state-quarter
gen firm_ct = mm_imp > 0 & mm_imp != .
bysort state_ab yq : egen state_firm_ct = sum(firm_ct) if yq == yq(2013,4)
bysort state_ab : egen num_firms = max(state_firm_ct)
drop firm_ct
gen firm_ct = num_firms > 6 // 6 is the median number of firms across states

/* Merge state-group data */
merge m:1 state_ab yr qtr using "data/intermediate/unins_cr_gi.dta"
assert _merge != 1
keep if _merge == 3
drop _merge

*Merge population data
merge m:1 state_name yr using "data/intermediate/popdata.dta"
assert _merge != 1
keep if _merge == 3
drop _merge state_name state_n

*nonma
gen nonma = 1
replace nonma = 2 if state_ab == "MA"

*exenroll
merge m:1 state_ab using "data/intermediate/aspe_appendix_e.dta"
assert _merge == 3
drop _merge

*Replace st_mkpl implmd with new data
drop st_mkpl implmd
merge m:1 state_ab using "data/intermediate/grouping.dta"
assert _merge == 3
drop _merge
drop state_name

*States with unreliable data
local droplist "CA NJ"
foreach s of local droplist {
	drop if state_ab=="`s'"
}

*Need an uninsurance variable that has one value for each yr qtr state_n
bysort yr qtr state_ab: gen unins_st=unins if _n==1
bysort yr qtr state_ab: gen pop_st=pop if _n==1
bysort yr qtr state_ab: gen elig_st=elig if _n==1
bysort yr qtr state_ab: gen subselig_st=subselig if _n==1
bysort yr qtr state_ab: gen medicaidelig_st=medicaidelig if _n==1
bysort yr qtr state_ab: gen exenroll_st=exenroll if _n==1

rename grndf gf
rename comm_rat cr
rename guar_iss gi

gen cg = cr * gi

foreach v of varlist gf cr gi st_mkpl implmd cg dir_enf glitches firm_ct {
	replace `v'=2 if state_ab=="MA"
}
replace nonma = 0 if state_ab=="MA"

*Prepare labels
gen str50 gi_label="States with Guaranteed Issue"
gen str50 gf_label="States with Non-Grandfathered Plans"
gen str50 cr_label="States with Community Rating"
gen str50 st_mkpl_label="States with State Exchange"
gen str50 implmd_label="States with Medicaid Expansion"
gen str60 cg_label="States with Community Rating and Guaranteed Issue"
gen str50 nonma_label="States other than MA"
gen dir_enf_label="States with Direct Enforcement"
gen glitches_label="States with Exchange Glitches"
gen firm_ct_label = "States with Number of Insurers"

replace gf_label="States without Non-Grandfathered Plans" if gf==0
replace gi_label="States without Guaranteed Issue" if gi==0
replace cr_label="States without Community Rating" if cr==0
replace st_mkpl_label="States without State Exchange" if st_mkpl==0
replace implmd_label="States without Medicaid Expansion" if implmd==0
replace cg_label="States without Community Rating or Guaranteed Issue" if cg==0
replace nonma_label="MA" if nonma==0  
replace dir_enf_label="States without Direct Enforcement" if dir_enf == 0
replace glitches_label="States without Exchange Glitches" if glitches == 0
replace firm_ct_label = "States without Number of Insurers" if firm_ct == 0

local coll_var "gf cr gi st_mkpl implmd cg nonma dir_enf glitches firm_ct"

foreach var of local coll_var {
replace `var'_label="MA" if `var'==2 
}

local coll_var "gf cr gi st_mkpl implmd cg nonma dir_enf glitches glitches_alt firm_ct"
foreach var of local coll_var {
	
	preserve
	
	if "`var'" != "glitches_alt" {
		rename yq yrqtr

		collapse (sum) tmm1 = mm_imp ///
			 (sum) tp1agg = p_imp ///
			 (sum) tc1agg = c_imp ///
			 (sum) tmm2 = mm ///
			 (sum) tp2agg = p ///
			 (sum) tc2agg = c ///
			 (sum) unins=unins_st ///
			 (sum) pop=pop_st ///
			 (sum) elig=elig_st ///
			 (sum) subselig=subselig_st ///
			 (sum) medicaidelig=medicaidelig_st ///
			 (sum) exenroll=exenroll_st ///
			 (mean)`var'=`var' ///
			 (mean) firm_exch ///
			 (mean) HMO, ///
			 by(yrqtr yr qtr `var'_label)
	}
	else if "`var'" == "glitches_alt" {
		*Restrict to only state exchange (marketplace) states 
		keep if st_mkpl == 1
		rename yq yrqtr

		collapse (sum) tmm1 = mm_imp ///
			 (sum) tp1agg = p_imp ///
			 (sum) tc1agg = c_imp ///
			 (sum) tmm2 = mm_ ///
			 (sum) tp2agg = p ///
			 (sum) tc2agg = c ///
			 (sum) unins=unins_st ///
			 (sum) pop=pop_st ///
			 (sum) elig=elig_st ///
			 (sum) subselig=subselig_st ///
			 (sum) medicaidelig=medicaidelig_st ///
			 (sum) exenroll=exenroll_st ///
			 (mean) glitches=glitches ///
			 (mean) firm_exch ///
			 (mean) HMO, ///
			 by(yrqtr yr qtr glitches_label)
	}
	
	*Variations to "base" model
	
	*Q1 ONLY
	gen tmm3   = tmm1
	gen tp3agg = tp1agg
	gen tc3agg = tc1agg
	foreach v in "tmm3" "tp3agg" "tc3agg" {
		replace `v' = . if yrqtr == yq(2014, 2)
	}

	*Q2 ONLY
	gen tmm4   = tmm1
	gen tp4agg = tp1agg
	gen tc4agg = tc1agg
	foreach v in "tmm4" "tp4agg" "tc4agg" {
		replace `v' = . if yrqtr == yq(2014, 1)
	}
	
	*Compute average price and cost
	forval k = 1/4 {
		gen tp`k' = tp`k'agg / tmm`k' * 10^3
		gen tP`k' = tp`k'
		gen tc`k' = tc`k'agg / tmm`k' * 10^3
		gen tAC`k' = tc`k'
		gen tam`k'= tmm`k' / 3
		gen tI`k' = tam`k' / 10^3 // Average enrollment (000s) (computed from quarterly member months)
	}

	compress
	save "data/processed/coll_by_`var'.dta", replace

	restore
}

log close `tag'
