***********************
* Early Impact of ACA *
* Amanda Kowalski     *
*                     *
* 13 October 2014     *
***********************

*************************************************
* PURPOSE: Master ACA .do file                  *
*		i.   Set up directory structure *
*		ii.  Run all ACA .do files      *
*************************************************

clear
clear matrix
set matsize 2000
set more off, permanently

local tag "welfare_results"
capture log close `tag'
log using "logs/`tag'.log", replace name(`tag')

*************************
*Set parameters

*Set groups of states
*local stategrouplist "states cr gi cg gf st_mkpl implmd nonma"
local stategrouplist "states"

*Set variables to use - code requires all of these
local vlist "c p am"

*This sets the sample
local samplenotes "Preferred sample is k=1"
local klist "1/4"

*Set the penalty - specify ANNUAL penalty, which is later converted to monthly
* since all other variables are expressed monthly

local pirange "1000(500)2000"

*This is specified much earlier in the data construction but I assert that it's true
local firstyear=2008

*************************
*Run regressions

forvalues pi12 = `pirange' {
local i=1
local pi = `pi12' / 12
foreach stategroup of local stategrouplist {

	clear
	
	if "`stategroup'"~="states" {
		use "data/processed/coll_by_`stategroup'.dta", clear
		ds
		assert yr>=`firstyear'
		*keep if yr>=`firstyear'

		*This list gives us the values within each stategroup category
		replace `stategroup'_label="`stategroup'" if `stategroup'==1
		replace `stategroup'_label="not`stategroup'" if `stategroup'==0
		replace `stategroup'_label="ma" if `stategroup'==2
		levels `stategroup'_label, local(`stategroup'groups) 

		*Only one group for national average
		if ("`stategroup'"=="nonma") local `stategroup'groups "`stategroup'"

	}

	if "`stategroup'"=="states" {
		use "data/processed/collapse_data.dta", clear
		ds
		keep if yr>=`firstyear'

		levels state, local(`stategroup'groups) 	
		
		*These states are not included in the collapsed data files
		*I also include MA since it's not included
		local weirdlist "CA NJ"
		gen weird=0
		foreach weird of local weirdlist {
			replace weird=1 if state_ab=="`weird'"
		}
	}
	
	gen after=(yr==2014)
	gen during=(yr==2013 & qtr==4)
	*gen rightbefore=(yr==2013 & qtr==2) /*All values calculated relative to this quater */

	forvalues k=`klist' {
		foreach v of local vlist {
			foreach g of local `stategroup'groups {
				display "t`v'`k'`g', i=`i'"
				*Baseline regressions
				if "`stategroup'"~="states" {
				  regress t`v'`k' after yrqtr i.qtr if `stategroup'_label=="`g'" & ~during
				}
				if "`stategroup'"=="states" {
				  regress t`v'`k' after yrqtr i.qtr if state=="`g'" & ~during
				}
				*eststo t`v'`k'`g'
				local `v'delta`k'`g'=_b[after]
				display "`v'delta`k'`g'=  ``v'delta`k'`g''"
				
				*Store other quantities needed for welfare
				*Post-period - use actual data
				if "`stategroup'"~="states" {
				  sum t`v'`k' if after & `stategroup'_label=="`g'"
				}
				if "`stategroup'"=="states" {
					if inlist("`v'", "c", "p") {
						sum t`v'`k' [aweight = tam`k'] if after & state=="`g'"
					}
					else {
						sum t`v'`k' if after & state=="`g'"
					}
				}				
				if `k' == 1 | `k' ==2 {
					assert r(N)==2
				  }
				  else if `k' == 3 | `k' == 4 {
					assert r(N)==1
				  }
				local `v'post`k'`g'=r(mean)
				display "`v'post`k'`g'=  ``v'post`k'`g''"
				
				*Arrive at pre-period numbers by subtracting the change from 2014Q1
				local `v'pre`k'`g'=``v'post`k'`g'' - ``v'delta`k'`g''
				display "`v'pre`k'`g'=  ``v'pre`k'`g''"
				
				*Add an indicator for state regulation
				if "`stategroup'"=="states" {
				  sum guar_iss if state=="`g'"
				  assert r(Var)==0
				  local gidum`k'`g'=r(mean)
				  sum comm_rat if state=="`g'"
				  assert r(Var)==0
				  local crdum`k'`g'=r(mean)				  
				  sum grndf if state=="`g'"
				  assert r(Var)==0
				  local gfdum`k'`g'=r(mean)
				  sum st_mkpl if state=="`g'"
				  assert r(Var)==0
				  local st_mkpldum`k'`g'=r(mean)
				  sum implmd if state=="`g'"
				  assert r(Var)==0
				  local implmddum`k'`g'=r(mean)
				  sum nonma if state=="`g'"
				  assert r(Var)==0
				  local nonmadum`k'`g'=r(mean)
				  
				  sum weird if state=="`g'"
				  assert r(Var)==0
				  local weirddum`k'`g'=r(mean)
				  				  
				  display "gidum`k'`g'=`gidum`k'`g''"
				  display "crdum`k'`g'=`crdum`k'`g''"
				  display "gfdum`k'`g'=`gfdum`k'`g''"
				 
				  sum pop if state=="`g'" & after
				  assert r(N)==2
				  local pop`k'`g'=r(mean)

				  sum exenroll if state=="`g'" & after
				  assert r(N)==2
				  local exenroll`k'`g'=r(mean)
				  
				}
				if "`stategroup'"~="states" {
				  local gidum`k'`g'=.
				  local crdum`k'`g'=.
				  local gfdum`k'`g'=.				  
				  local st_mkpldum`k'`g'=.				  
				  local implmddum`k'`g'=.				  
				  local nonmadum`k'`g'=.				  
				  local weirddum`k'`g'=.				  
				  display "gidum`k'`g'=`gidum`k'`g''"
				  display "crdum`k'`g'=`crdum`k'`g''"
				  display "gfdum`k'`g'=`gfdum`k'`g''"

				  sum pop if `stategroup'_label=="`g'" & after
				  assert r(N)==2
				  local pop`k'`g'=r(mean)

				  sum exenroll if `stategroup'_label=="`g'" & after
				  assert r(N)==2
				  local exenroll`k'`g'=r(mean)
				}
				
				local i=`i' +1				
			}
			
		}      
	}

}

*************************
*Calculate changes in welfare

forvalues k=`klist' {
	local row=1
	foreach stategroup of local stategrouplist {
		if "`stategroup'"~="states" {
		 display "*******stategroup=`stategroup'***********"
		 *I change the order to the order that I want
		 local `stategroup'groups "`stategroup' not`stategroup' ma"
		 *Use this one if you want to omit MA from table
		 local `stategroup'groups "`stategroup' not`stategroup'"
		 *Only one group for national average
		 if ("`stategroup'"=="nonma") local `stategroup'groups "`stategroup'"
		}
		if "`stategroup'"=="states" {
		 display "*******state-level***********"
		}
		foreach g of local `stategroup'groups {
			*Report all quantities used so that math can be easily checked
			display "group=`g' , k=`k'"
			display "cr=`crdum`k'`g'' , gi=`gidum`k'`g'', gf=`gfdum`k'`g''"   
			display "pi=`pi' (monthly penalty)" 
			
			display "cpre`k'`g'=  `cpre`k'`g''"
			display "cpost`k'`g'=  `cpost`k'`g''"
			display "ppre`k'`g'=  `ppre`k'`g''"
			display "ppost`k'`g'=  `ppost`k'`g''"
			display "ampre`k'`g'=  `ampre`k'`g''"
			display "ampost`k'`g'=  `ampost`k'`g''"
			display "amdelta`k'`g'=  `amdelta`k'`g''"

			*For the table only, report coverage in thousands 
			*(if you use this for calculations, you'd need to redo thousands conversion)
			local amprethou`k'`g'=`ampre`k'`g''/1000
			local ampostthou`k'`g'=`ampost`k'`g''/1000
			
			*Post-reform coverage level under pre-reform markup, in terms of am
			local ammarkup`k'`g'=max(0,`ampre`k'`g''+  ///
				`pi'*((`ampost`k'`g''-`ampre`k'`g'')/ ///
				((`cpost`k'`g''-`cpre`k'`g'') - ((`ppost`k'`g''-`pi')-`ppre`k'`g''))))
			display "ammarkup`k'`g'=  `ammarkup`k'`g''"
			
			*Net welfare gain in terms o/f am
			local wamnet`k'`g'=(`ppre`k'`g''-`cpre`k'`g'')*(`ammarkup`k'`g''-`ampre`k'`g'') ///
				- ((`cpost`k'`g''-`cpre`k'`g'')/(`ampost`k'`g''-`ampre`k'`g''))* ///
				(`ampre`k'`g''+ (`ammarkup`k'`g''-`ampre`k'`g''))* ///
				(`ammarkup`k'`g''-`ampre`k'`g'')+ ///
				((0.5* ((`ppost`k'`g''-`pi')-`ppre`k'`g''))/(`ampost`k'`g''-`ampre`k'`g''))* ///
				((`ammarkup`k'`g''-`ampre`k'`g'')^2)
			display "wamnet`k'`g'=  `wamnet`k'`g''"
			
			*Net welfare gain in terms of am as a percent of post-reform total cost
			local wamnetoverc`k'`g'=(`wamnet`k'`g''/(`cpost`k'`g''*`ampost`k'`g''))*100
			display "wamnetoverc`k'`g'=  `wamnetoverc`k'`g''"

			*Net welfare gain in am per am per post-reform
			local wamnetpere`k'`g'=`wamnet`k'`g''/`ampost`k'`g''
			display "wamnetpere`k'`g'=  `wamnetpere`k'`g''"
			
			*Full welfare gain in terms of am
			local wamfull`k'`g'=(`ppre`k'`g''-`cpre`k'`g'')*(`ampost`k'`g''-`ampre`k'`g'') ///
				-((`cpost`k'`g''-`cpre`k'`g'')*(`ampre`k'`g''+ (`ampost`k'`g''-`ampre`k'`g''))) ///
				+(0.5*((`ppost`k'`g''-`pi')-`ppre`k'`g'')*(`ampost`k'`g''-`ampre`k'`g''))
			display "wamfull`k'`g'=  `wamfull`k'`g''"

			*Full welfare gain in terms of am as a percent of post-reform total cost
			local wamfulloverc`k'`g'=(`wamfull`k'`g''/(`cpost`k'`g''*`ampost`k'`g''))*100
			display "wamfulloverc`k'`g'=  `wamfulloverc`k'`g''"

			*Full welfare gain in am per am per post-reform
			local wamfullpere`k'`g'=`wamfull`k'`g''/`ampost`k'`g''
			display "wamfullpere`k'`g'=  `wamfullpere`k'`g''"
			
			*Optimal health insurance coverage in terms of member months
			*Note that corner solution is different - not a maximum of one person!
			local amopt`k'`g' =max(0,`ampre`k'`g''+ ///
				(((`ppre`k'`g''-`cpre`k'`g'')*(`ampost`k'`g''-`ampre`k'`g'') - ///
				((`cpost`k'`g''-`cpre`k'`g'')*`ampre`k'`g'') )/ ///
				(2*(`cpost`k'`g''-`cpre`k'`g'')-((`ppost`k'`g''-`pi')-`ppre`k'`g''))) )
			display "amopt`k'`g'=  `amopt`k'`g''"
						
			*Optimal penalty from model in terms of member months
			local piamopt`k'`g'=(`ppost`k'`g''-`ppre`k'`g'')-(`cpost`k'`g''-`cpre`k'`g'') + ///
				(((`cpost`k'`g''-`cpre`k'`g'') - ((`ppost`k'`g''-`pi')-`ppre`k'`g''))/ ///
				(`ampost`k'`g''-`ampre`k'`g''))*(`amopt`k'`g''-`ampre`k'`g'')
			display "piamopt`k'`g'=  `piamopt`k'`g''"

			*Optimal penalty from model in terms of member months times 12
			local pi12amopt`k'`g'=`piamopt`k'`g''*12
						
			*Final enrollment as percentage of population
			local amoverpop`k'`g'=(`ampost`k'`g''/`pop`k'`g'')*100
			display "amoverpop`k'`g'=  `amoverpop`k'`g''"

			*Exchange enrollment as a percentage of am
			local exoveram`k'`g'=(`exenroll`k'`g''/`ampost`k'`g'')*100
			display "exoveram`k'`g'=  `exoveram`k'`g''"

			
			*Indicator for adverse selection
			if (((`cpost`k'`g''-`cpre`k'`g'')<0) & ((`ampost`k'`g''-`ampre`k'`g'')>=0) ) ///
			  local adverse`k'`g'=1
			if (((`cpost`k'`g''-`cpre`k'`g'')>=0) & ((`ampost`k'`g''-`ampre`k'`g'')>=0) ) ///
			 local adverse`k'`g'=0
			if (((`cpost`k'`g''-`cpre`k'`g'')<0) & ((`ampost`k'`g''-`ampre`k'`g'')<0) ) ///
			  local adverse`k'`g'=0
			if (((`cpost`k'`g''-`cpre`k'`g'')>=0) & ((`ampost`k'`g''-`ampre`k'`g'')<0) ) ///
			 local adverse`k'`g'=1
			
			*Indicator for change in markups
			if (((`ppost`k'`g''-`cpost`k'`g'')-(`ppre`k'`g''-`cpre`k'`g''))>0) ///
			local markupincrease`k'`g'=1
			if (((`ppost`k'`g''-`cpost`k'`g'')-(`ppre`k'`g''-`cpre`k'`g''))<=0) ///
			local markupincrease`k'`g'=0
			
			*Indicator for increase in coverage
			if ((`ampost`k'`g''-`ampre`k'`g'')>0) ///
			local amincrease`k'`g'=1			
			if ((`ampost`k'`g''-`ampre`k'`g'')<=0) ///
			local amincrease`k'`g'=0			
			
			*Indicator for downward sloping demand at all values of the penalty
			local ddownall`k'`g'=0
			forvalues someannualpi = `pirange' {
				display `someannualpi'	
				if (((`ppre`k'`g''-(`ppost`k'`g''-(`someannualpi'/12)))/(`ampost`k'`g''-`ampre`k'`g''))>0) ///
				local ddownall`k'`g'=1
				}
			display "ddownall`k'`g'=  `ddownall`k'`g''"
			
			display ""		
			
			*Specify rows for the first table here
			local entrylist "weirddum crdum gidum gfdum st_mkpldum implmddum" 
			local entrylist "`entrylist' amprethou ampostthou" 
			local entrylist "`entrylist' ppre ppost cpre cpost adverse markupincrease"
			local entrylist "`entrylist' exoveram amoverpop"
			local matcol=1
			foreach entry of local entrylist {
				*First row of the table
				if (`matcol'==1) matrix currenta=[``entry'`k'`g'']
				if (`matcol'==1) local colnamelist="`entry'"
				*matrix list current
				if (`matcol'>1) matrix currenta=[currenta , ``entry'`k'`g'']
				if (`matcol'>1) local colnamelist "`colnamelist' `entry'"
				local matcol=`matcol'+1
			}
			
			matrix colnames currenta = `colnamelist'
			matrix rownames currenta = "`g'"
			
			if (`row'==1) matrix allrowsa=[currenta]
			if (`row'>1) matrix allrowsa=[allrowsa \ currenta]
			*matrix list allrows
			*local row=`row'+1 \*This is done at the end of the final matrix*\

			*Specify rows for the next table here
			local entrylist "adverse markupincrease amincrease ddownall" 
			local entrylist "`entrylist' pi12amopt wamnetpere wamfullpere"
			local matcol=1
			foreach entry of local entrylist {
				*First row of the table
				if (`matcol'==1) matrix current=[``entry'`k'`g'']
				if (`matcol'==1) local colnamelist="`entry'"
				*matrix list current
				if (`matcol'>1) matrix current=[current , ``entry'`k'`g'']
				if (`matcol'>1) local colnamelist "`colnamelist' `entry'"
				local matcol=`matcol'+1
			}
			
			matrix colnames current = `colnamelist'
			matrix rownames current = "`g'"
			
			if (`row'==1) matrix allrows=[current]
			if (`row'>1) matrix allrows=[allrows \ current]
			*matrix list allrows
			local row=`row'+1			
			
		}
	}
	matrix results`k'tablea=[allrowsa]
	matrix results`k'tableb=[allrows]
}



*Report results in a table for each sample
*local pi12 =`pi' * 12
forvalues k=`klist' {
	matrix list results`k'tablea
	display "Notes: k=`k'"
	matrix list results`k'tableb
	display "Notes: k=`k'  pi==`pi' pi12=`pi12'"
	
	*Table A
	drop _all
	svmat2 double results`k'tablea, names(col) rnames(state)
	order state
	compress
	save "welfareresultsa_k`k'_pi`pi12'.dta", replace
	
	*Table B
	drop _all
	svmat2 double results`k'tableb, names(col) rnames(state)
	order state
	compress
	save "welfareresultsb_k`k'_pi`pi12'.dta", replace
	
	*Merge
	merge 1:1 state using "welfareresultsa_k`k'_pi`pi12'.dta"
	assert _merge == 3
	drop _merge
	rename pi12amopt	pi_`pi12'
	rename wamnetpere	w_sel_`pi12'
	rename wamfullpere	w_full_`pi12'
	save "welfareresults_k`k'_pi`pi12'.dta", replace
	
	*Erase component files
	erase "welfareresultsa_k`k'_pi`pi12'.dta"
	erase "welfareresultsb_k`k'_pi`pi12'.dta"
	}
display "`samplenotes'"
}

*Combine welfare results from distinct values of pi for each k
forvalues k = `klist' {
	local i = 1
	forvalues pi12 = `pirange' {
		if `i' == 1 {
			use "welfareresults_k`k'_pi`pi12'.dta", clear
		}
		else {
			merge 1:1 state using "welfareresults_k`k'_pi`pi12'.dta"
			assert _merge == 3
			drop _merge
		}
		
		erase "welfareresults_k`k'_pi`pi12'.dta"
		local i = `i' + 1
	}
	*Merge more variables
	rename state state_ab
	merge 1:1 state_ab using "data/intermediate/grouping.dta"
	assert _merge == 3
	drop _merge
	
	rename state_ab state
	merge 1:1 state using "data/intermediate/firm_ct.dta"
	assert _merge == 3
	drop _merge
	
	save "output/welfareresults_`k'.dta", replace
}

*Construct regression data set for each k
forvalues k = `klist' {
	use "output/welfareresults_`k'.dta", clear
	
	*Rename variables
	rename st_mkpl stex
	rename implmd mcaid
	rename gfdum gf
	rename crdum cr
	rename gidum gi
	rename ampostthou coverage
	rename markupincrease markupincr
	rename amincrease coverageincr
	
	*Reorder variables
	keep  state dir_enf stex glitches mcaid gf cr gi firm_ct coverage ///
	      adverse markupincr coverageincr ddownall *_1000 *_1500 *_2000
	order state dir_enf stex glitches mcaid gf cr gi firm_ct coverage ///
	      adverse markupincr coverageincr ddownall *_1000 *_1500 *_2000
	compress
	save "output/reg_dataset_`k'.dta", replace
}

*Export welfare results for each k
forvalues k = `klist' {
	use "output/welfareresults_`k'.dta", clear
	
	*Export table as csv
	outsheet using "output/tables/welfareresults_`k'.csv", comma names replace
}

log close `tag'
