***********************
* Early Impact of ACA *
* Amanda Kowalski     *
*                     *
* 13 October 2014     *
***********************

*************************************************
* PURPOSE: Master ACA .do file                  *
*		i.   Set up directory structure *
*		ii.  Run all ACA .do files      *
*************************************************

version 13.1

clear
set matsize 2000
set type double
set more off, permanently

local tag "master"
capture log close _all
log using "`tag'.log", replace name(`tag')

*********************************
* i. Set up directory structure *
*********************************

*WORKING DIRECTORY
cd "/homes/nber/sjmoy/ACA"

*Data
capture mkdir data
cd data
capture mkdir raw
capture mkdir intermediate
capture mkdir processed
cd ..

*Logs
capture mkdir logs

*Graphs
capture mkdir graphs
cd graphs
capture mkdir paper
capture mkdir appendix
capture mkdir presentation
cd ..

*Output
capture mkdir output
cd output
capture mkdir regs
cd regs
capture mkdir regs_joint
capture mkdir regs_univar
cd ..
capture mkdir tables
cd ..

*****************************
* ii. Run all ACA .do files *
*****************************

* 1.	Clean data
*	do "clean_data.do"
	
* 2.	Impute data
*	do "impute_data.do"
	
* 3.	Allocate quarterly data to states
*	do "state_alloc.do"
	
* 4.	Collapse data to state-level
*	do "data_collapse.do"
	
* 5.	Miscellaneous Statistics
*	do "misc.do"

* 6.	Construct graphs
	do "graphs_paper.do"
	do "graphs_appendix.do"
	* "graphs_presentation.do" MUST be run using the Stata GUI.
	*  It cannot be run in batch mode.
	
* 7.	Generate welfare results w/ bootstrapped SEs
	do "welfare_results.do"
	
* 8.	Run regressions
	do "regs_joint.do"
	do "regs_univar.do"

* 9.	Format paper and appendix tables
	do "generate_tables.do"

log close `tag'
