***********************
* Early Impact of ACA *
* Amanda Kowalski     *
*                     *
* 13 October 2014     *
***********************

*****************************************
* PURPOSE: Plot graphs for paper        *
*		i.   State group graphs *
*		ii.  State graphs       *
*****************************************

clear
set matsize 2000
set type double
set more off, permanently

local tag "graphs_paper"
capture log close `tag'
log using "logs/`tag'.log", replace name(`tag')

set scheme kate

*************************
* i. State group graphs *
*************************
local stategrouplist "gf cr gi st_mkpl implmd dir_enf glitches glitches_alt firm_ct"
*local stategrouplist "glitches_alt"
foreach var of local stategrouplist {

	*Import data
	use "data/processed/coll_by_`var'.dta", clear
	
	*Set time-series for graphs
	if "`var'" != "glitches_alt" {
		encode `var'_label, gen(code)
	}
	else if "`var'" == "glitches_alt" {
		encode glitches_label, gen(code)
	}
	xtset code yrqtr
	
	foreach v in "P" "AC" "I" {
		*Titles
		local titleP	"Premium"
		local titleAC	"Average Cost"
		local titleI	"Coverage"
		
		*y-axis labels for AC, P
		if "`var'" != "glitches_alt" {
			local yminP  = 100
			local ymedP  = 100
			local ymaxP  = 300
			local yminAC = 100
			local ymaxAC = 300
			local ymedAC = 100
			local yminI  = 0
			local ymedI  = 5000
			local ymaxI  = 10000
		}
		else if "`var'" == "glitches_alt" {
			local yminP  = 150
			local ymedP  = 100
			local ymaxP  = 350
			local yminAC = 150
			local ymaxAC = 350
			local ymedAC = 100
			local yminI  = 0
			local ymedI  = 750
			local ymaxI  = 1500
		}
		
		*Legend names -- use different names for firm_ct
		if "`var'" == "firm_ct" {
			local legend1 "Above Median"
			local legend2 "Below Median"
		}
		else {
			local legend1 "With"
			local legend2 "Without"
		}
		
		*Generate graph
		if "`var'" != "glitches_alt" {
			twoway (tsline t`v'1 if code == 2, recast(connected) lwidth(medthin) msize(tiny)) ///
				   (tsline t`v'1 if code == 3, recast(connected) lwidth(medthin) msize(tiny) lpattern(dot)), ///
			title("`title`v''", size(medsmall)) xlabel(#4,labsize(small)) ///
			xtitle("") ylabel(`ymin`v''(`ymed`v'')`ymax`v'', grid gmax format(%15.0fc) labsize(small)) ///
			ysize(1.5) ytitle("")  ///
			legend(label(1 "`legend1'") label(2 "`legend2'") size(small) region(lwidth(none))) ///
			saving(t`v'1, replace)
		}
		else if "`var'" == "glitches_alt" {
			twoway (tsline t`v'1 if code == 1, recast(connected) lwidth(medthin) msize(tiny)) ///
				   (tsline t`v'1 if code == 2, recast(connected) lwidth(medthin) msize(tiny) lpattern(dot)), ///
			title("`title`v''", size(huge)) xlabel(#4,labsize(vlarge)) ///
			xtitle("") ylabel(`ymin`v''(`ymed`v'')`ymax`v'', grid gmax format(%15.0fc) labsize(vlarge)) ///
			ysize(1.5) ytitle("")  ///
			legend(label(1 "`legend1'") label(2 "`legend2'") size(vlarge) region(lwidth(none))) ///
			saving(t`v'1, replace)
		}
	}
	
	*Title
	preserve
	if "`var'" != "glitches_alt" {
		keep if code == 2
		local label = `var'_label[1]
		local title = substr("`label'", 13, .)
	}
	else if "`var'" == "glitches_alt" {
		keep if code == 1
		local label = glitches_label[1]
		local title = substr("`label'", 13, .)
		local title "`title' Among States With Exchanges"
	}
	restore
	
	*Generate intermediate graphs for each state group
	if "`var'" != "glitches_alt" {
		graph combine tI1.gph tP1.gph tAC1.gph, col(3) ysize(2) xsize(5) title("`title'", size(medsmall)) saving(`var', replace)
	}
	else if "`var'" == "glitches_alt" {
		graph combine tI1.gph tP1.gph tAC1.gph, col(3) ysize(2) xsize(5) title("`title'", size(huge)) saving(`var', replace)
	}
	
	*Erase component graphs
	foreach v in "AC" "P" "I" {
		erase t`v'1.gph
	}
}

capture erase graphs/paper/bg1.pdf
capture erase graphs/paper/bg2.pdf
capture erase graphs/paper/glitches_alt.pdf

*Build final graphs by groupings, (1 of 2)
graph combine dir_enf.gph st_mkpl.gph glitches.gph implmd.gph, col(1) ysize(8) xsize(5) title("")
graph export bg1.eps, replace logo(off)
!epstopdf bg1.eps
!mv -f bg1.pdf graphs/paper/bg1.pdf

*Build final graphs by groupings, (2 of 2)
graph combine gf.gph cr.gph gi.gph firm_ct.gph, col(1) ysize(8) xsize(5) title("")
graph export bg2.eps, replace logo(off)
!epstopdf bg2.eps
!mv -f bg2.pdf graphs/paper/bg2.pdf

*Build alternative glitches graph
graph combine glitches_alt.gph				 , col(1) ysize(2) xsize(5) title("")
graph export glitches_alt.eps, replace logo(off)
!epstopdf glitches_alt.eps
!mv -f glitches_alt.pdf graphs/paper/glitches_alt.pdf

*Erase component graphs
foreach var of local stategrouplist {
	erase `var'.gph
}

*erase bg1.gph
erase bg1.eps
*erase bg2.gph
erase bg2.eps
erase glitches_alt.eps

********************
* ii. State graphs *
********************
use "data/processed/collapse_data.dta", clear

*Set time-series for graphs
encode state_ab, gen(code)
xtset code yrqtr

local statelist "TX NY FL IL"
foreach state of local statelist {
	foreach v in "P" "AC" "I" {
		*Titles
		local titleP	"Premium"
		local titleAC	"Average Cost"
		local titleI	"Coverage"
		
		*y-axis labels for AC, P
		local yminP  = 100
		local ymedP  = 150
		local ymaxP  = 400
		local yminAC = 100
		local ymedAC = 150
		local ymaxAC = 400
		local yminI  = 0
		local ymedI  = 750
		local ymaxI  = 1500
		
		*Generate graph
		tsline t`v'1 if state_ab == "`state'", ///
			recast(connected) lwidth(medthin) msize(tiny) ///
			title("`title`v''", size(medsmall)) xlabel(#4,labsize(small)) ///
			xtitle("") ylabel(`ymin`v''(`ymed`v'')`ymax`v'', grid gmax format(%15.0fc) labsize(small)) ///
			ysize(1.5) ytitle("")  ///
			saving(t`v'1, replace)
	}
	
	*Title
	local titleTX "Texas"
	local titleNY "New York"
	local titleFL "Florida"
	local titleIL "Illinois"
	
	*Generate intermediate graphs for each state group
	graph combine tI1.gph tP1.gph tAC1.gph, col(3) ysize(2) xsize(5) title("`title`state''", size(medsmall)) saving(`state',replace)
	
	*Erase component graphs
	foreach v in "AC" "P" "I" {
		erase t`v'1.gph
	}
}

*Build final graph, (1 of 1)
capture erase graphs/paper/sg.pdf
graph combine TX.gph NY.gph FL.gph IL.gph, col(1) ysize(8) xsize(5) title("") saving(sg,replace)
graph export sg.eps, replace logo(off)
!epstopdf sg.eps
!mv -f sg.pdf graphs/paper/sg.pdf

*Erase component graphs
foreach state of local statelist {
	erase `state'.gph
}

erase sg.gph
erase sg.eps

log close `tag'
