***********************
* Early Impact of ACA *
* Amanda Kowalski     *
*                     *
* 13 October 2014     *
***********************

****************************************************************
* PURPOSE: Estimate state group regression model (multivariate)
*           and generate bootstrapped CIs
****************************************************************

clear
set matsize 2000
set type double
set more off, permanently

local tag "generate_tables"
capture log close `tag'
log using "logs/`tag'.log", replace name(`tag')

*********************************
* Univariate Regression Results *
*********************************

*Compile univariate regression results
forvalues n = 1/4 {
	foreach tau in "1000" "1500" "2000" {
		foreach rhs in "dir_enf" "stex" "glitches" "mcaid" "gf" "cr" "gi" "firm_ct" {
			use "output/regs/regs_univar/regs_`n'_`tau'_`rhs'.dta", clear
			*Clean and compile
			drop if regexm(variables, "constant")
			assert variables == "`rhs'"    if _n == 1
			assert variables == "`rhs'_ci" if _n == 2
			rename coefficients reg_`n'_`tau'
			tempfile temp`rhs'
			save `temp`rhs''
			if "`rhs'" == "firm_ct" {
				append using `tempcr'
				append using `tempgi'
				append using `tempgf'
				append using `tempstex'
				append using `tempmcaid'
				append using `tempdir_enf'
				append using `tempglitches'
			}
			save "output/regs/regs_univar/regs_`n'_`tau'.dta", replace
		}
	}
}

local i = 1
forvalues n = 1/4 {
	foreach tau in "1000" "1500" "2000" {
		if `i' == 1 {
			use "output/regs/regs_univar/regs_`n'_`tau'.dta", clear
		}
		else {
			merge 1:1 variables using "output/regs/regs_univar/regs_`n'_`tau'.dta"
			assert _merge == 3
			drop _merge
		}
		local i = `i' + 1
	}
}

*Sort rows
local i = 1
gen rowsort = .
foreach var in "dir_enf" "stex" "glitches" "mcaid" "gf" "cr" "gi" "firm_ct" {
	replace rowsort = 2 * `i' - 1	if variables == "`var'"
	replace rowsort = 2 * `i'	if variables == "`var'_ci"
	local i = `i' + 1
}

*Clean output
order variables reg_1_* reg_2_* reg_3_* reg_4_* rowsort
sort rowsort
drop rowsort
compress

*Save and export
save "output/regs/regs_univar/reg_results_univar.dta", replace
outsheet using "output/tables/reg_results_univar.csv", comma names replace

****************************
* Joint Regression Results *
****************************

*Compile joint regression results
local i = 1
forvalues n = 1/4 {
	foreach tau in "1000" "1500" "2000" {
		if `i' == 1 {
			use "output/regs/regs_joint/regs_`n'_`tau'_joint.dta", clear
			rename coefficients reg_`n'_`tau'
		}
		else {
			merge 1:1 variables using "output/regs/regs_joint/regs_`n'_`tau'_joint.dta"
			rename coefficients reg_`n'_`tau'
			assert _merge == 3
			drop _merge
		}
		local i = `i' + 1
	}
}

*Sort rows
local i = 1
gen rowsort = .
foreach var in "dir_enf" "stex" "glitches" "mcaid" "gf" "cr" "gi" "firm_ct" "constant" {
	replace rowsort = 2 * `i' - 1	if variables == "`var'"
	replace rowsort = 2 * `i'	if variables == "`var'_ci"
	local i = `i' + 1
}

*Clean output
order variables reg_1_* reg_2_* reg_3_* reg_4_* rowsort
sort rowsort
drop rowsort
compress

*Save and export
save "output/regs/regs_joint/reg_results_joint.dta", replace
outsheet using "output/tables/reg_results_joint.csv", comma names replace

****************************

log close `tag'
