% varcg_counter.m
% August 2013
% this file is a variant on varcg.m, which spits out counterfactual path of
% a variable after 1 kind of shock, defined over specific time period.

function out  =  varcg_counter(data,VARlags,options)

%========================================================================
% key options for this file:
% options.var=3;                            % variable number for which to construct counterfactual
% options.shock=5;                          % shock number to use in counterfactuals
% options.start=X;                          % period number in VAR series to start counterfactuals
% options.N=15;                             % number of periods in which actual shocks are used
% options.T=24;                             % number of periods for which counterfactuals are generated (shocks=0 when T>N)
%========================================================================
 
%%%  stuff from varcg.m:
 % This file takes data and runs VAR with VARlags # of lags.  It spits out:
 % 1- coefficients:                 out.beta
 % 2- residuals:                    out.eps
 % 3- var-cov matrix of residuals:  out.omega
 % 4- structural shocks:            out.u  [Choleski is default, options.LR=1 uses LR restrictions]
 % 5- IRF's to each structural sh.  out.irf [1 unit is default,  options.stdshock=1 uses 1 std deviation shock, default horizon is 20, else options.irfhor=X]
 % 6- VAR decomposition             out.vdec [default horizon is 20, else options.vdechor=X]
 % 7- counterfactuals               out.counter [default starting date is 1, else options.counterst=X, default horizon is to end of sample, else options.counterhor=X]
 % 8- stdev of irf's                out.sdirf (only if options.irfstd=1, select number of draws via options.Nirfstd=X, else 100)
 
 % other options:
 % options.const: default adds a constant (=0 no constant, 1 constant, 2 linear time trend, 3 quadratic time trend]
 
 %%% data must be in form [x1(t) x1(t-1) ... x1(t-VARlags) x2(t)... xK(t-VARlags)]
 K=cols(data)/(VARlags+1);              % solve for number of variables
 
 for j=1:K
     Y(:,j)=data(:,(j-1)*(VARlags+1)+1);
     X(:,(j-1)*VARlags+1:(j-1)*VARlags+VARlags) = data(:,(j-1)*(VARlags+1)+2:(j-1)*(VARlags+1)+1+VARlags);
 end
 
 if ~isfield(options,'const')
     options.const=1;               % include a constant term as default
 end
% add constant, time trend, quadratic time trend if required.
 if options.const==1    X=[X ones(length(X),1)]; elseif options.const==2 X=[X ones(length(X),1) (1:length(X))']; elseif options.const==3 X=[X ones(length(X),1) (1:length(X))' ((1:length(X)).^2)']; end
 
 %%% BASELINE ESTIMATES OF VAR
 for j=1:K
    eps(:,j)=Y(:,j)-X*( inv(X'*X)*(X'*Y(:,j)) );                        % residuals
    Beta(:,j)=inv(X'*X)*(X'*Y(:,j));                                    % coefficients
end
Omega=cov(eps);                           % VAR-COV matrix of residuals
Xfull=X;

%%% RECOVER STRUCURAL SHOCKS.
if ~isfield(options,'LR') options.LR=0;   end
if options.LR==0                            % get structural shocks via Choleski decomposition as baseline.
    [A, D] = triang(Omega);
    u=(inv(A)*eps')';                       % matrix of orthogonalized structural shocks
else                                        % get structural shocks via LR restrictions...  [ADD THIS AT SOME POINT]
end

%%% PERFORM COUNTERFACTUAL SIMULATIONS 
VarN= options.var;                            % variable number for which to construct counterfactual
ShN = options.shock;                          % shock number to use in counterfactuals
start= options.start;                         % period number in VAR series to start counterfactuals
N   = options.N;                              % number of periods in which actual shocks are used
T   = options.T;                              % number of periods for which counterfactuals are generated (shocks=0 when T>N)
final=start+T-1;

shocks=zeros(T,K);  shocks(1:N,ShN)=u(start:start+N-1,ShN);
Y1=((A*shocks(1,:)'))'; Y=Y1; X1=zeros(1,K*VARlags);
    for i=2:T
        X=[];
        for k=1:K
            X=[X Y1(k) X1(1,(k-1)*VARlags+1:(k-1)*VARlags+VARlags-1)];
        end
        X1=X;
        Y1=X*Beta(1:K*VARlags,:)+((A*shocks(i,:)'))';
        Y=[Y; Y1];
    end
    counter=Y(:,VarN); 


%%% Output
%out.beta=Beta;
%out.eps=eps;
%out.omega=Omega;
%out.u=u;
%out.irf=irf(1:nplot,:,:);
%out.vdec=vardec;
out.counter=counter;

return
 

     
 