% se.m

% This file calculates the standard deviation of impulse responses of
% exogenous shocks in X to Y.

% Based on impulse.m, which takes Y, regresses on X.  Then, assuming X is ordered with
% constant, then lags of X, then lags of exogenous shock (shockpos
% indicates when shock lags enter X), constructs impulse response to a
% one-unit innovation in exogenous shock.  Levelindex=0 means calculate
% irf's in sums, if 1 set in levels.

% NOTE THIS SPECIFICATION ASSUMES CONTEMPORANEOUS SHOCK HAS NO EFFECT ON Y

function [HL_mean, HL_p50, HL_sd , HL_p5, HL_p95] = se_halflife(Y,X,periods,shockpos,its,levelindex);

[T,K]=size(X);
%beta=inv(X'*X)*(X'*Y);
%res=Y-X*beta;
%imp1=impulse1(beta,periods,shockpos,levelindex);      % generates impulse response given new coefficients

ivopt.linear=1;
ivopt.lags=12;

out = iv(zeros(length(X),1),ivopt,Y,X,X);       % this generates estimates of coefficients and var-cov matrix of parameter estimates.
V=out.betacov;                                  % this is variance covariance matrix of parameter estimates.
imp=[];

for it=1:its
    beta1=out.beta+(V^.5)*randn(K,1);   % generate new coefficients drawn from empirical distribution of estimated coefficients
    imp1=impulse1(beta1,periods,shockpos,levelindex);      % generates impulse response given new coefficients
    
    max_imp=max(imp1);
    flag0=imp1>0.5*max_imp;
    mm=find(flag0==1);
    HL=max(mm);
    
    
    imp=[imp ; HL];
end

HL_mean=mean(imp);
HL_p50=prctile(imp,50);
HL_p5=prctile(imp,5);
HL_p95=prctile(imp,95);
HL_sd=std(imp);

return

