% estimation.m

% This file replicates results for Coibion (2009), comparing the effects of
% MP shocks from VAR to those of R&R (2004).
clear all
display(' Output of estimation.m ')

%%% Estimation options
pmeasureVAR=1;                      % select price measure to include in baseline VAR to generate VAR MP shocks: 1 CPI, 2 CPIcore, 3 PPI, 4 annual CPI inflation, 5 annual CPIc inflation, 6 annual PPI inflation
pmeasureIRF=1;                      % select price measure to include in IRF's: 1 CPI, 2 CPIcore, 3 PPI, 4 annual CPI inflation, 5 annual CPIc inflation, 6 annual PPI inflation

%%% What the file runs:
shockindex=0;                       % set to one to plot VAR and R&R shocks together (VAR shock depends on pmeasureVAR, i.e. which measure of prices is included in VAR)
shockcomp=0;                        % set to one to compute different VAR shocks for different measures of price series
comp1=0;                            % set to one to plot impulse responses to MP shocks from VAR and R&R
comp2=0;                            % set to one to plot impulse responses to MP shocks using R&R univariate approach on VAR shocks.
fitindex=1;                         % set to one to plot predicted paths due to MP shocks from VAR and R&R
fitindex1=0;                        % same as fitindex, but feeds R&R shocks into VAR and VAR shocks into R&R
lagsensitivity=0;                   % set to one to assess senstivity of IRF's to lag length
optlag=-0;                           % set to one to test for optimal laglength of R&R and VAR.
outliers=0;                         % test for whether R&R IRF's are driven by outlier

%%%  Run baseline VAR, extract baseline VAR shocks
MPshockdata;                        % load macro data: IP, UE, CPI, CPIc, PPI, FFR, PCOM: 1968:1-1996:12, monthly
RRshock;                            % load MP shock measure from Romer and Romer (2004): uRR 1969:1-1996:12
IP1=makelags(IP,12); PPI1=makelags(PPI,12);  CPI1=makelags(CPI,12); CPIc1=makelags(CPIc,12); PiPPI1=makelags(PiPPI,12);  PiCPI1=makelags(PiCPI,12); PiCPIc1=makelags(PiCPIc,12); UE1=makelags(UE,12);  FFR1=makelags(FFR,12); PCOM1=makelags(PCOM,12);
if pmeasureVAR==1 p=CPI1; elseif pmeasureVAR==2 p=CPIc1; elseif pmeasureVAR==3 p=PPI1; elseif pmeasureVAR==4 p=PiCPI1; elseif pmeasureVAR==5 p=PiCPIc1; else p=PiPPI1; end  % select which measure of prices to include in baseline VAR
dat1=[IP1 UE1 p  FFR1 PCOM1];        
options.irfhor=60; options.vdechor=60;
out1=varcg(dat1,12,options);        % basic VAR uses 12 lags (1 year)                                             
uVAR=out1.u(:,4);                   % this is baseline MP shock measures from VAR

%========================================================================
%   Shock Comparison: plot levels and cumulative shock series
%========================================================================
if shockindex==1
    display('Correlation between Shock Measures')
    z=corr(uVAR,uRR)
    t=1969:1/12:1996+11/12;

    figure(1)
    subplot(2,1,1)
    plot(t,uVAR,'k','Linewidth',2)
    hold on
    plot(t,uRR,'b:','Linewidth',2)
    hold off
    xlim([1969 1996])
    legend('VAR MP Shocks','R&R MP Shocks')

    sumRR(1,1)=uRR(1); sumVAR(1,1)=uVAR(1);
    for j=2:length(uRR)
        sumRR(j,1)=sumRR(j-1,1)+uRR(j);
        sumVAR(j,1)=sumVAR(j-1,1)+uVAR(j);
    end
    display('Correlation between Accumulated Shock Measures')
    z=corr(sumVAR,sumRR)
    subplot(2,1,2)
    plot(t,sumVAR,'k','Linewidth',2)
    hold on
    plot(t,sumRR,'b:','Linewidth',2)
    hold off
    xlim([1969 1996])
    legend('Cumulative VAR MP Shocks','Cumulative R&R MP Shocks')
end

if shockcomp==1
    for pmeasure=1:6
        if pmeasure==1 p=CPI1; elseif pmeasure==2 p=CPIc1; elseif pmeasure==3 p=PPI1; elseif pmeasure==4 p=PiCPI1; elseif pmeasure==5 p=PiCPIc1; else p=PiPPI1; end  % select which measure of prices to include in baseline VAR
        dat1=[IP1(:,1:13) UE1(:,1:13) p(:,1:13) PCOM1(:,1:13) FFR1(:,1:13)];        
        out1=varcg(dat1,12,options);                                                     
        uVAR1(:,pmeasure)=out1.u(:,5);      
    end
    sumVAR1(1,:)=uVAR1(1,:); sumRR(1,1)=uRR(1); 
    for j=2:length(uRR)
        sumRR(j,1)=sumRR(j-1,1)+uRR(j);
        sumVAR1(j,:)=sumVAR1(j-1,:)+uVAR1(j,:);
    end
    display(' Correlations between Shock Measures ')
    display('    CPI       CPIc       PPI      PiCPI      PiCPIc     PiPPI      R&R')
    corr([uVAR1 uRR])
    display(' Correlations between Accumulated Shock Measures ')
    display('    CPI       CPIc       PPI      PiCPI      PiCPIc     PiPPI      R&R')
    corr([sumVAR1 sumRR])
    t=1969:1/12:1996+11/12;
    figure('Name','Comparison of Cumulative Shocks')
    plot(t,[sumVAR1 sumRR])
    xlim([1969 1996])
    legend('CPI','CPIc','PPI','PiCPI','PiCPIc','PiPPI','R&R')
end
        
%=========================================================================
%   Comparing basic impulse responses from VAR and R&R approach
%=========================================================================
if comp1==1
    MPshockdata2;                       % loads data from 1965:1 1996:12
    IP2=makelags(IP,60); CPI2=makelags(CPI,60); CPIc2=makelags(CPIc,60); PPI2=makelags(PPI,60); PiCPI2=makelags(PiCPI,60); PiCPIc2=makelags(PiCPIc,60); PiPPI2=makelags(PiPPI,60); FFR2=makelags(FFR,60); UE2=makelags(UE,60); PCOM2=makelags(PCOM,60); uRR2=makelags(uRR,60); 
    if pmeasureVAR==1 p=CPI2; elseif pmeasureVAR==2 p=CPIc2; elseif pmeasureVAR==3 p=PPI2; elseif pmeasureVAR==4 p=PiCPI2; elseif pmeasureVAR==5 p=PiCPIc2; else p=PiPPI2; end  % select which measure of prices to include in baseline VAR
    dat2=[IP2(:,1:13) UE2(:,1:13) p(:,1:13) FFR2(:,1:13) PCOM2(:,1:13) ];        
    out2=varcg(dat2,12,options);        % basic VAR uses 12 lags (1 year): estimation of VAR and univariate processes start in 1970:1                                             

    figure('Name','Basic Impulse Responses')
    for j=1:6
        subplot(3,2,j)
        if j==1         plot(out2.irf(1:60,1,4),'k','Linewidth',2'); ylim([-0.05 0.01]);
        elseif j==3     plot(out2.irf(1:60,2,4),'k','Linewidth',2'); ylim([-.05 1]);
        elseif j==5     plot(out2.irf(1:60,3,4),'k','Linewidth',2'); ylim([-.04 0.01]);
        end
        if j==2
            irf=impulse(IP2(:,1)-IP2(:,2),[ones(length(uRR2),1) IP2(:,2:25)-IP2(:,3:26) uRR2(:,2:37)],60,26) ;
            irf1=irf;   for i=2:60 irf1(i)=irf1(i-1)+irf(i); end
            plot(irf1,'k','Linewidth',2); ylim([-0.05 0.01]);
        elseif j==4
            irf=impulse(UE2(:,1),[ones(length(uRR2),1) UE2(:,2:25) uRR2(:,2:37)],60,26) ;
            plot(irf,'k','Linewidth',2); ylim([-.05 1]);
        elseif j==6
            irf=impulse(p(:,1),[ones(length(uRR2),1) p(:,2:25) uRR2(:,2:49)],60,26) ;
            plot(irf,'k','Linewidth',2); ylim([-.04 0.01]);
        end
        if j==1 title('VAR Approach'); ylabel('Response of IP'); elseif j==2 title('R&R Approach'); elseif j==3 ylabel('Response of UE'); elseif j==5 ylabel('Response of CPI'); end
         
    end
end

%=========================================================================
%   Plot impulse responses from R&R univariate approach using VAR shocks
%=========================================================================
if comp2==1
    MPshockdata2;                       % loads data from 1965:1 1996:12
    IP2=makelags(IP,60); CPI2=makelags(CPI,60); CPIc2=makelags(CPIc,60); PPI2=makelags(PPI,60); PiCPI2=makelags(PiCPI,60); PiCPIc2=makelags(PiCPIc,60); PiPPI2=makelags(PiPPI,60); FFR2=makelags(FFR,60); UE2=makelags(UE,60); PCOM2=makelags(PCOM,60); uRR2=makelags(uRR,60); 
    if pmeasureVAR==1 p=CPI2; elseif pmeasureVAR==2 p=CPIc2; elseif pmeasureVAR==3 p=PPI2; elseif pmeasureVAR==4 p=PiCPI2; elseif pmeasureVAR==5 p=PiCPIc2; else p=PiPPI2; end  % select which measure of prices to include in baseline VAR
    uVAR2=zeros(length(uRR),1);  uVAR2(49:length(uRR),1)=uVAR; uVAR2=makelags(uVAR2,60);
    
    figure('Name','Impulse Responses using R&R methodology')
    for j=1:6
        subplot(3,2,j)
        if j==1         
            irf=impulse(IP2(:,1)-IP2(:,2),[ones(length(uRR2),1) IP2(:,2:25)-IP2(:,3:26) uVAR2(:,2:37)],60,26) ;
            irf1=irf;   for i=2:60 irf1(i)=irf1(i-1)+irf(i); end
            plot(irf1,'k','Linewidth',2); ylim([-0.05 0.01]);
        elseif j==2
            irf=impulse(IP2(:,1)-IP2(:,2),[ones(length(uRR2),1) IP2(:,2:25)-IP2(:,3:26) uRR2(:,2:37)],60,26) ;
            irf1=irf;   for i=2:60 irf1(i)=irf1(i-1)+irf(i); end
            plot(irf1,'k','Linewidth',2); ylim([-0.05 0.01]);
        elseif j==3
            irf=impulse(UE2(:,1),[ones(length(uRR2),1) UE2(:,2:25) uVAR2(:,2:37)],60,26) ;
            plot(irf,'k','Linewidth',2); ylim([-.05 1]);
        elseif j==4
            irf=impulse(UE2(:,1),[ones(length(uRR2),1) UE2(:,2:25) uRR2(:,2:37)],60,26) ;
            plot(irf,'k','Linewidth',2); ylim([-.05 1]);
        elseif j==5
            irf=impulse(p(:,1),[ones(length(uRR2),1) p(:,2:25) uVAR2(:,2:49)],60,26) ;
            plot(irf,'k','Linewidth',2); ylim([-.04 0.01]);
        else
            irf=impulse(p(:,1),[ones(length(uRR2),1) p(:,2:25) uRR2(:,2:49)],60,26) ;
            plot(irf,'k','Linewidth',2); ylim([-.04 0.01]);
        end
         
    end
end

%=========================================================================
%   Compare predicted time paths from VAR and R&R due to MP shocks
%=========================================================================
if fitindex==1
    MPshockdata2;                       % loads data from 1965:1 1996:12
    IP2=makelags(IP,60); CPI2=makelags(CPI,60); CPIc2=makelags(CPIc,60); PPI2=makelags(PPI,60); PiCPI2=makelags(PiCPI,60); PiCPIc2=makelags(PiCPIc,60); PiPPI2=makelags(PiPPI,60); FFR2=makelags(FFR,60); UE2=makelags(UE,60); PCOM2=makelags(PCOM,60); uRR2=makelags(uRR,60); 
    if pmeasureVAR==1 p=CPI2; elseif pmeasureVAR==2 p=CPIc2; elseif pmeasureVAR==3 p=PPI2; elseif pmeasureVAR==4 p=PiCPI2; elseif pmeasureVAR==5 p=PiCPIc2; else p=PiPPI2; end  % select which measure of prices to include in baseline VAR
    dat2=[IP2(:,1:13) UE2(:,1:13) p(:,1:13) FFR2(:,1:13) PCOM2(:,1:13) ];        
    out2=varcg(dat2,12,options);        % basic VAR uses 12 lags (1 year): estimation of VAR and univariate processes start in 1970:1                                             
    t=1970:1/12:1996+11/12;

    figure('Name','MP-driven fluctuations from VAR and R&R')
    for j=1:6
        subplot(3,2,j)
        if j==1        
            plot(t(13:length(t)),100*(out2.counter(13:length(t),1,4)-out2.counter(1:length(t)-12,1,4)),'k','Linewidth',2'); 
            hold on
            plot(t(13:length(t)),100*(IP2(13:length(IP2),1)-IP2(13:length(IP2),13)),'b:','Linewidth',2)
            hold off
        elseif j==2
            fit1=fit(IP2(:,1)-IP2(:,2),[ones(length(uRR2),1) IP2(:,2:25)-IP2(:,3:26) uRR2(:,2:37)],60,26) ;
            fit2=fit1;   for i=2:length(fit1) fit2(i)=fit2(i-1)+fit1(i); end
            plot(t(13:length(t)),100*(fit2(13:length(fit2))-fit2(1:length(fit2)-12)),'k','Linewidth',2); 
            hold on
            plot(t(13:length(t)),100*(IP2(13:length(IP2),1)-IP2(13:length(IP2),13)),'b:','Linewidth',2)
            hold off
        elseif j==3
            plot(t,out2.counter(:,2,4),'k','Linewidth',2'); 
            hold on
            plot(t,UE2(:,1),'b:','Linewidth',2)
            hold off
        elseif j==4
            fit1=fit(UE2(:,1),[ones(length(uRR2),1) UE2(:,2:25) uRR2(:,2:37)],60,26) ;
            plot(t,fit1,'k','Linewidth',2); 
            hold on
            plot(t,UE2(:,1),'b:','Linewidth',2)
            hold off
        elseif j==5
            plot(t(13:length(t)),100*(out2.counter(13:length(t),3,4)-out2.counter(1:length(t)-12,3,4)),'k','Linewidth',2'); 
            hold on
            plot(t(13:length(t)),100*(p(13:length(IP2),1)-p(13:length(IP2),13)),'b:','Linewidth',2)
            hold off
        elseif j==6
            fit1=fit(p(:,1)-p(:,2),[ones(length(uRR2),1) p(:,2:25)-p(:,3:26) uRR2(:,2:49)],60,26) ;
            fit2=fit1;   for i=2:length(fit1) fit2(i)=fit2(i-1)+fit1(i); end
            plot(t(13:length(t)),100*(fit2(13:length(fit2))-fit2(1:length(fit2)-12)),'k','Linewidth',2); 
            hold on
            plot(t(13:length(t)),100*(p(13:length(IP2),1)-p(13:length(IP2),13)),'b:','Linewidth',2)
            hold off
        end
    end
end
     
    
%=========================================================================
%   Predicted time paths from VAR and R&R due to MP shocks: SWITCH SHOCKS
%=========================================================================
if fitindex1==1
    MPshockdata2;                       % loads data from 1965:1 1996:12
    IP2=makelags(IP,60); CPI2=makelags(CPI,60); CPIc2=makelags(CPIc,60); PPI2=makelags(PPI,60); PiCPI2=makelags(PiCPI,60); PiCPIc2=makelags(PiCPIc,60); PiPPI2=makelags(PiPPI,60); FFR2=makelags(FFR,60); UE2=makelags(UE,60); PCOM2=makelags(PCOM,60); uRR2=makelags(uRR,60); 
    if pmeasureVAR==1 p=CPI2; elseif pmeasureVAR==2 p=CPIc2; elseif pmeasureVAR==3 p=PPI2; elseif pmeasureVAR==4 p=PiCPI2; elseif pmeasureVAR==5 p=PiCPIc2; else p=PiPPI2; end  % select which measure of prices to include in baseline VAR
    dat2=[IP2(:,1:13) UE2(:,1:13) p(:,1:13) FFR2(:,1:13) PCOM2(:,1:13) ];        
    out2=varcg1(dat2,12,options,uRR2,4);        % basic VAR uses 12 lags (1 year): estimation of VAR and univariate processes start in 1970:1, uses R&R shocks for fit!!!                                            
    t=1970:1/12:1996+11/12;
    uVAR2=zeros(length(uRR),1);  uVAR2(49:length(uRR),1)=uVAR; uVAR2=makelags(uVAR2,60);    %CHECK TIMING OF UVAR2
    
    figure('Name','MP-driven fluctuations: SWITCH SHOCKS')
    for j=1:6
        subplot(3,2,j)
        if j==1        
            plot(t(13:length(t)),100*(out2.counter(13:length(t),1,4)-out2.counter(1:length(t)-12,1,4)),'k','Linewidth',2'); 
            hold on
            plot(t(13:length(t)),100*(IP2(13:length(IP2),1)-IP2(13:length(IP2),13)),'b:','Linewidth',2)
            hold off
        elseif j==2
            fit1=fit(IP2(:,1)-IP2(:,2),[ones(length(uRR2),1) IP2(:,2:25)-IP2(:,3:26) uVAR2(:,2:37)],60,26) ;
            fit2=fit1;   for i=2:length(fit1) fit2(i)=fit2(i-1)+fit1(i); end
            plot(t(13:length(t)),100*(fit2(13:length(fit2))-fit2(1:length(fit2)-12)),'k','Linewidth',2); 
            hold on
            plot(t(13:length(t)),100*(IP2(13:length(IP2),1)-IP2(13:length(IP2),13)),'b:','Linewidth',2)
            hold off
        elseif j==3
            plot(t,out2.counter(:,2,4),'k','Linewidth',2'); 
            hold on
            plot(t,UE2(:,1),'b:','Linewidth',2)
            hold off
        elseif j==4
            fit1=fit(UE2(:,1),[ones(length(uRR2),1) UE2(:,2:25) uVAR2(:,2:37)],60,26) ;
            plot(t,fit1,'k','Linewidth',2); 
            hold on
            plot(t,UE2(:,1),'b:','Linewidth',2)
            hold off
        elseif j==5
            plot(t(13:length(t)),100*(out2.counter(13:length(t),3,4)-out2.counter(1:length(t)-12,3,4)),'k','Linewidth',2'); 
            hold on
            plot(t(13:length(t)),100*(p(13:length(IP2),1)-p(13:length(IP2),13)),'b:','Linewidth',2)
            hold off
        elseif j==6
            fit1=fit(p(:,1)-p(:,2),[ones(length(uRR2),1) p(:,2:25)-p(:,3:26) uVAR2(:,2:49)],60,26) ;
            fit2=fit1;   for i=2:length(fit1) fit2(i)=fit2(i-1)+fit1(i); end
            plot(t(13:length(t)),100*(fit2(13:length(fit2))-fit2(1:length(fit2)-12)),'k','Linewidth',2); 
            hold on
            plot(t(13:length(t)),100*(p(13:length(IP2),1)-p(13:length(IP2),13)),'b:','Linewidth',2)
            hold off
        end
    end
end
    
%=========================================================================
% LAG SENSITIVITY
%=========================================================================
if lagsensitivity==1
    MPshockdata2;                       % loads data from 1965:1 1996:12
    IP2=makelags(IP,60); CPI2=makelags(CPI,60); CPIc2=makelags(CPIc,60); PPI2=makelags(PPI,60); PiCPI2=makelags(PiCPI,60); PiCPIc2=makelags(PiCPIc,60); PiPPI2=makelags(PiPPI,60); FFR2=makelags(FFR,60); UE2=makelags(UE,60); PCOM2=makelags(PCOM,60); uRR2=makelags(uRR,60); 
    if pmeasureVAR==1 p=CPI2; elseif pmeasureVAR==2 p=CPIc2; elseif pmeasureVAR==3 p=PPI2; elseif pmeasureVAR==4 p=PiCPI2; elseif pmeasureVAR==5 p=PiCPIc2; else p=PiPPI2; end  % select which measure of prices to include in baseline VAR

    t=1970:1/12:1996+11/12;
    fit1=impulse(UE2(:,1),[ones(length(uRR2),1) UE2(:,2:25) uRR2(:,2:37)],60,26) ;
    for j=1:48
        fit1=impulse(UE2(:,1),[ones(length(uRR2),1) UE2(:,2:1+j) uRR2(:,2:1+j)],60,1+j+1) ;
        ueresp(:,j)=fit1;
        maxueRR(j)=max(fit1);
        lag(j)=j;

        dat2=[IP2(:,1:j+1) UE2(:,1:j+1) p(:,1:j+1) FFR2(:,1:j+1) PCOM2(:,1:j+1) ];        
        out2=varcg(dat2,j,options);     % basic VAR uses 12 lags (1 year): estimation of VAR and univariate processes start in 1970:1, uses R&R shocks for fit!!!                                            
        maxueVAR(j)=max(out2.irf(:,2,4));
    end
    figure('Name','Response of UE for different Lags')
    h=mesh(ueresp');
    figure('Name','Max Response of UE for different lags')
    plot(lag,maxueRR,'k','Linewidth',2)
    hold on
    plot(lag,maxueVAR,'b:','Linewidth',2)
    hold off
    xlim([1 48])
    xlabel('Lag Length in Months')
    ylabel('Peak Effect of MP shock on Unemployment')
    legend('R&R Specification','VAR specification')
end

%=========================================================================
%   Optimal Lag length selection for R&R & VAR's
%=========================================================================
if optlag==1
    MPshockdata2;                       % loads data from 1965:1 1996:12
    IP2=makelags(IP,60); CPI2=makelags(CPI,60); CPIc2=makelags(CPIc,60); PPI2=makelags(PPI,60); PiCPI2=makelags(PiCPI,60); PiCPIc2=makelags(PiCPIc,60); PiPPI2=makelags(PiPPI,60); FFR2=makelags(FFR,60); UE2=makelags(UE,60); PCOM2=makelags(PCOM,60); uRR2=makelags(uRR,60); 
    if pmeasureVAR==1 p=CPI2; elseif pmeasureVAR==2 p=CPIc2; elseif pmeasureVAR==3 p=PPI2; elseif pmeasureVAR==4 p=PiCPI2; elseif pmeasureVAR==5 p=PiCPIc2; else p=PiPPI2; end  % select which measure of prices to include in baseline VAR
    dat2=[IP2(:,1:13) UE2(:,1:13) p(:,1:13) FFR2(:,1:13) PCOM2(:,1:13) ];        
    b1max=0; b2max=0; b3max=0;
    a1max=0; a2max=0; a3max=0;
    c1max=0; c2max=0; c3max=0;
    
    % To do AIC/BIC starting in 1970, do not apply following.  To start in
    % 1974, use following line (eliminates zero values for shocks prior to 1969)
    %IP2=IP2(49:length(IP2),:);     UE2=UE2(49:length(UE2),:);     p=p(49:length(p),:);     uRR2=uRR2(49:length(uRR2),:); 
    
    for k=1:48
        for j=1:48
            % BIC criterion
            b1=bic(IP2(:,1)-IP2(:,2),[ones(length(uRR2),1) IP2(:,2:1+k)-IP2(:,3:2+k) uRR2(:,2:1+j)]);
            b2=bic(UE2(:,1),[ones(length(uRR2),1) UE2(:,2:1+k) uRR2(:,2:1+j)]);
            b3=bic(p(:,1)-p(:,2),[ones(length(uRR2),1) p(:,2:1+k)-p(:,3:2+k) uRR2(:,2:1+j)]);
            if b1>b1max   b1max=b1; lag1b=[k j]; end
            if b2>b2max   b2max=b2; lag2b=[k j]; end
            if b3>b3max   b3max=b3; lag3b=[k j]; end
            
            % AIC criterion
            a1=aic(IP2(:,1)-IP2(:,2),[ones(length(uRR2),1) IP2(:,2:1+k)-IP2(:,3:2+k) uRR2(:,2:1+j)]);
            a2=aic(UE2(:,1),[ones(length(uRR2),1) UE2(:,2:1+k) uRR2(:,2:1+j)]);
            a3=aic(p(:,1)-p(:,2),[ones(length(uRR2),1) p(:,2:1+k)-p(:,3:2+k) uRR2(:,2:1+j)]);
            if a1>a1max   a1max=a1; lag1a=[k j]; end
            if a2>a2max   a2max=a2; lag2a=[k j]; end
            if a3>a3max   a3max=a3; lag3a=[k j]; end

            % HQ criterion
            c1=hq(IP2(:,1)-IP2(:,2),[ones(length(uRR2),1) IP2(:,2:1+k)-IP2(:,3:2+k) uRR2(:,2:1+j)]);
            c2=hq(UE2(:,1),[ones(length(uRR2),1) UE2(:,2:1+k) uRR2(:,2:1+j)]);
            c3=hq(p(:,1)-p(:,2),[ones(length(uRR2),1) p(:,2:1+k)-p(:,3:2+k) uRR2(:,2:1+j)]);
            if c1>c1max   c1max=c1; lag1c=[k j]; end
            if c2>c2max   c2max=c2; lag2c=[k j]; end
            if c3>c3max   c3max=c3; lag3c=[k j]; end
        end
    end
    display('optimal lag lengths via bic for d(IP), UE, and d(p)')
    [lag1b ;  lag2b;   lag3b]
    display('optimal lag lengths via aic for d(IP), UE, and d(p)')
    [lag1a ;  lag2a;   lag3a]
    display('optimal lag lengths via hq for d(IP), UE, and d(p)')
    [lag1c ;  lag2c;   lag3c]
    
    figure('Name','IRFs at optimal lag length')
    for j=1:9
        % select macro series
        if j<4  macro=IP2; lagRR=36; elseif j<7 macro=UE2; lagRR=36; else macro=p; lagRR=48; end
        % select optimal lag length
        if j==1 lag=lag1a; elseif j==2 lag=lag1b; elseif j==3 lag=lag1c; elseif j==4 lag=lag2a; elseif j==5 lag=lag2b; elseif j==6 lag=lag2c; elseif j==7 lag=lag3a; elseif j==8 lag=lag3b; else lag=lag3c; end
        
        % plot
        subplot(3,3,j)
        if j<4 || j>6                      % this is for cumulative IRF's, i.e. IP and prices
            irf=impulse(macro(:,1)-macro(:,2),[ones(length(uRR2),1) macro(:,2:25)-macro(:,3:26) uRR2(:,2:lagRR+1)],60,26) ;
            irf1=irf;   for i=2:60 irf1(i)=irf1(i-1)+irf(i); end
            plot(irf1,'k','Linewidth',2);  % this is baseline R&R result.
            hold on
            irf=impulse(macro(:,1)-macro(:,2),[ones(length(uRR2),1) macro(:,2:lag(1)+1)-macro(:,3:lag(1)+2) uRR2(:,2:lag(2)+1)],60,lag(1)+2) ;
            irf1=irf;   for i=2:60 irf1(i)=irf1(i-1)+irf(i); end
            plot(irf1,'b--','Linewidth',2); % this is impulse response from optimal lag length
            hold off
        else
            irf=impulse(macro(:,1),[ones(length(uRR2),1) macro(:,2:25) uRR2(:,2:lagRR+1)],60,26) ;
            plot(irf,'k','Linewidth',2);  % this is baseline R&R result.
            hold on
            irf=impulse(macro(:,1),[ones(length(uRR2),1) macro(:,2:lag(1)+1) uRR2(:,2:lag(2)+1)],60,lag(1)+2) ;
            plot(irf,'b--','Linewidth',2); % this is impulse response from optimal lag length
            hold off
        end
        if j==1 title('AIC'); ylabel('IP'); elseif j==2 title('BIC'); elseif j==3 title('HQ'); elseif j==4 ylabel('UE'); elseif j==7 ylabel('Prices'); end
    end
end
   
dkbndf
    irf=impulse(IP2(:,1)-IP2(:,2),[ones(length(uRR2),1) IP2(:,2:25)-IP2(:,3:26) uRR2(:,2:37)],60,26) ;
    irf1=irf;   for i=2:60 irf1(i)=irf1(i-1)+irf(i); end
    plot(irf1,'k','Linewidth',2); ylim([-0.05 0.01]);
    hold on
    irf=impulse(IP2(:,1)-IP2(:,2),[ones(length(uRR2),1) IP2(:,2:lag1b(1)+1)-IP2(:,3:lag1b(1)+2) uRR2(:,2:lag1b(2)+1)],60,lag1b(1)+2) ;
    irf1=irf;   for i=2:60 irf1(i)=irf1(i-1)+irf(i); end
    plot(irf1,'b--','Linewidth',2); 
    irf=impulse(IP2(:,1)-IP2(:,2),[ones(length(uRR2),1) IP2(:,2:lag1a(1)+1)-IP2(:,3:lag1a(1)+2) uRR2(:,2:lag1a(2)+1)],60,lag1a(1)+2) ;
    irf1=irf;   for i=2:60 irf1(i)=irf1(i-1)+irf(i); end
    plot(irf1,'b:','Linewidth',2); 
    irf=impulse(IP2(:,1)-IP2(:,2),[ones(length(uRR2),1) IP2(:,2:lag1c(1)+1)-IP2(:,3:lag1c(1)+2) uRR2(:,2:lag1c(2)+1)],60,lag1c(1)+2) ;
    irf1=irf;   for i=2:60 irf1(i)=irf1(i-1)+irf(i); end
    plot(irf1,'b-.','Linewidth',2); 
    hold off
    legend('Baseline R&R','BIC Lags','AIC Lags','HQ Lags')

    subplot(3,1,2)
    irf=impulse(UE2(:,1),[ones(length(uRR2),1) UE2(:,2:25) uRR2(:,2:37)],60,26) ;
    plot(irf,'k','Linewidth',2); ylim([-.2 1]);
    hold on
    irf=impulse(UE2(:,1),[ones(length(uRR2),1) UE2(:,2:lag2b(1)+1) uRR2(:,2:lag2b(2)+1)],60,lag2b(1)+2) ;
    plot(irf,'b--','Linewidth',2); 
    irf=impulse(UE2(:,1),[ones(length(uRR2),1) UE2(:,2:lag2a(1)+1) uRR2(:,2:lag2a(2)+1)],60,lag2a(1)+2) ;
    plot(irf,'b:','Linewidth',2); 
    irf=impulse(UE2(:,1),[ones(length(uRR2),1) UE2(:,2:lag2c(1)+1) uRR2(:,2:lag2c(2)+1)],60,lag2c(1)+2) ;
    plot(irf,'b-.','Linewidth',2); 
    hold off
    legend('Baseline R&R','BIC Lags','AIC Lags','HQ Lags')
    
    subplot(3,1,3)
    irf=impulse(p(:,1)-p(:,2),[ones(length(uRR2),1) p(:,2:25)-p(:,3:26) uRR2(:,2:49)],60,26) ;
    irf1=irf;   for i=2:60 irf1(i)=irf1(i-1)+irf(i); end
    plot(irf1,'k','Linewidth',2); ylim([-.06 0.01]);
    hold on
    irf=impulse(p(:,1)-p(:,2),[ones(length(uRR2),1) p(:,2:lag3b(1)+1)-p(:,3:lag3b(1)+2) uRR2(:,2:lag3b(2)+1)],60,lag3b(1)+2) ;
    irf1=irf;   for i=2:60 irf1(i)=irf1(i-1)+irf(i); end
    plot(irf1,'b--','Linewidth',2); 
    irf=impulse(p(:,1)-p(:,2),[ones(length(uRR2),1) p(:,2:lag3a(1)+1)-p(:,3:lag3a(1)+2) uRR2(:,2:lag3a(2)+1)],60,lag3a(1)+2) ;
    irf1=irf;   for i=2:60 irf1(i)=irf1(i-1)+irf(i); end
    plot(irf1,'b:','Linewidth',2); 
    irf=impulse(p(:,1)-p(:,2),[ones(length(uRR2),1) p(:,2:lag3c(1)+1)-p(:,3:lag3c(1)+2) uRR2(:,2:lag3c(2)+1)],60,lag3c(1)+2) ;
    irf1=irf;   for i=2:60 irf1(i)=irf1(i-1)+irf(i); end
    plot(irf1,'b-.','Linewidth',2); 
    hold off
    legend('Baseline R&R','BIC Lags','AIC Lags','HQ Lags')
%end
    
%==========================================================================
%   Outliers: drop one shock at a time, reproduce IRF's of R&R
%==========================================================================
if outliers==1
    MPshockdata2;                       % loads data from 1965:1 1996:12
    IP2=makelags(IP,60); CPI2=makelags(CPI,60); CPIc2=makelags(CPIc,60); PPI2=makelags(PPI,60); PiCPI2=makelags(PiCPI,60); PiCPIc2=makelags(PiCPIc,60); PiPPI2=makelags(PiPPI,60); FFR2=makelags(FFR,60); UE2=makelags(UE,60); PCOM2=makelags(PCOM,60); 
    if pmeasureVAR==1 p=CPI2; elseif pmeasureVAR==2 p=CPIc2; elseif pmeasureVAR==3 p=PPI2; elseif pmeasureVAR==4 p=PiCPI2; elseif pmeasureVAR==5 p=PiCPIc2; else p=PiPPI2; end  % select which measure of prices to include in baseline VAR

    t=1970:1/12:1996+11/12;
    uRR2=makelags(uRR,60); 
    fit1=impulse(UE2(:,1),[ones(length(uRR2),1) UE2(:,2:25) uRR2(:,2:37)],60,26) ;  % baseline
    for j=1:length(uRR2)
        uRR1=uRR;
        uRR1(60+j)=0;
        uRR1=makelags(uRR1,60); 
        fit2=impulse(UE2(:,1),[ones(length(uRR2),1) UE2(:,2:25) uRR1(:,2:37)],60,26) ;
        ueresp(:,j)=fit2;
        maxue(j)=max(fit2(15:25));
    end
    figure('Name','Response of UE dropping one shock at a time')
    h=mesh(ueresp');
    figure('Name','Maximum response of UE dropping one shock at a time')
    plot(t,maxue)
end
