% dist_peakresponse.m

% This file calculates the distribution of impulse responses of
% exogenous shocks in X to Y, after the peak response.

% Based on impulse.m, which takes Y, regresses on X.  Then, assuming X is ordered with
% constant, then lags of X, then lags of exogenous shock (shockpos
% indicates when shock lags enter X), constructs impulse response to a
% one-unit innovation in exogenous shock.  Levelindex=0 means calculate
% irf's in sums, if 1 set in levels.

% Finally, the file returns the response of the LHS variable starting with the PEAK effect, normalized by
% this peak magnitude.


% NOTE THIS SPECIFICATION ASSUMES CONTEMPORANEOUS SHOCK HAS NO EFFECT ON Y

function z = dist_peakresponse(Y,X,periods,shockpos,its,levelindex);

[T,K]=size(X);
%beta=inv(X'*X)*(X'*Y);
%res=Y-X*beta;
%imp1=impulse1(beta,periods,shockpos,levelindex);      % generates impulse response given new coefficients

ivopt.linear=1;
ivopt.lags=12;

out = iv(zeros(length(X),1),ivopt,Y,X,X);       % this generates estimates of coefficients and var-cov matrix of parameter estimates.
V=out.betacov;                                  % this is variance covariance matrix of parameter estimates.
imp=[];

it=1;
while it<its
    beta1=out.beta+(V^.5)*randn(K,1);   % generate new coefficients drawn from empirical distribution of estimated coefficients
    imp1=impulse1(beta1,periods*4,shockpos,levelindex);      % generates impulse response given new coefficients
    t=find(imp1==max(imp1));
    if t<periods
        imp1_peak=imp1(t:t-1+periods)/imp1(t);
        imp=[imp ; imp1_peak];
        it=it+1;
    end
end

z=imp;

return

