% estimation1.m

% This file replicates results for Coibion (2009), comparing the effects of
% MP shocks from VAR to those of R&R (2004), as well as VAR using R&R
% cumulative shock

clear all
display(' Output of estimation.m ')

%%% Estimation options
pmeasureVAR=1;                      % select price measure to include in baseline VAR to generate VAR MP shocks: 1 CPI, 2 CPI less housing, 3 PPI, 4 annual CPI inflation, 5 annual CPIc inflation, 6 annual PPI inflation
pmeasureIRF=1;                      % select price measure to include in IRF's: 1 CPI, 2 CPI less housing, 3 PPI, 4 annual CPI inflation, 5 annual CPIc inflation, 6 annual PPI inflation

%%% What the file runs:
shockindex=0;                       % set to one to plot VAR and R&R shocks together (VAR shock depends on pmeasureVAR, i.e. which measure of prices is included in VAR)
shockcomp=0;                        % set to one to compute different VAR shocks for different measures of price series
comp1=0;                            % set to one to plot impulse responses to MP shocks from VAR and R&R
comp2=0;                            % set to one to plot impulse responses to MP shocks using R&R univariate approach on VAR shocks.
fitindex=1;                         % set to one to plot predicted paths due to MP shocks from VAR and R&R
fitindex1=0;                        % same as fitindex, but feeds R&R shocks into VAR and VAR shocks into R&R
lagsensitivity=0;                   % set to one to assess senstivity of IRF's to lag length
optlag=0;                           % set to one to test for optimal laglength of R&R and VAR.
outliers=0;                         % test for whether R&R IRF's are driven by outlier
FFRresponse=0;                      % set to one to plot response of FFR, IP, UE, and P to each shock, using univariate approach with R&R lags, set to 2 for same using BIC optimal lags.

%%%  Run baseline VAR, extract baseline VAR shocks
MPshockdata;                        % load macro data: IP, UE, CPI, CPIc, PPI, FFR, PCOM: 1968:1-1996:12, monthly
RRshock;                            % load MP shock measure from Romer and Romer (2004): uRR 1969:1-1996:12
IP1=makelags(IP,12); PPI1=makelags(PPI,12);  CPI1=makelags(CPI,12); CPIc1=makelags(CPIc,12); PiPPI1=makelags(PiPPI,12);  PiCPI1=makelags(PiCPI,12); PiCPIc1=makelags(PiCPIc,12); UE1=makelags(UE,12);  FFR1=makelags(FFR,12); PCOM1=makelags(PCOM,12);
if pmeasureVAR==1 p=CPI1; elseif pmeasureVAR==2 p=CPIc1; elseif pmeasureVAR==3 p=PPI1; elseif pmeasureVAR==4 p=PiCPI1; elseif pmeasureVAR==5 p=PiCPIc1; else p=PiPPI1; end  % select which measure of prices to include in baseline VAR
dat1=[IP1 UE1 p  PCOM1 FFR1];      
cumRR(1)=uRR(1);
for i=2:length(uRR)
    cumRR(i)=cumRR(i-1)+uRR(i);
end
cumRR=[zeros(1,12) cumRR];
cumRR1=makelags(cumRR,12);
dat2=[IP1 UE1 p  PCOM1 cumRR1];      
options.irfhor=60; options.vdechor=60; options.constant=1;
out1=varcg(dat1,12,options);        % basic VAR uses 12 lags (1 year)                                             
out2=varcg(dat2,12,options);        % basic VAR uses 12 lags (1 year) with R&R shocks                                            
uVAR=out1.u(:,5);                   % this is baseline MP shock measures from VAR
uRRcum=out2.u(:,5);                 % this is VAR shocks from R&R

%=========================================================================
%   Compare predicted time paths from VAR and R&R due to MP shocks
%=========================================================================
if fitindex==1
    MPshockdata2;                       % loads data from 1965:1 1996:12
    RRcumul;                            % loads R&R cumulative shock (shRR), 1965:1 1996:12
    IP2=makelags(IP,60); CPI2=makelags(CPI,60); CPIc2=makelags(CPIc,60); PPI2=makelags(PPI,60); PiCPI2=makelags(PiCPI,60); PiCPIc2=makelags(PiCPIc,60); PiPPI2=makelags(PiPPI,60); FFR2=makelags(FFR,60); UE2=makelags(UE,60); PCOM2=makelags(PCOM,60); uRR2=makelags(uRR,60); shRR2=makelags(shRR,60); 
    if pmeasureVAR==1 p=CPI2; elseif pmeasureVAR==2 p=CPIc2; elseif pmeasureVAR==3 p=PPI2; elseif pmeasureVAR==4 p=PiCPI2; elseif pmeasureVAR==5 p=PiCPIc2; else p=PiPPI2; end  % select which measure of prices to include in baseline VAR
    dat2=[IP2(:,1:13) UE2(:,1:13) p(:,1:13) PCOM2(:,1:13) FFR2(:,1:13)  ];        
    dat3=[IP2(:,1:13) UE2(:,1:13) p(:,1:13) PCOM2(:,1:13) shRR2(:,1:13)  ];        
    out2=varcg(dat2,12,options);        % basic VAR uses 12 lags (1 year): estimation of VAR and univariate processes start in 1970:1                                             
    out3=varcg(dat3,12,options);        % R&R VAR uses 12 lags (1 year): estimation of VAR and univariate processes start in 1970:1                                             
    t=1970:1/12:1996+11/12;

    figure('Name','MP-driven fluctuations from VAR and R&R')
    subplot(1,2,1)
    plot(t(13:length(t)),100*(IP2(13:length(IP2),1)-IP2(13:length(IP2),13)),'k','Linewidth',1); hold on;
    plot(t(13:length(t)),100*(out2.counter(13:length(t),1,5)-out2.counter(1:length(t)-12,1,5)),'r','Linewidth',2'); 
    fit1=fit(IP2(:,1)-IP2(:,2),[ones(length(uRR2),1) IP2(:,2:25)-IP2(:,3:26) uRR2(:,2:37)],60,26,0) ;
    plot(t(13:length(t)),100*(fit1(13:length(fit1))-fit1(1:length(fit1)-12)),'b','Linewidth',2); 
    xlim([1970 1997])

    subplot(1,2,2)
    plot(t(13:length(t)),100*(IP2(13:length(IP2),1)-IP2(13:length(IP2),13)),'k','Linewidth',1); hold on;
    fit1=fitBreak(IP2(:,1)-IP2(:,2),[ones(length(uRR2),1) IP2(:,2:25)-IP2(:,3:26) uRR2(:,2:25)],60,26,0) ;
                fit3=100*(fit1(13:length(fit1))-fit1(1:length(fit1)-12));
    plot(t(13:length(t)),fit3,'b','Linewidth',2); hold off    
    xlim([1970 1997])
    
    figure(3)
    plot(t(13:length(t)),100*(IP2(13:length(IP2),1)-IP2(13:length(IP2),13)),'k','Linewidth',1); hold on;
    plot(t(13:length(t)),100*(out2.counter(13:length(t),1,5)-out2.counter(1:length(t)-12,1,5)),'r','Linewidth',2'); 
    plot(t(13:length(t)),fit3,'b','Linewidth',2); hold off    
    xlim([1970 1997])
    
    
end
    
   