% UE_irf_mp.m

% estimate effect of MP shocks on US unemployment, a la RR
clear all
close all

USdata;                     % load UE and rrsh (UE rate and Romer Romer mp shocks updated to Dec. 2008).
ARlag=24;
MAlag=36;
T=48;
maxlag=max(ARlag,MAlag);

UE=makelags(UE,maxlag);
rrsh=makelags(rrsh,maxlag);

irf=impulse(UE(:,1),[ones(length(UE),1) UE(:,2:ARlag+1) rrsh(:,2:MAlag+1)],T,ARlag+2,1) ;
sd=se(UE(:,1),[ones(length(UE),1) UE(:,2:ARlag+1) rrsh(:,2:MAlag+1)],T,ARlag+2,100,1) ;

figure(1)
plot(irf,'k','Linewidth',2); hold on
plot(irf+sd,'b:','Linewidth',2);
plot(irf-sd,'b:','Linewidth',2);
hold off

X=[ones(length(UE),1) UE(:,2:ARlag+1) rrsh(:,2:MAlag+1)];
Y=[UE(:,1)];
coefs=(X'*X)\(X'*Y);

irf1=impulse(UE(1:13*12,1),[ones(length(UE(1:13*12)),1) UE(1:13*12,2:ARlag+1) rrsh(1:13*12,2:MAlag+1)],T,ARlag+2,1) ;
sd1=se(UE(1:13*12,1),[ones(length(UE(1:13*12)),1) UE(1:13*12,2:ARlag+1) rrsh(1:13*12,2:MAlag+1)],T,ARlag+2,100,1) ;

figure(2)
plot(irf1,'k','Linewidth',2); hold on
plot(irf1+sd1,'k:','Linewidth',2);
plot(irf1-sd1,'k:','Linewidth',2);

N=length(UE);
irf2=impulse(UE(13*12+1:N,1),[ones(length(UE(13*12+1:N)),1) UE(13*12+1:N,2:ARlag+1) rrsh(13*12+1:N,2:MAlag+1)],T,ARlag+2,1) ;
sd2=se(UE(13*12+1:N,1),[ones(length(UE(13*12+1:N)),1) UE(13*12+1:N,2:ARlag+1) rrsh(13*12+1:N,2:MAlag+1)],T,ARlag+2,100,1) ;
plot(irf2,'b','Linewidth',2); 
plot(irf2+sd2,'b:','Linewidth',2);
plot(irf2-sd2,'b:','Linewidth',2);

