% Answer to David Romer's question about sensitivity to NBR period and
% treatment of shocks during this period as missing values.
clear all
display(' Output of estimation.m ')
warning('off')

%%% Estimation options
pmeasureVAR=1;                      % select price measure to include in baseline VAR to generate VAR MP shocks: 1 CPI, 2 CPIcore, 3 PPI, 4 annual CPI inflation, 5 annual CPIc inflation, 6 annual PPI inflation
pmeasureIRF=1;                      % select price measure to include in IRF's: 1 CPI, 2 CPIcore, 3 PPI, 4 annual CPI inflation, 5 annual CPIc inflation, 6 annual PPI inflation
options.irfhor=60; options.vdechor=60; options.constant=1;

startbreak=1979+9/12;                % date at which we start cutting sample
endbreak=1984+0/12;                  % date at which sample starts up again
zeroshockend1=1982+8/12;              % last date of zero monetary shocks (1982+8/12)
zeroshockend2=1981+5/12;              % last date of zero monetary shocks (1982+8/12)

% baseline coefficients from IP equation, whole sample
beta=[0.001314
0.243954
0.075357
0.109062
0.068616
-0.088326
0.027730
-0.056736
0.051519
0.107545
0.011893
0.021031
-0.049281
-0.006289
-0.076845
-0.015791
-0.006210
-0.007779
0.056845
-0.027123
0.098921
-0.045582
0.077553
0.007319
-0.171887
0.002115
0.000845
-0.001710
-0.001484
-0.003459
-0.000533
-0.000315
-0.001612
-0.000863
-0.003670
-0.001756
-0.002911
-0.001187
0.000250
0.000854
0.000284
-0.002072
-0.002350
-0.000453
0.001201
-0.001062
-0.003988
0.000626
-0.000177
-1.42E-05
0.001262
0.000706
0.002518
-0.000110
0.001584
0.001242
0.001696
0.001334
0.001947
-0.000140
0.001263
];
% coefficients from IP equation when 79:10-81:5 shocks are missing values
beta1=[0.001657
0.235088
0.045517
0.120731
0.070426
-0.072995
0.013171
-0.042425
0.026270
0.054653
0.078041
-0.032212
0.031940
-0.033719
-0.049904
-0.031918
-0.032480
0.007488
0.058075
-0.025372
0.059869
-0.036627
0.017541
0.011455
-0.161542
0.001541
0.002701
-0.001220
-0.003185
-0.001308
0.000410
0.003078
-0.003797
-0.004136
-6.65E-05
7.51E-05
-0.002261
-0.000848
0.000689
0.001870
0.001404
-0.003073
-0.000216
-0.001944
0.001586
-0.000766
-0.001873
-0.003758
-0.002247
5.21E-05
-0.000904
0.001815
0.000157
0.001313
0.001717
0.000972
-0.000707
0.003119
-0.000337
0.003105
0.003393
];
% coefficients from IP equation when 79:10-82:9 shocks are missing values
beta2=[0.001618
0.240888
0.044815
0.124400
0.068831
-0.077741
0.010095
-0.028609
0.039530
0.039242
0.069368
-0.039771
0.056106
-0.036914
-0.047285
-0.054251
-0.026411
-0.004871
0.085647
-0.022365
0.062973
-0.047240
0.020353
0.008957
-0.155662
0.001895
0.002951
-0.001609
-0.003040
-0.002359
0.000709
0.003349
-0.003814
-0.004287
-0.000464
0.000537
-0.001651
-0.001448
0.000474
0.001588
0.001806
-0.002795
-0.000416
-0.001886
0.001230
0.000189
-0.002494
-0.003727
-0.002621
0.000294
-0.000788
0.002470
-0.000563
0.001565
0.001637
0.002956
-0.001944
0.002785
-0.001358
0.004148
0.003208
];
irf1=impulseTemp(beta,60,26,0);
irf2=impulseTemp(beta1,60,26,0);
irf3=impulseTemp(beta2,60,26,0);
figure(1)
hold on
plot(irf2)
plot(irf3,'k')


    MPshockdata2;                       % loads data from 1965:1 1996:12
    
    IP2=makelags(IP,60); CPI2=makelags(CPI,60); CPIc2=makelags(CPIc,60); PPI2=makelags(PPI,60); PiCPI2=makelags(PiCPI,60); PiCPIc2=makelags(PiCPIc,60); PiPPI2=makelags(PiPPI,60); FFR2=makelags(FFR,60); UE2=makelags(UE,60); PCOM2=makelags(PCOM,60); uRR2=makelags(uRR,60); 
    if pmeasureVAR==1 p=CPI2; elseif pmeasureVAR==2 p=CPIc2; elseif pmeasureVAR==3 p=PPI2; elseif pmeasureVAR==4 p=PiCPI2; elseif pmeasureVAR==5 p=PiCPIc2; else p=PiPPI2; end  % select which measure of prices to include in baseline VAR
    
    % generate R&R shocks, setting startbreak-1982=0, cutting startbreak-endbreak.
    uRR3=uRR;   % shock starts 1965:1
    uRR3((startbreak-1964-11/12)*12:(zeroshockend1-1964-11/12)*12)=0;
    uRR3=makelags(uRR3,60);
    uRR3=[uRR3(1:(startbreak-1/12-1969-11/12)*12,:) ; uRR3((endbreak-1969-11/12)*12:length(uRR3),:)];
    
    % macro data, dropping 1979-1984: ie data is 1970:1-1978:12 and 1985:1-1996:12
    IP3=[IP2(1:(startbreak-1/12-1969-11/12)*12,:) ; IP2((endbreak-1969-11/12)*12:length(IP2),:)];
    UE3=[UE2(1:(startbreak-1/12-1969-11/12)*12,:) ; UE2((endbreak-1969-11/12)*12:length(UE2),:)];
    p3= [  p(1:(startbreak-1/12-1969-11/12)*12,:) ;   p((endbreak-1969-11/12)*12:length(p),:)];
    
%    figure(1)
            irf=impulse(IP3(:,1)-IP3(:,2),[ones(length(uRR3),1) IP3(:,2:25)-IP3(:,3:26) uRR3(:,2:37)],60,26,0) ;
            plot(irf,'k','Linewidth',2); 
