% RomerVAR_AEJ.m

% This file compares hybrid VAR to Romer&Romer (2004) VAR.  This is
% response to referee question.

clear all

%%% Estimation options
pmeasureVAR=1;                      % select price measure to include in baseline VAR to generate VAR MP shocks: 1 CPI, 2 CPIcore, 3 PPI, 4 annual CPI inflation, 5 annual CPIc inflation, 6 annual PPI inflation
pmeasureIRF=1;                      % select price measure to include in IRF's: 1 CPI, 2 CPIcore, 3 PPI, 4 annual CPI inflation, 5 annual CPIc inflation, 6 annual PPI inflation


%%%  Run baseline VAR, extract baseline VAR shocks
    MPshockdata2;                       % loads data from 1965:1 1996:12
    RRcumul;                            % loads R&R cumulative shock (shRR), 1965:1 1996:12
    IP2=makelags(IP,60); CPI2=makelags(CPI,60); CPIc2=makelags(CPIc,60); PPI2=makelags(PPI,60); PiCPI2=makelags(PiCPI,60); PiCPIc2=makelags(PiCPIc,60); PiPPI2=makelags(PiPPI,60); FFR2=makelags(FFR,60); UE2=makelags(UE,60); PCOM2=makelags(PCOM,60); uRR2=makelags(uRR,60); shRR2=makelags(shRR,60); 
    if pmeasureVAR==1 p=CPI2; elseif pmeasureVAR==2 p=CPIc2; elseif pmeasureVAR==3 p=PPI2; elseif pmeasureVAR==4 p=PiCPI2; elseif pmeasureVAR==5 p=PiCPIc2; else p=PiPPI2; end  % select which measure of prices to include in baseline VAR
    dat1=[IP2(:,1:13) UE2(:,1:13) p(:,1:13) PCOM2(:,1:13) shRR2(:,1:13)  ];        % my specification of VAR
    dat2=[IP2(:,1:37) UE2(:,1:37) p(:,1:37) PCOM2(:,1:37) shRR2(:,1:37)  ];        % my specification of VAR
    dat3=[IP2(:,1:37) p(:,1:37) shRR2(:,1:37)  ];        % my specification of VAR
    options.irfhor=60; options.vdechor=60; options.constant=1; options.irfstd=0;

    
    options.irfstd=1;
    out1=varcg(dat1,12,options);        % basic VAR uses 12 lags (1 year): estimation of VAR and univariate processes start in 1970:1                                             
    out2=varcg(dat2,36,options);        % R&R VAR uses 12 lags (1 year): estimation of VAR and univariate processes start in 1970:1                                             
    out3=varcg(dat3,36,options);
    
figure(2)
subplot(1,2,1)
plot(out3.irf(1:48,1,3),'k','Linewidth',2)
hold on
plot(out2.irf(1:48,1,5),'k--','Linewidth',2)
plot(out1.irf(1:48,1,5),'k:','Linewidth',2)
hold off

subplot(1,2,2)
plot(out3.irf(1:48,2,3),'k','Linewidth',2)
hold on
plot(out2.irf(1:48,3,5),'k--','Linewidth',2)
plot(out1.irf(1:48,3,5),'k:','Linewidth',2)
hold off
legend('R&R VAR with CPI, 36 lags', 'Hybrid VAR, 36 lags','Hybrid VAR, 12 lags')


