% MPshockdata2.m

% This file loads data to be used in empirical analysis of MP shocks from
% VARs vs R&R approach.  This loads: log(IP), UE, log(CPI), log(CPI less housing),
% log (PPI finished goods), annual CPI inflation (100*log(CPI/CPI(-12)),
% annual CPI less housing inflation, annual PPI inflation, Effective FFR, and CRB
% Commodity price index.

% data is from 1965:1 until 1996:12 monthly.

Z=[3.522	4.900	3.443	3.497	3.526	1.093	0.913	1.482	3.900	104.900	0.000
3.528	5.100	3.443	3.500	3.529	1.190	1.216	1.775	3.980	104.000	0.000
3.541	4.700	3.444	3.500	3.532	1.189	1.216	2.068	4.040	106.200	0.000
3.545	4.800	3.446	3.500	3.529	1.380	1.216	1.775	4.090	108.000	0.000
3.553	4.600	3.449	3.506	3.532	1.601	1.818	1.770	4.100	106.800	0.000
3.561	4.600	3.453	3.509	3.535	1.916	1.813	2.062	4.040	106.400	0.000
3.570	4.400	3.453	3.509	3.538	1.789	1.813	2.353	4.090	105.500	0.000
3.575	4.400	3.452	3.506	3.541	1.597	1.513	2.643	4.120	106.800	0.000
3.577	4.300	3.454	3.509	3.547	1.723	1.508	3.221	4.010	107.700	0.000
3.587	4.200	3.455	3.512	3.547	1.689	1.807	3.221	4.080	108.100	0.000
3.591	4.100	3.458	3.512	3.555	1.715	1.807	3.785	4.100	108.800	0.000
3.604	4.000	3.461	3.517	3.555	1.902	2.099	3.785	4.320	112.000	0.000
3.613	4.000	3.462	3.517	3.558	1.900	2.099	3.184	4.420	114.700	0.000
3.620	3.800	3.468	3.523	3.558	2.525	2.388	2.890	4.600	116.900	0.000
3.633	3.800	3.471	3.526	3.552	2.741	2.683	2.026	4.650	115.000	0.000
3.635	3.800	3.474	3.532	3.558	2.828	3.269	2.890	4.670	114.200	0.000
3.644	3.900	3.477	3.532	3.567	2.726	2.667	3.449	4.900	113.800	0.000
3.649	3.800	3.478	3.532	3.572	2.407	2.367	3.720	5.170	113.800	0.000
3.655	3.800	3.480	3.535	3.570	2.718	2.659	3.148	5.300	115.600	0.000
3.655	3.800	3.486	3.541	3.570	3.427	3.540	2.857	5.530	111.200	0.000
3.665	3.700	3.489	3.544	3.567	3.511	3.530	1.997	5.400	108.400	0.000
3.672	3.700	3.492	3.547	3.567	3.721	3.519	1.997	5.530	105.000	0.000
3.665	3.600	3.493	3.547	3.564	3.497	3.519	0.853	5.760	104.700	0.000
3.667	3.800	3.494	3.547	3.564	3.304	2.924	0.853	5.400	105.000	0.000
3.672	3.900	3.493	3.550	3.564	3.149	3.212	0.568	4.940	104.600	0.000
3.660	3.800	3.497	3.550	3.567	2.827	2.620	0.851	5.000	103.500	0.000
3.655	3.800	3.497	3.552	3.575	2.516	2.613	2.266	4.530	100.800	0.000
3.664	3.800	3.500	3.552	3.575	2.509	2.026	1.695	4.050	100.100	0.000
3.655	3.800	3.500	3.552	3.578	2.292	2.026	1.124	3.940	101.800	0.000
3.655	3.900	3.506	3.558	3.578	2.802	2.598	0.560	3.980	100.300	0.000
3.653	3.800	3.509	3.561	3.581	2.886	2.590	1.120	3.790	98.900	0.000
3.672	3.800	3.512	3.567	3.581	2.570	2.575	1.120	3.900	98.300	0.000
3.670	3.800	3.515	3.570	3.584	2.562	2.568	1.681	3.990	97.900	0.000
3.678	4.000	3.517	3.572	3.586	2.555	2.561	1.958	3.880	96.700	0.000
3.693	3.900	3.523	3.575	3.589	3.055	2.841	2.518	4.130	97.600	0.000
3.703	3.800	3.526	3.578	3.592	3.228	3.121	2.793	4.510	98.300	0.000
3.702	3.700	3.529	3.584	3.597	3.582	3.390	3.343	4.600	98.700	0.000
3.706	3.800	3.532	3.586	3.597	3.572	3.668	3.060	4.710	98.400	0.000
3.709	3.700	3.535	3.589	3.600	3.864	3.657	2.490	5.050	98.700	0.000
3.710	3.500	3.538	3.592	3.603	3.852	3.933	2.763	5.760	96.900	0.000
3.721	3.500	3.541	3.595	3.605	4.143	4.208	2.755	6.110	96.800	0.000
3.725	3.700	3.547	3.600	3.611	4.118	4.185	3.297	6.070	96.300	0.000
3.724	3.700	3.552	3.603	3.611	4.393	4.173	3.018	6.020	95.200	0.000
3.726	3.500	3.555	3.605	3.614	4.380	3.879	3.288	6.030	96.000	0.000
3.730	3.400	3.558	3.608	3.614	4.368	3.868	3.010	5.780	97.000	0.000
3.732	3.400	3.564	3.614	3.616	4.639	4.127	3.002	5.910	98.800	0.000
3.745	3.400	3.567	3.619	3.616	4.330	4.384	2.725	5.820	99.600	0.000
3.748	3.400	3.572	3.619	3.622	4.599	4.105	2.985	6.020	100.800	0.000
3.754	3.400	3.575	3.622	3.627	4.585	3.815	2.969	6.300	103.900	0.000
3.761	3.400	3.578	3.627	3.632	4.572	4.071	3.500	6.610	105.800	0.000
3.768	3.400	3.586	3.632	3.638	5.115	4.325	3.754	6.790	106.500	-0.245
3.765	3.400	3.592	3.638	3.640	5.376	4.577	3.744	7.410	108.700	0.405
3.761	3.400	3.595	3.640	3.643	5.361	4.565	3.734	8.670	110.400	0.204
3.771	3.500	3.600	3.645	3.645	5.331	4.540	3.453	8.900	111.300	-0.020
3.776	3.500	3.605	3.651	3.651	5.301	4.788	3.974	8.610	111.400	0.181
3.778	3.500	3.608	3.653	3.658	5.286	4.775	4.480	9.190	113.100	0.309
3.778	3.700	3.614	3.658	3.661	5.542	5.021	4.738	9.150	114.100	0.029
3.778	3.700	3.619	3.661	3.666	5.511	4.738	4.981	9.000	113.700	0.088
3.769	3.500	3.624	3.666	3.664	5.763	4.713	4.725	8.850	113.900	-0.005
3.766	3.500	3.630	3.674	3.666	5.731	5.477	4.445	8.970	114.900	0.065
3.747	3.900	3.635	3.676	3.666	5.980	5.463	3.912	8.980	115.900	-0.160
3.747	4.200	3.640	3.681	3.666	6.227	5.435	3.381	8.980	116.400	-0.360
3.745	4.400	3.645	3.684	3.669	5.916	5.156	3.109	7.760	116.200	-0.140
3.743	4.600	3.651	3.689	3.669	5.884	5.129	2.846	8.100	116.400	-0.145
3.742	4.800	3.653	3.691	3.669	5.868	5.116	2.584	7.940	113.900	0.300
3.738	4.900	3.658	3.694	3.679	5.837	4.842	3.338	7.600	113.600	-0.180
3.741	5.000	3.661	3.699	3.679	5.550	4.817	2.817	7.210	112.900	-0.243
3.739	5.100	3.664	3.699	3.684	5.535	4.558	2.545	6.610	112.600	-0.483
3.732	5.400	3.669	3.704	3.684	5.506	4.535	2.287	6.290	111.000	-0.272
3.712	5.500	3.674	3.709	3.686	5.477	4.769	2.025	6.200	111.200	-0.009
3.706	5.900	3.679	3.714	3.691	5.449	4.745	2.781	5.600	108.700	-0.346
3.729	6.100	3.684	3.718	3.694	5.421	4.467	2.774	4.900	106.200	-0.229
3.736	5.900	3.686	3.721	3.696	5.143	4.456	3.023	4.140	108.100	-0.682
3.734	5.900	3.686	3.723	3.701	4.616	4.193	3.518	3.720	110.000	-0.025
3.733	6.000	3.689	3.728	3.704	4.343	4.423	3.509	3.710	109.500	-0.065
3.739	5.900	3.691	3.731	3.699	4.072	4.162	3.015	4.150	108.600	0.461
3.744	5.900	3.696	3.735	3.706	4.310	4.391	3.755	4.630	108.400	0.003
3.748	5.900	3.701	3.740	3.706	4.288	4.618	2.740	4.910	108.700	0.343
3.745	6.000	3.704	3.742	3.706	4.277	4.359	2.740	5.310	108.300	-0.117
3.739	6.100	3.706	3.745	3.709	4.267	4.596	2.482	5.560	108.100	0.000
3.756	6.000	3.709	3.745	3.716	4.001	4.102	3.214	5.550	106.800	0.000
3.763	5.800	3.711	3.747	3.714	3.736	3.847	2.720	5.200	106.500	-0.322
3.767	6.000	3.714	3.747	3.721	3.474	3.358	2.949	4.910	105.700	-0.342
3.779	6.000	3.716	3.752	3.721	3.214	3.342	2.700	4.140	107.300	-0.920
3.802	5.800	3.718	3.754	3.721	3.206	3.334	2.451	3.500	111.500	-0.234
3.812	5.700	3.723	3.759	3.726	3.690	3.559	2.439	3.290	112.700	-0.086
3.819	5.800	3.723	3.759	3.731	3.440	3.077	2.673	3.830	114.900	0.252
3.829	5.700	3.726	3.761	3.733	3.432	3.070	3.407	4.170	115.700	-0.104
3.829	5.700	3.728	3.764	3.738	3.175	2.824	3.144	4.270	119.500	-0.115
3.832	5.700	3.731	3.764	3.742	2.920	2.348	3.619	4.460	118.800	-0.050
3.832	5.600	3.733	3.768	3.738	2.913	2.573	3.144	4.550	119.700	0.000
3.845	5.600	3.735	3.768	3.745	2.906	2.337	3.611	4.800	122.000	0.000
3.852	5.500	3.740	3.775	3.754	3.137	3.027	3.819	4.870	123.000	0.000
3.865	5.600	3.742	3.777	3.761	3.129	3.020	4.763	5.040	125.200	0.000
3.877	5.300	3.747	3.782	3.773	3.358	3.477	5.190	5.060	127.900	0.036
3.888	5.200	3.750	3.784	3.793	3.350	3.234	7.238	5.330	131.600	-0.027
3.895	4.900	3.754	3.791	3.800	3.576	3.679	7.911	5.940	136.100	0.279
3.910	5.000	3.761	3.798	3.807	3.792	3.886	8.097	6.580	146.100	0.225
3.910	4.900	3.770	3.807	3.818	4.718	4.779	8.721	7.090	148.800	0.064
3.908	5.000	3.777	3.816	3.816	5.165	5.431	8.262	7.120	153.800	-0.063
3.915	4.900	3.782	3.822	3.850	5.381	5.858	11.248	7.840	166.300	0.317
3.916	4.900	3.789	3.829	3.848	5.822	6.512	10.560	8.490	171.900	0.409
3.920	4.800	3.789	3.829	3.846	5.583	6.049	10.821	10.400	195.100	0.115
3.918	4.800	3.807	3.848	3.854	7.138	7.987	10.961	10.500	202.000	0.318
3.927	4.800	3.811	3.850	3.863	7.105	7.509	10.863	10.780	195.000	-0.571
3.934	4.600	3.820	3.857	3.888	7.749	7.916	12.653	10.010	187.500	-0.848
3.939	4.800	3.826	3.865	3.906	7.932	8.302	13.324	10.030	192.100	-0.095
3.937	4.900	3.835	3.873	3.916	8.564	8.909	12.278	9.950	206.000	-0.165
3.930	5.100	3.846	3.886	3.926	9.168	9.469	12.595	9.650	217.500	-0.206
3.926	5.200	3.857	3.898	3.938	9.531	10.019	13.103	8.970	239.300	0.201
3.927	5.100	3.867	3.910	3.938	9.657	10.336	11.998	9.350	233.000	0.733
3.924	5.100	3.873	3.914	3.965	9.593	9.851	14.910	10.510	229.400	0.387
3.931	5.100	3.884	3.926	3.983	10.171	10.383	13.327	11.310	216.900	0.392
3.930	5.400	3.892	3.934	3.995	10.310	10.514	14.651	11.930	226.900	0.280
3.930	5.500	3.898	3.940	4.013	10.920	11.100	16.689	12.920	249.900	-0.091
3.921	5.500	3.910	3.953	4.032	10.336	10.515	17.808	12.010	236.300	-0.022
3.922	5.900	3.924	3.967	4.032	11.285	11.636	16.964	11.340	229.600	-0.430
3.918	6.000	3.932	3.974	4.038	11.192	11.755	15.004	10.060	228.600	-0.284
3.885	6.600	3.942	3.983	4.036	11.512	11.848	13.000	9.450	223.300	0.336
3.849	7.200	3.949	3.993	4.036	11.418	11.940	11.999	8.530	207.900	-0.229
3.836	8.100	3.957	3.998	4.045	11.111	11.252	11.888	7.130	203.000	-0.354
3.812	8.100	3.963	4.002	4.050	10.621	10.394	11.235	6.240	199.000	0.243
3.801	8.600	3.967	4.006	4.059	9.949	9.549	12.103	5.540	200.800	-0.499
3.802	8.800	3.970	4.009	4.067	9.701	9.513	10.270	5.490	198.900	-0.637
3.800	9.000	3.972	4.013	4.076	8.855	8.685	9.243	5.220	192.500	0.136
3.807	8.800	3.980	4.018	4.083	8.786	8.440	8.809	5.550	189.900	0.170
3.817	8.600	3.989	4.031	4.091	9.106	9.106	7.823	6.100	201.300	0.070
3.826	8.400	3.993	4.032	4.094	8.266	7.930	6.188	6.140	208.400	-0.136
3.839	8.400	4.000	4.041	4.096	7.608	7.478	6.354	6.240	205.800	-0.114
3.843	8.400	4.006	4.048	4.094	7.369	7.424	5.657	5.820	197.300	-0.200
3.846	8.300	4.013	4.054	4.093	7.119	7.011	5.667	5.220	190.800	-0.281
3.858	8.200	4.018	4.059	4.094	6.886	6.604	5.834	5.200	188.300	0.280
3.873	7.900	4.022	4.062	4.099	6.478	6.396	5.453	4.870	188.700	-0.091
3.882	7.700	4.024	4.064	4.101	6.085	6.202	5.094	4.770	193.700	-0.469
3.883	7.600	4.025	4.066	4.103	5.884	6.009	4.393	4.840	197.300	-0.239
3.889	7.700	4.027	4.069	4.106	5.684	5.988	3.863	4.820	203.200	0.139
3.894	7.400	4.032	4.072	4.109	6.029	5.967	3.339	5.290	202.600	-0.298
3.893	7.600	4.038	4.078	4.113	5.809	5.935	2.990	5.480	210.900	-0.038
3.899	7.800	4.043	4.083	4.117	5.407	5.191	2.640	5.310	212.800	-0.139
3.906	7.800	4.048	4.088	4.126	5.562	5.519	3.118	5.290	204.900	-0.044
3.908	7.600	4.054	4.093	4.134	5.349	5.138	3.756	5.250	199.800	0.019
3.909	7.700	4.059	4.099	4.135	5.320	5.103	4.082	5.020	194.300	-0.041
3.924	7.800	4.062	4.104	4.146	4.939	5.077	5.363	4.950	197.300	0.030
3.934	7.800	4.067	4.108	4.154	4.913	4.887	5.984	4.650	201.900	-0.131
3.929	7.500	4.072	4.114	4.159	5.067	5.198	5.955	4.610	211.600	-0.097
3.944	7.600	4.083	4.124	4.165	5.904	6.002	6.412	4.680	212.500	-0.085
3.956	7.400	4.088	4.129	4.168	6.230	6.314	6.557	4.690	219.200	-0.228
3.965	7.200	4.094	4.135	4.171	6.721	6.614	6.536	4.730	220.900	-0.049
3.973	7.000	4.098	4.140	4.177	6.520	6.752	6.823	5.350	215.500	-0.051
3.980	7.200	4.103	4.145	4.182	6.487	6.718	6.954	5.390	206.700	-0.146
3.982	6.900	4.108	4.148	4.188	6.454	6.528	7.073	5.420	203.500	-0.240
3.983	7.000	4.113	4.151	4.196	6.421	6.338	7.018	5.900	200.900	0.030
3.988	6.800	4.116	4.154	4.200	6.226	6.151	6.664	6.140	201.900	0.073
3.990	6.800	4.121	4.157	4.205	6.194	5.799	6.953	6.470	201.900	-0.026
3.991	6.800	4.127	4.165	4.212	6.497	6.082	6.582	6.510	209.400	-0.048
3.992	6.400	4.132	4.170	4.217	6.465	6.217	6.238	6.560	213.200	-0.122
3.979	6.400	4.138	4.173	4.228	6.592	5.870	6.941	6.700	219.100	-0.205
3.983	6.300	4.143	4.179	4.236	6.053	5.509	7.044	6.780	220.100	0.106
4.001	6.300	4.149	4.185	4.244	6.181	5.635	7.599	6.790	228.000	0.042
4.021	6.100	4.157	4.193	4.253	6.297	5.751	8.147	6.890	225.500	-0.069
4.025	6.000	4.167	4.200	4.254	6.899	6.025	7.673	7.360	232.000	-0.216
4.033	5.900	4.174	4.209	4.264	7.174	6.444	8.204	7.600	230.000	0.243
4.033	6.200	4.182	4.214	4.268	7.446	6.572	8.016	7.810	229.000	-0.142
4.036	5.900	4.188	4.220	4.277	7.563	6.847	8.097	8.040	239.600	-0.064
4.039	6.000	4.197	4.225	4.288	8.142	7.119	8.751	8.450	244.100	-0.156
4.047	5.800	4.206	4.233	4.300	8.552	7.534	9.531	8.960	256.500	0.133
4.054	5.900	4.212	4.240	4.309	8.499	7.477	9.733	9.760	250.400	0.168
4.060	6.000	4.218	4.246	4.317	8.607	7.587	10.093	10.030	250.300	-0.042
4.053	5.900	4.227	4.254	4.328	8.847	8.135	9.981	10.070	259.500	0.000
4.059	5.900	4.237	4.264	4.333	9.387	8.510	9.781	10.060	270.900	-0.152
4.062	5.800	4.247	4.274	4.339	9.760	8.879	9.440	10.090	277.700	0.133
4.051	5.800	4.257	4.284	4.349	9.971	9.091	9.621	10.010	276.900	-0.064
4.059	5.600	4.268	4.295	4.359	10.163	9.436	10.508	10.240	277.600	0.105
4.059	5.700	4.279	4.304	4.376	10.505	9.490	11.167	10.290	281.300	0.000
4.057	5.700	4.290	4.313	4.387	10.841	9.987	11.872	10.470	277.800	0.761
4.050	6.000	4.300	4.321	4.399	11.186	10.197	12.271	10.940	281.800	0.322
4.051	5.900	4.309	4.329	4.409	11.225	10.404	12.144	11.430	279.400	-0.224
4.057	6.000	4.320	4.336	4.424	11.397	10.333	12.365	13.770	278.100	0.000
4.056	5.900	4.331	4.345	4.438	11.861	10.522	12.848	13.180	283.100	0.045
4.057	6.000	4.343	4.354	4.449	12.447	10.851	13.103	13.780	287.500	0.000
4.061	6.300	4.357	4.368	4.457	12.988	11.399	12.857	13.820	288.000	-0.011
4.062	6.300	4.369	4.380	4.461	13.245	11.544	12.794	14.130	294.200	0.197
4.059	6.300	4.383	4.394	4.469	13.621	12.056	13.075	17.190	280.800	1.422
4.039	6.900	4.393	4.401	4.485	13.618	11.702	13.627	17.610	270.700	-3.221
4.013	7.500	4.403	4.408	4.496	13.476	11.338	13.720	10.980	263.500	-0.764
4.001	7.600	4.413	4.413	4.501	13.336	10.873	12.516	9.470	265.100	0.000
3.994	7.800	4.414	4.420	4.509	12.355	10.656	12.165	9.030	282.000	0.403
3.997	7.700	4.421	4.428	4.515	12.124	10.695	11.587	9.610	289.200	-0.198
4.014	7.500	4.430	4.439	4.520	12.017	10.970	11.046	10.870	292.500	0.771
4.026	7.500	4.439	4.445	4.530	11.896	10.902	10.680	12.810	300.100	1.218
4.043	7.500	4.450	4.453	4.539	11.895	10.808	10.110	15.850	297.800	1.871
4.049	7.200	4.459	4.460	4.551	11.648	10.600	10.220	18.900	283.500	-0.634
4.043	7.500	4.468	4.470	4.561	11.150	10.231	10.455	19.080	276.200	0.000
4.038	7.400	4.477	4.484	4.564	10.789	10.461	10.305	15.930	275.700	-0.783
4.044	7.400	4.484	4.492	4.570	10.086	9.755	10.019	14.700	275.900	0.307
4.038	7.200	4.490	4.496	4.572	9.655	9.587	8.635	15.720	274.500	0.000
4.045	7.500	4.496	4.501	4.573	9.342	9.298	7.618	18.520	271.800	1.515
4.050	7.500	4.505	4.506	4.577	9.255	9.366	7.585	19.100	265.800	0.000
4.057	7.200	4.516	4.514	4.581	10.233	9.411	7.222	19.040	276.900	-0.611
4.057	7.400	4.524	4.521	4.584	10.271	9.227	6.870	17.820	267.900	-0.041
4.051	7.600	4.534	4.527	4.588	10.405	8.809	6.841	15.870	262.700	0.000
4.043	7.900	4.537	4.533	4.594	9.778	8.760	6.366	15.080	256.300	-0.574
4.033	8.300	4.541	4.538	4.593	9.148	8.478	5.407	13.310	253.600	-0.356
4.022	8.500	4.544	4.542	4.593	8.537	8.209	4.238	12.370	250.000	0.100
4.002	8.600	4.548	4.546	4.595	7.934	7.599	3.390	13.220	256.800	0.000
4.021	8.900	4.551	4.550	4.595	7.338	6.553	3.077	14.780	248.700	1.021
4.014	9.000	4.551	4.551	4.603	6.658	5.871	3.363	14.680	246.400	-0.435
4.005	9.300	4.554	4.551	4.607	6.412	5.424	3.555	14.940	247.500	0.000
3.998	9.400	4.563	4.557	4.611	6.684	5.611	3.851	14.450	245.500	-0.056
3.994	9.600	4.575	4.567	4.612	6.936	6.101	3.538	14.150	239.400	0.000
3.991	9.800	4.580	4.573	4.615	6.351	5.850	3.424	12.590	241.800	-0.196
3.982	9.800	4.582	4.574	4.619	5.794	5.298	3.513	10.120	239.300	-0.211
3.978	10.100	4.582	4.577	4.623	4.823	4.956	3.499	10.310	234.500	0.000
3.970	10.400	4.586	4.582	4.615	4.910	4.930	2.101	9.710	231.200	-0.242
3.967	10.800	4.585	4.584	4.616	4.380	4.599	2.301	9.200	226.600	0.125
3.960	10.800	4.582	4.585	4.615	3.754	4.274	2.202	8.950	227.400	0.651
3.978	10.400	4.584	4.587	4.616	3.641	4.053	2.099	8.680	234.800	0.000
3.973	10.400	4.585	4.587	4.619	3.425	3.735	2.395	8.510	241.500	0.185
3.981	10.300	4.586	4.589	4.621	3.527	3.833	1.788	8.770	247.900	0.145
3.993	10.200	4.593	4.595	4.621	3.922	4.441	1.388	8.800	250.200	0.000
4.000	10.100	4.597	4.599	4.624	3.383	4.212	1.284	8.630	248.100	-0.019
4.005	10.100	4.599	4.602	4.627	2.444	3.470	1.479	8.980	247.300	0.000
4.021	9.400	4.603	4.605	4.627	2.332	3.252	1.181	9.370	256.400	-0.008
4.032	9.500	4.606	4.609	4.625	2.427	3.548	0.590	9.560	273.700	-0.234
4.047	9.200	4.609	4.611	4.628	2.726	3.438	0.490	9.450	266.700	0.000
4.055	8.800	4.613	4.615	4.635	2.715	3.322	1.961	9.480	266.400	0.282
4.058	8.500	4.616	4.618	4.639	3.114	3.414	2.249	9.340	269.100	-0.172
4.063	8.300	4.619	4.620	4.642	3.717	3.509	2.735	9.470	277.800	0.217
4.083	8.000	4.626	4.627	4.643	4.201	3.993	2.732	9.560	280.800	0.257
4.088	7.800	4.631	4.633	4.642	4.587	4.578	2.339	9.590	280.100	0.000
4.093	7.800	4.634	4.635	4.642	4.777	4.569	2.142	9.910	288.200	-0.101
4.099	7.700	4.638	4.638	4.644	4.454	4.252	2.335	10.290	285.700	0.000
4.103	7.400	4.640	4.640	4.642	4.243	4.042	1.847	10.320	291.000	0.173
4.107	7.200	4.642	4.642	4.642	4.235	3.934	1.553	11.060	286.900	0.000
4.110	7.500	4.645	4.644	4.641	4.218	3.922	1.361	11.230	272.000	0.327
4.110	7.500	4.648	4.647	4.644	4.206	3.811	1.942	11.640	276.800	-0.061
4.109	7.300	4.651	4.650	4.644	4.194	3.899	1.648	11.300	267.100	0.000
4.108	7.400	4.655	4.654	4.644	4.177	3.884	0.966	9.990	266.700	0.035
4.112	7.200	4.657	4.655	4.645	4.070	3.683	0.675	9.430	268.400	-0.546
4.113	7.300	4.659	4.656	4.645	3.964	3.580	0.289	8.380	257.200	-0.144
4.110	7.300	4.661	4.659	4.650	3.465	3.178	0.671	8.350	256.900	0.000
4.115	7.200	4.666	4.662	4.653	3.543	2.971	1.054	8.500	251.900	-0.158
4.116	7.200	4.671	4.667	4.650	3.720	3.248	0.768	8.580	256.800	0.201
4.114	7.300	4.673	4.670	4.651	3.519	3.238	0.671	8.270	254.100	0.000
4.115	7.200	4.675	4.670	4.649	3.512	3.045	0.672	7.970	246.800	-0.104
4.115	7.400	4.677	4.672	4.642	3.599	3.039	0.000	7.530	242.600	0.000
4.109	7.400	4.679	4.674	4.653	3.400	2.937	1.247	7.880	237.600	0.060
4.113	7.100	4.681	4.674	4.659	3.298	2.649	1.432	7.900	233.100	0.186
4.117	7.100	4.683	4.676	4.663	3.196	2.549	1.905	7.920	229.400	0.000
4.113	7.100	4.687	4.678	4.659	3.184	2.446	1.432	7.990	230.100	0.104
4.117	7.000	4.691	4.683	4.645	3.453	2.814	0.000	8.050	233.400	0.021
4.127	7.000	4.696	4.688	4.633	3.721	3.181	-1.257	8.270	236.700	-0.069
4.132	6.700	4.700	4.690	4.628	3.897	3.172	-2.223	8.140	231.600	0.000
4.124	7.200	4.698	4.688	4.633	3.148	2.518	-2.022	7.860	223.600	-0.110
4.118	7.200	4.692	4.679	4.636	2.131	1.214	-1.444	7.480	216.100	0.000
4.119	7.100	4.689	4.673	4.628	1.576	0.281	-2.319	6.990	214.700	0.207
4.120	7.200	4.691	4.675	4.632	1.665	0.468	-1.737	6.850	215.100	0.076
4.117	7.200	4.695	4.679	4.634	1.752	0.746	-0.871	6.920	220.300	0.000
4.123	7.000	4.696	4.679	4.640	1.657	0.559	-1.344	6.560	220.600	-0.168
4.121	6.900	4.697	4.680	4.639	1.563	0.651	-2.011	6.170	209.000	-0.234
4.123	7.000	4.700	4.683	4.641	1.742	0.743	-2.290	5.890	219.300	0.001
4.128	7.000	4.702	4.683	4.645	1.555	0.464	-1.336	5.850	226.160	0.000
4.133	6.900	4.704	4.686	4.648	1.276	0.277	0.288	6.040	228.240	0.021
4.142	6.600	4.708	4.689	4.649	1.180	0.092	1.640	6.910	228.330	-0.082
4.139	6.600	4.713	4.696	4.655	1.356	0.549	2.700	6.430	229.450	0.000
4.151	6.600	4.717	4.700	4.656	1.896	1.281	2.308	6.100	225.890	0.176
4.153	6.600	4.720	4.704	4.659	2.802	2.476	2.301	6.130	227.910	0.191
4.158	6.300	4.725	4.708	4.661	3.614	3.490	3.270	6.370	239.500	0.000
4.165	6.300	4.727	4.710	4.662	3.604	3.573	3.068	6.850	249.200	0.238
4.170	6.200	4.732	4.715	4.665	3.679	3.557	3.157	6.730	251.870	0.000
4.176	6.100	4.734	4.718	4.663	3.852	3.826	2.387	6.580	252.780	-0.041
4.183	6.000	4.739	4.722	4.663	4.199	4.179	2.483	6.730	254.540	-0.021
4.186	5.900	4.742	4.725	4.662	4.184	4.167	2.101	7.220	255.080	-0.147
4.201	6.000	4.745	4.727	4.667	4.264	4.345	2.185	7.290	253.850	0.000
4.206	5.800	4.748	4.730	4.666	4.429	4.421	1.804	6.690	254.400	-0.085
4.211	5.700	4.750	4.731	4.669	4.241	4.233	1.990	6.770	258.210	-0.180
4.211	5.700	4.754	4.733	4.673	4.046	3.676	1.792	6.830	258.890	0.000
4.216	5.700	4.755	4.734	4.675	3.860	3.308	1.883	6.580	257.000	-0.224
4.218	5.700	4.758	4.737	4.677	3.761	3.297	1.878	6.580	261.200	0.018
4.223	5.400	4.764	4.743	4.686	3.915	3.546	2.522	6.870	263.500	0.000
4.223	5.600	4.766	4.746	4.690	3.905	3.537	2.702	7.090	272.550	0.188
4.225	5.400	4.771	4.750	4.691	3.888	3.521	2.602	7.510	283.750	0.308
4.227	5.400	4.775	4.755	4.693	4.047	3.771	2.974	7.750	276.620	0.000
4.232	5.600	4.779	4.759	4.697	4.030	3.669	3.340	8.010	276.530	-0.182
4.228	5.400	4.783	4.764	4.700	4.100	3.915	3.893	8.190	271.880	-0.067
4.234	5.400	4.787	4.767	4.710	4.173	4.079	4.323	8.300	274.530	0.000
4.236	5.300	4.790	4.770	4.718	4.158	3.980	5.134	8.350	274.190	-0.009
4.240	5.300	4.793	4.773	4.721	4.317	4.230	5.209	8.760	284.350	0.446
4.242	5.400	4.797	4.778	4.728	4.385	4.560	5.544	9.120	286.730	0.000
4.238	5.200	4.801	4.782	4.736	4.542	4.808	6.150	9.360	287.210	0.297
4.241	5.000	4.806	4.787	4.736	4.777	4.958	5.871	9.850	285.120	0.061
4.240	5.200	4.813	4.796	4.734	4.912	5.260	4.861	9.840	282.600	0.000
4.233	5.200	4.818	4.801	4.731	5.142	5.494	4.141	9.810	280.130	0.153
4.234	5.300	4.821	4.803	4.736	5.040	5.307	4.485	9.530	282.580	0.000
4.225	5.200	4.824	4.805	4.741	4.939	4.953	4.827	9.240	277.220	0.075
4.234	5.200	4.824	4.805	4.743	4.518	4.609	4.635	8.990	278.020	-0.139
4.231	5.300	4.827	4.807	4.749	4.340	4.341	4.879	9.020	274.590	0.000
4.230	5.300	4.832	4.811	4.768	4.485	4.408	5.771	8.840	270.320	-0.087
4.233	5.400	4.835	4.815	4.767	4.550	4.478	4.968	8.550	265.600	0.108
4.240	5.400	4.839	4.818	4.766	4.535	4.464	4.526	8.450	260.600	-0.067
4.234	5.400	4.848	4.829	4.766	5.067	5.083	3.731	8.230	260.410	0.000
4.243	5.300	4.852	4.834	4.766	5.129	5.226	3.024	8.240	264.000	0.313
4.248	5.200	4.857	4.837	4.767	5.105	5.042	3.109	8.280	271.300	-0.094
4.247	5.400	4.859	4.839	4.770	4.604	4.366	3.539	8.260	273.060	0.000
4.249	5.400	4.861	4.841	4.781	4.273	4.030	4.988	8.180	278.440	0.044
4.251	5.200	4.867	4.846	4.793	4.568	4.256	5.711	8.290	277.490	0.000
4.250	5.500	4.871	4.850	4.803	4.707	4.484	6.175	8.150	276.550	-0.066
4.252	5.700	4.880	4.858	4.809	5.546	5.342	6.574	8.130	271.100	0.150
4.254	5.900	4.887	4.867	4.804	5.987	5.947	5.475	8.200	273.090	0.000
4.247	5.900	4.893	4.875	4.809	6.184	6.383	4.079	8.110	263.070	-0.119
4.235	6.200	4.896	4.878	4.802	6.011	6.363	3.509	7.810	261.380	-0.018
4.228	6.300	4.899	4.881	4.798	6.067	6.343	3.183	7.310	258.130	-0.159
4.223	6.400	4.903	4.884	4.798	5.493	5.520	3.268	6.910	255.690	0.000
4.217	6.600	4.904	4.884	4.801	5.176	5.042	3.430	6.250	255.970	-0.251
4.212	6.800	4.904	4.884	4.799	4.709	4.648	3.180	6.120	255.130	0.227
4.214	6.700	4.906	4.886	4.797	4.698	4.638	2.678	5.910	253.760	0.000
4.224	6.900	4.910	4.890	4.798	4.912	4.932	1.746	5.780	248.280	0.262
4.233	6.900	4.913	4.893	4.800	4.589	4.684	0.661	5.900	243.290	0.000
4.233	6.800	4.914	4.894	4.803	4.275	4.442	0.000	5.820	246.830	-0.077
4.234	6.900	4.917	4.897	4.807	3.729	3.883	-0.163	5.660	241.250	0.140
4.243	6.900	4.920	4.900	4.806	3.340	3.331	0.246	5.450	244.530	0.000
4.241	7.000	4.921	4.901	4.804	2.809	2.562	-0.491	5.210	242.120	-0.035
4.240	7.000	4.926	4.905	4.806	3.020	2.703	0.410	4.810	242.540	-0.121
4.236	7.300	4.929	4.907	4.807	2.937	2.621	0.903	4.430	238.240	0.113
4.230	7.300	4.929	4.907	4.808	2.638	2.318	0.984	4.030	237.110	0.000
4.238	7.400	4.932	4.910	4.811	2.780	2.539	1.063	4.060	237.780	-0.004
4.246	7.400	4.935	4.913	4.815	3.140	2.910	1.634	3.980	241.560	-0.126
4.253	7.400	4.937	4.916	4.815	3.133	2.976	1.800	3.730	244.790	0.000
4.256	7.600	4.939	4.918	4.815	2.979	2.744	1.716	3.820	245.510	0.148
4.257	7.800	4.942	4.921	4.818	2.970	2.811	1.795	3.760	249.520	0.000
4.265	7.700	4.945	4.924	4.822	3.108	2.952	1.869	3.250	245.350	-0.088
4.260	7.600	4.947	4.927	4.821	3.028	2.944	1.379	3.300	243.580	-0.003
4.262	7.600	4.949	4.929	4.822	2.949	2.863	1.542	3.220	244.480	0.000
4.270	7.300	4.954	4.932	4.824	3.227	3.149	1.948	3.100	239.960	-0.175
4.273	7.400	4.957	4.935	4.826	3.073	2.992	1.943	3.090	238.630	-0.029
4.274	7.400	4.958	4.937	4.828	2.924	2.985	2.102	2.920	235.270	-0.237
4.279	7.300	4.961	4.939	4.834	3.202	3.200	2.579	3.020	237.970	0.000
4.282	7.100	4.964	4.942	4.834	3.195	3.265	2.253	3.030	238.510	0.094
4.282	7.000	4.965	4.944	4.830	2.975	3.113	1.448	3.070	238.580	-0.063
4.285	7.100	4.968	4.947	4.829	3.108	3.104	1.449	2.960	235.760	0.000
4.281	7.100	4.971	4.949	4.819	3.170	3.168	0.404	3.000	233.810	0.335
4.283	7.000	4.972	4.950	4.821	2.954	2.947	0.323	3.040	233.260	0.000
4.287	6.900	4.973	4.951	4.822	2.807	2.726	0.000	3.060	234.830	0.009
4.287	6.800	4.975	4.954	4.824	2.801	2.718	0.241	3.030	236.100	0.044
4.292	6.700	4.977	4.954	4.824	2.726	2.572	0.161	3.090	234.740	0.159
4.299	6.800	4.981	4.959	4.827	2.715	2.703	0.321	2.990	238.960	0.000
4.303	6.600	4.984	4.961	4.828	2.708	2.625	0.240	3.020	243.060	-0.087
4.308	6.500	4.986	4.964	4.829	2.772	2.620	0.080	2.960	245.440	-0.163
4.312	6.600	4.986	4.964	4.829	2.421	2.405	-0.478	3.050	249.470	0.000
4.313	6.600	4.988	4.965	4.829	2.485	2.258	-0.478	3.250	253.270	0.224
4.323	6.500	4.991	4.967	4.830	2.617	2.325	0.000	3.340	252.640	0.313
4.328	6.400	4.992	4.968	4.834	2.337	2.179	0.478	3.560	255.990	0.000
4.334	6.100	4.994	4.970	4.838	2.263	2.034	1.839	4.010	256.710	0.287
4.340	6.100	4.997	4.973	4.835	2.464	2.310	1.440	4.250	253.770	0.000
4.342	6.100	5.000	4.977	4.832	2.663	2.654	1.041	4.260	261.970	0.070
4.347	6.000	5.004	4.981	4.837	2.859	2.715	1.357	4.470	266.620	0.417
4.350	5.900	5.006	4.982	4.841	2.922	2.782	1.753	4.730	267.900	0.041
4.358	5.800	5.007	4.983	4.843	2.576	2.358	1.669	4.760	270.750	0.000
4.364	5.600	5.009	4.985	4.846	2.569	2.353	1.745	5.290	276.730	0.549
4.375	5.500	5.011	4.988	4.847	2.564	2.416	1.822	5.450	285.980	-0.248
4.378	5.600	5.014	4.990	4.850	2.830	2.689	2.057	5.530	288.960	0.000
4.378	5.400	5.017	4.993	4.850	2.823	2.821	2.135	5.920	284.610	0.501
4.379	5.400	5.019	4.995	4.850	2.749	2.747	2.055	5.980	282.990	0.241
4.379	5.800	5.023	4.999	4.852	3.077	3.014	1.813	6.050	288.590	0.000
4.381	5.600	5.025	5.000	4.851	3.071	3.010	1.338	6.010	290.470	0.209
4.384	5.600	5.027	5.002	4.853	2.997	2.865	1.732	6.000	298.060	0.000
4.380	5.700	5.028	5.003	4.855	2.791	2.518	2.284	5.850	291.250	-0.006
4.394	5.700	5.030	5.005	4.857	2.584	2.375	2.041	5.740	292.560	-0.091
4.398	5.600	5.031	5.005	4.862	2.513	2.305	2.110	5.800	292.960	0.025
4.396	5.500	5.034	5.008	4.865	2.707	2.504	2.182	5.760	294.170	0.000
4.398	5.600	5.035	5.008	4.865	2.570	2.299	1.946	5.800	295.450	0.052
4.403	5.600	5.036	5.010	4.871	2.500	2.226	2.404	5.600	289.100	-0.171
4.396	5.600	5.041	5.015	4.874	2.752	2.419	2.475	5.560	285.890	0.073
4.412	5.500	5.043	5.017	4.874	2.681	2.413	2.397	5.220	285.880	0.000
4.411	5.500	5.047	5.021	4.877	2.804	2.608	2.702	5.310	289.330	0.056
4.418	5.600	5.050	5.025	4.877	2.793	2.598	2.469	5.220	299.990	0.000
4.425	5.600	5.052	5.027	4.880	2.788	2.725	2.852	5.240	309.620	-0.027
4.434	5.300	5.054	5.028	4.881	2.782	2.654	2.772	5.270	308.350	0.000
4.433	5.500	5.056	5.029	4.886	2.843	2.653	3.068	5.400	311.880	-0.040
4.439	5.100	5.058	5.030	4.887	2.773	2.582	2.910	5.220	312.620	-0.065
4.444	5.200	5.061	5.034	4.890	2.960	2.906	2.746	5.300	304.170	-0.042
4.444	5.200	5.064	5.038	4.890	3.016	2.964	2.513	5.240	289.640	0.000
4.453	5.400	5.067	5.041	4.888	3.201	3.288	2.287	5.310	289.150	0.048
4.459	5.400	5.070	5.044	4.887	3.323	3.410	1.596	5.290	288.220	-0.029
];

% ln(IP)	UE	Log(CPI)	Log (Core CPI)	Log(PPI)	PiCPI	PiCCPI  PiPPI	EFFR	COMP  R&Rsh
IP=Z(:,1);
UE=Z(:,2);
CPI=Z(:,3);
CPIc=Z(:,4);
PPI=Z(:,5);
PiCPI=Z(:,6);
PiCPIc=Z(:,7);
PiPPI=Z(:,8);
FFR=Z(:,9);
PCOM=Z(:,10);
uRR=Z(:,11);
clear Z