% MPshockdata.m

% This file loads data to be used in empirical analysis of MP shocks from
% VARs vs R&R approach.  This loads: log(IP), UE, log(CPI), log(CPIcore),
% log (PPI finished goods), annual CPI inflation (100*log(CPI/CPI(-12)),
% annual CPI core inflation, annual PPI inflation, Effective FFR, and CRB
% Commodity price index.

% data is from 1968:1 until 1996:12 monthly.

Z=[3.702	3.700	3.529	3.570	3.597	3.582	3.731	3.343	4.600	98.700
3.706	3.800	3.532	3.575	3.597	3.572	4.293	3.060	4.710	98.400
3.709	3.700	3.535	3.578	3.600	3.864	4.280	2.490	5.050	98.700
3.710	3.500	3.538	3.581	3.603	3.852	4.268	2.763	5.760	96.900
3.721	3.500	3.541	3.584	3.605	4.143	4.256	2.755	6.110	96.800
3.725	3.700	3.547	3.589	3.611	4.118	4.521	3.297	6.070	96.300
3.724	3.700	3.552	3.595	3.611	4.393	4.783	3.018	6.020	95.200
3.726	3.500	3.555	3.597	3.614	4.380	4.483	3.288	6.030	96.000
3.730	3.400	3.558	3.603	3.614	4.368	4.743	3.010	5.780	97.000
3.732	3.400	3.564	3.608	3.616	4.639	5.001	3.002	5.910	98.800
3.745	3.400	3.567	3.614	3.616	4.330	5.257	2.725	5.820	99.600
3.748	3.400	3.572	3.616	3.622	4.599	4.960	2.985	6.020	100.800
3.754	3.400	3.575	3.619	3.627	4.585	4.946	2.969	6.300	103.900
3.761	3.400	3.578	3.627	3.632	4.572	5.185	3.500	6.610	105.800
3.768	3.400	3.586	3.632	3.638	5.115	5.436	3.754	6.790	106.500
3.765	3.400	3.592	3.640	3.640	5.376	5.948	3.744	7.410	108.700
3.761	3.400	3.595	3.640	3.643	5.361	5.670	3.734	8.670	110.400
3.771	3.500	3.600	3.645	3.645	5.331	5.639	3.453	8.900	111.300
3.776	3.500	3.605	3.651	3.651	5.301	5.609	3.974	8.610	111.400
3.778	3.500	3.608	3.656	3.658	5.286	5.853	4.480	9.190	113.100
3.778	3.700	3.614	3.661	3.661	5.542	5.822	4.738	9.150	114.100
3.778	3.700	3.619	3.666	3.666	5.511	5.791	4.981	9.000	113.700
3.769	3.500	3.624	3.669	3.664	5.763	5.506	4.725	8.850	113.900
3.766	3.500	3.630	3.674	3.666	5.731	5.746	4.445	8.970	114.900
3.747	3.900	3.635	3.679	3.666	5.980	5.984	3.912	8.980	115.900
3.747	4.200	3.640	3.684	3.666	6.227	5.686	3.381	8.980	116.400
3.745	4.400	3.645	3.691	3.669	5.916	5.907	3.109	7.760	116.200
3.743	4.600	3.651	3.699	3.669	5.884	5.862	2.846	8.100	116.400
3.742	4.800	3.653	3.701	3.669	5.868	6.109	2.584	7.940	113.900
3.738	4.900	3.658	3.709	3.679	5.837	6.323	3.338	7.600	113.600
3.741	5.000	3.661	3.711	3.679	5.550	6.047	2.817	7.210	112.900
3.739	5.100	3.664	3.716	3.684	5.535	6.017	2.545	6.610	112.600
3.732	5.400	3.669	3.721	3.684	5.506	5.987	2.287	6.290	111.000
3.712	5.500	3.674	3.726	3.686	5.477	5.957	2.025	6.200	111.200
3.706	5.900	3.679	3.733	3.691	5.449	6.422	2.781	5.600	108.700
3.729	6.100	3.684	3.738	3.694	5.421	6.390	2.774	4.900	106.200
3.736	5.900	3.686	3.740	3.696	5.143	6.122	3.023	4.140	108.100
3.734	5.900	3.686	3.742	3.701	4.616	5.855	3.518	3.720	110.000
3.733	6.000	3.689	3.742	3.704	4.343	5.104	3.509	3.710	109.500
3.739	5.900	3.691	3.747	3.699	4.072	4.832	3.015	4.150	108.600
3.744	5.900	3.696	3.752	3.706	4.310	5.055	3.755	4.630	108.400
3.748	5.900	3.701	3.757	3.706	4.288	4.786	2.740	4.910	108.700
3.745	6.000	3.704	3.759	3.706	4.277	4.774	2.740	5.310	108.300
3.739	6.100	3.706	3.761	3.709	4.267	4.519	2.482	5.560	108.100
3.756	6.000	3.709	3.761	3.716	4.001	4.034	3.214	5.550	106.800
3.763	5.800	3.711	3.764	3.714	3.736	3.783	2.720	5.200	106.500
3.767	6.000	3.714	3.766	3.721	3.474	3.294	2.949	4.910	105.700
3.779	6.000	3.716	3.768	3.721	3.214	3.048	2.700	4.140	107.300
3.802	5.800	3.718	3.773	3.721	3.206	3.271	2.451	3.500	111.500
3.812	5.700	3.723	3.775	3.726	3.690	3.264	2.439	3.290	112.700
3.819	5.800	3.723	3.775	3.731	3.440	3.264	2.673	3.830	114.900
3.829	5.700	3.726	3.780	3.733	3.432	3.249	3.407	4.170	115.700
3.829	5.700	3.728	3.782	3.738	3.175	3.006	3.144	4.270	119.500
3.832	5.700	3.731	3.784	3.742	2.920	2.765	3.619	4.460	118.800
3.832	5.600	3.733	3.786	3.738	2.913	2.759	3.144	4.550	119.700
3.845	5.600	3.735	3.791	3.745	2.906	2.978	3.611	4.800	122.000
3.852	5.500	3.740	3.791	3.754	3.137	2.978	3.819	4.870	123.000
3.865	5.600	3.742	3.793	3.761	3.129	2.972	4.763	5.040	125.200
3.877	5.300	3.747	3.793	3.773	3.358	2.740	5.190	5.060	127.900
3.888	5.200	3.750	3.798	3.793	3.350	2.958	7.238	5.330	131.600
3.895	4.900	3.754	3.798	3.800	3.576	2.497	7.911	5.940	136.100
3.910	5.000	3.761	3.802	3.807	3.792	2.715	8.097	6.580	146.100
3.910	4.900	3.770	3.807	3.818	4.718	3.161	8.721	7.090	148.800
3.908	5.000	3.777	3.809	3.816	5.165	2.925	8.262	7.120	153.800
3.915	4.900	3.782	3.813	3.850	5.381	3.139	11.248	7.840	166.300
3.916	4.900	3.789	3.816	3.848	5.822	3.132	10.560	8.490	171.900
3.920	4.800	3.789	3.818	3.846	5.583	3.125	10.821	10.400	195.100
3.918	4.800	3.807	3.822	3.854	7.138	3.111	10.961	10.500	202.000
3.927	4.800	3.811	3.829	3.863	7.105	3.766	10.863	10.780	195.000
3.934	4.600	3.820	3.835	3.888	7.749	4.190	12.653	10.010	187.500
3.939	4.800	3.826	3.839	3.906	7.932	4.621	13.324	10.030	192.100
3.937	4.900	3.835	3.844	3.916	8.564	4.601	12.278	9.950	206.000
3.930	5.100	3.846	3.848	3.926	9.168	5.028	12.595	9.650	217.500
3.926	5.200	3.857	3.854	3.938	9.531	5.219	13.103	8.970	239.300
3.927	5.100	3.867	3.863	3.938	9.657	5.617	11.998	9.350	233.000
3.924	5.100	3.873	3.869	3.965	9.593	6.023	14.910	10.510	229.400
3.931	5.100	3.884	3.882	3.983	10.171	6.826	13.327	11.310	216.900
3.930	5.400	3.892	3.892	3.995	10.310	7.631	14.651	11.930	226.900
3.930	5.500	3.898	3.902	4.013	10.920	8.426	16.689	12.920	249.900
3.921	5.500	3.910	3.916	4.032	10.336	9.392	17.808	12.010	236.300
3.922	5.900	3.924	3.926	4.032	11.285	9.728	16.964	11.340	229.600
3.918	6.000	3.932	3.936	4.038	11.192	10.060	15.004	10.060	228.600
3.885	6.600	3.942	3.944	4.036	11.512	10.407	13.000	9.450	223.300
3.849	7.200	3.949	3.951	4.036	11.418	10.750	11.999	8.530	207.900
3.836	8.100	3.957	3.957	4.045	11.111	10.898	11.888	7.130	203.000
3.812	8.100	3.963	3.967	4.050	10.621	11.212	11.235	6.240	199.000
3.801	8.600	3.967	3.970	4.059	9.949	10.746	12.103	5.540	200.800
3.802	8.800	3.970	3.976	4.067	9.701	10.682	10.270	5.490	198.900
3.800	9.000	3.972	3.980	4.076	8.855	9.812	9.243	5.220	192.500
3.807	8.800	3.980	3.985	4.083	8.786	9.345	8.809	5.550	189.900
3.817	8.600	3.989	3.989	4.091	9.106	8.701	7.823	6.100	201.300
3.826	8.400	3.993	3.993	4.094	8.266	7.667	6.188	6.140	208.400
3.839	8.400	4.000	3.998	4.096	7.608	7.227	6.354	6.240	205.800
3.843	8.400	4.006	4.004	4.094	7.369	6.795	5.657	5.820	197.300
3.846	8.300	4.013	4.011	4.093	7.119	6.744	5.667	5.220	190.800
3.858	8.200	4.018	4.016	4.094	6.886	6.514	5.834	5.200	188.300
3.873	7.900	4.022	4.024	4.099	6.478	6.657	5.453	4.870	188.700
3.882	7.700	4.024	4.029	4.101	6.085	6.241	5.094	4.770	193.700
3.883	7.600	4.025	4.034	4.103	5.884	6.395	4.393	4.840	197.300
3.889	7.700	4.027	4.038	4.106	5.684	6.184	3.863	4.820	203.200
3.894	7.400	4.032	4.043	4.109	6.029	6.337	3.339	5.290	202.600
3.893	7.600	4.038	4.047	4.113	5.809	6.128	2.990	5.480	210.900
3.899	7.800	4.043	4.054	4.117	5.407	6.454	2.640	5.310	212.800
3.906	7.800	4.048	4.059	4.126	5.562	6.604	3.118	5.290	204.900
3.908	7.600	4.054	4.064	4.134	5.349	6.568	3.756	5.250	199.800
3.909	7.700	4.059	4.069	4.135	5.320	6.534	4.082	5.020	194.300
3.924	7.800	4.062	4.072	4.146	4.939	6.148	5.363	4.950	197.300
3.934	7.800	4.067	4.076	4.154	4.913	5.946	5.984	4.650	201.900
3.929	7.500	4.072	4.083	4.159	5.067	5.904	5.955	4.610	211.600
3.944	7.600	4.083	4.089	4.165	5.904	6.042	6.412	4.680	212.500
3.956	7.400	4.088	4.094	4.168	6.230	6.010	6.557	4.690	219.200
3.965	7.200	4.094	4.099	4.171	6.721	6.156	6.536	4.730	220.900
3.973	7.000	4.098	4.104	4.177	6.520	6.124	6.823	5.350	215.500
3.980	7.200	4.103	4.111	4.182	6.487	6.432	6.954	5.390	206.700
3.982	6.900	4.108	4.114	4.188	6.454	6.062	7.073	5.420	203.500
3.983	7.000	4.113	4.119	4.196	6.421	6.032	7.018	5.900	200.900
3.988	6.800	4.116	4.124	4.200	6.226	6.002	6.664	6.140	201.900
3.990	6.800	4.121	4.127	4.205	6.194	5.811	6.953	6.470	201.900
3.991	6.800	4.127	4.132	4.212	6.497	5.952	6.582	6.510	209.400
3.992	6.400	4.132	4.138	4.217	6.465	6.252	6.238	6.560	213.200
3.979	6.400	4.138	4.145	4.228	6.592	6.211	6.941	6.700	219.100
3.983	6.300	4.143	4.149	4.236	6.053	6.013	7.044	6.780	220.100
4.001	6.300	4.149	4.156	4.244	6.181	6.141	7.599	6.790	228.000
4.021	6.100	4.157	4.164	4.253	6.297	6.423	8.147	6.890	225.500
4.025	6.000	4.167	4.170	4.254	6.899	6.547	7.673	7.360	232.000
4.033	5.900	4.174	4.177	4.264	7.174	6.659	8.204	7.600	230.000
4.033	6.200	4.182	4.184	4.268	7.446	6.943	8.016	7.810	229.000
4.036	5.900	4.188	4.191	4.277	7.563	7.213	8.097	8.040	239.600
4.039	6.000	4.197	4.200	4.288	8.142	7.630	8.751	8.450	244.100
4.047	5.800	4.206	4.208	4.300	8.552	8.054	9.531	8.960	256.500
4.054	5.900	4.212	4.214	4.309	8.499	8.165	9.733	9.760	250.400
4.060	6.000	4.218	4.220	4.317	8.607	8.115	10.093	10.030	250.300
4.053	5.900	4.227	4.227	4.328	8.847	8.211	9.981	10.070	259.500
4.059	5.900	4.237	4.237	4.333	9.387	8.754	9.781	10.060	270.900
4.062	5.800	4.247	4.246	4.339	9.760	8.988	9.440	10.090	277.700
4.051	5.800	4.257	4.253	4.349	9.971	8.921	9.621	10.010	276.900
4.059	5.600	4.268	4.260	4.359	10.163	9.010	10.508	10.240	277.600
4.059	5.700	4.279	4.267	4.376	10.505	8.944	11.167	10.290	281.300
4.057	5.700	4.290	4.275	4.387	10.841	9.170	11.872	10.470	277.800
4.050	6.000	4.300	4.286	4.399	11.186	9.517	12.271	10.940	281.800
4.051	5.900	4.309	4.295	4.409	11.225	9.436	12.144	11.430	279.400
4.057	6.000	4.320	4.304	4.424	11.397	9.639	12.365	13.770	278.100
4.056	5.900	4.331	4.315	4.438	11.861	10.121	12.848	13.180	283.100
4.057	6.000	4.343	4.327	4.449	12.447	10.727	13.103	13.780	287.500
4.061	6.300	4.357	4.340	4.457	12.988	11.307	12.857	13.820	288.000
4.062	6.300	4.369	4.350	4.461	13.245	11.328	12.794	14.130	294.200
4.059	6.300	4.383	4.364	4.469	13.621	11.874	13.075	17.190	280.800
4.039	6.900	4.393	4.376	4.485	13.618	12.299	13.627	17.610	270.700
4.013	7.500	4.403	4.383	4.496	13.476	12.342	13.720	10.980	263.500
4.001	7.600	4.413	4.394	4.501	13.336	12.755	12.516	9.470	265.100
3.994	7.800	4.414	4.392	4.509	12.355	11.670	12.165	9.030	282.000
3.997	7.700	4.421	4.398	4.515	12.124	11.180	11.587	9.610	289.200
4.014	7.500	4.430	4.408	4.520	12.017	11.338	11.046	10.870	292.500
4.026	7.500	4.439	4.419	4.530	11.896	11.478	10.680	12.810	300.100
4.043	7.500	4.450	4.430	4.539	11.895	11.481	10.110	15.850	297.800
4.049	7.200	4.459	4.441	4.551	11.648	11.470	10.220	18.900	283.500
4.043	7.500	4.468	4.447	4.561	11.150	10.744	10.455	19.080	276.200
4.038	7.400	4.477	4.453	4.564	10.789	10.291	10.305	15.930	275.700
4.044	7.400	4.484	4.459	4.570	10.086	9.462	10.019	14.700	275.900
4.038	7.200	4.490	4.466	4.572	9.655	9.015	8.635	15.720	274.500
4.045	7.500	4.496	4.475	4.573	9.342	9.179	7.618	18.520	271.800
4.050	7.500	4.505	4.484	4.577	9.255	8.968	7.585	19.100	265.800
4.057	7.200	4.516	4.498	4.581	10.233	10.561	7.222	19.040	276.900
4.057	7.400	4.524	4.508	4.584	10.271	10.941	6.870	17.820	267.900
4.051	7.600	4.534	4.520	4.588	10.405	11.167	6.841	15.870	262.700
4.043	7.900	4.537	4.523	4.594	9.778	10.403	6.366	15.080	256.300
4.033	8.300	4.541	4.527	4.593	9.148	9.758	5.407	13.310	253.600
4.022	8.500	4.544	4.533	4.593	8.537	9.113	4.238	12.370	250.000
4.002	8.600	4.548	4.536	4.595	7.934	8.847	3.390	13.220	256.800
4.021	8.900	4.551	4.541	4.595	7.338	8.798	3.077	14.780	248.700
4.014	9.000	4.551	4.542	4.603	6.658	8.324	3.363	14.680	246.400
4.005	9.300	4.554	4.551	4.607	6.412	8.481	3.555	14.940	247.500
3.998	9.400	4.563	4.558	4.611	6.684	8.302	3.851	14.450	245.500
3.994	9.600	4.575	4.565	4.612	6.936	8.126	3.538	14.150	239.400
3.991	9.800	4.580	4.572	4.615	6.351	7.403	3.424	12.590	241.800
3.982	9.800	4.582	4.576	4.619	5.794	6.818	3.513	10.120	239.300
3.978	10.100	4.582	4.577	4.623	4.823	5.716	3.499	10.310	234.500
3.970	10.400	4.586	4.580	4.615	4.910	5.698	2.101	9.710	231.200
3.967	10.800	4.585	4.578	4.616	4.380	5.059	2.301	9.200	226.600
3.960	10.800	4.582	4.577	4.615	3.754	4.417	2.202	8.950	227.400
3.978	10.400	4.584	4.581	4.616	3.641	4.506	2.099	8.680	234.800
3.973	10.400	4.585	4.585	4.619	3.425	4.380	2.395	8.510	241.500
3.981	10.300	4.586	4.587	4.621	3.527	4.478	1.788	8.770	247.900
3.993	10.200	4.593	4.591	4.621	3.922	4.036	1.388	8.800	250.200
4.000	10.100	4.597	4.594	4.624	3.383	3.603	1.284	8.630	248.100
4.005	10.100	4.599	4.597	4.627	2.444	3.175	1.479	8.980	247.300
4.021	9.400	4.603	4.603	4.627	2.332	3.155	1.181	9.370	256.400
4.032	9.500	4.606	4.606	4.625	2.427	3.043	0.590	9.560	273.700
4.047	9.200	4.609	4.610	4.628	2.726	3.339	0.490	9.450	266.700
4.055	8.800	4.613	4.615	4.635	2.715	3.527	1.961	9.480	266.400
4.058	8.500	4.616	4.620	4.639	3.114	4.226	2.249	9.340	269.100
4.063	8.300	4.619	4.623	4.642	3.717	4.624	2.735	9.470	277.800
4.083	8.000	4.626	4.630	4.643	4.201	4.899	2.732	9.560	280.800
4.088	7.800	4.631	4.633	4.642	4.587	4.782	2.339	9.590	280.100
4.093	7.800	4.634	4.637	4.642	4.777	4.966	2.142	9.910	288.200
4.099	7.700	4.638	4.642	4.644	4.454	5.043	2.335	10.290	285.700
4.103	7.400	4.640	4.645	4.642	4.243	5.124	1.847	10.320	291.000
4.107	7.200	4.642	4.649	4.642	4.235	5.205	1.553	11.060	286.900
4.110	7.500	4.645	4.654	4.641	4.218	5.079	1.361	11.230	272.000
4.110	7.500	4.648	4.658	4.644	4.206	5.159	1.942	11.640	276.800
4.109	7.300	4.651	4.662	4.644	4.194	5.139	1.648	11.300	267.100
4.108	7.400	4.655	4.665	4.644	4.177	5.020	0.966	9.990	266.700
4.112	7.200	4.657	4.667	4.645	4.070	4.715	0.675	9.430	268.400
4.113	7.300	4.659	4.671	4.645	3.964	4.795	0.289	8.380	257.200
4.110	7.300	4.661	4.674	4.650	3.465	4.390	0.671	8.350	256.900
4.115	7.200	4.666	4.679	4.653	3.543	4.656	1.054	8.500	251.900
4.116	7.200	4.671	4.683	4.650	3.720	4.639	0.768	8.580	256.800
4.114	7.300	4.673	4.686	4.651	3.519	4.433	0.671	8.270	254.100
4.115	7.200	4.675	4.690	4.649	3.512	4.416	0.672	7.970	246.800
4.115	7.400	4.677	4.692	4.642	3.599	4.308	0.000	7.530	242.600
4.109	7.400	4.679	4.695	4.653	3.400	4.105	1.247	7.880	237.600
4.113	7.100	4.681	4.699	4.659	3.298	4.090	1.432	7.900	233.100
4.117	7.100	4.683	4.700	4.663	3.196	3.893	1.905	7.920	229.400
4.113	7.100	4.687	4.705	4.659	3.184	3.969	1.432	7.990	230.100
4.117	7.000	4.691	4.710	4.645	3.453	4.323	0.000	8.050	233.400
4.127	7.000	4.696	4.713	4.633	3.721	4.217	-1.257	8.270	236.700
4.132	6.700	4.700	4.718	4.628	3.897	4.384	-2.223	8.140	231.600
4.124	7.200	4.698	4.720	4.633	3.148	4.093	-2.022	7.860	223.600
4.118	7.200	4.692	4.723	4.636	2.131	3.990	-1.444	7.480	216.100
4.119	7.100	4.689	4.727	4.628	1.576	4.067	-2.319	6.990	214.700
4.120	7.200	4.691	4.728	4.632	1.665	3.876	-1.737	6.850	215.100
4.117	7.200	4.695	4.731	4.634	1.752	3.866	-0.871	6.920	220.300
4.123	7.000	4.696	4.734	4.640	1.657	3.943	-1.344	6.560	220.600
4.121	6.900	4.697	4.738	4.639	1.563	3.929	-2.011	6.170	209.000
4.123	7.000	4.700	4.741	4.641	1.742	4.097	-2.290	5.890	219.300
4.128	7.000	4.702	4.745	4.645	1.555	3.992	-1.336	5.850	226.160
4.133	6.900	4.704	4.748	4.648	1.276	3.711	0.288	6.040	228.240
4.142	6.600	4.708	4.750	4.649	1.180	3.701	1.640	6.910	228.330
4.139	6.600	4.713	4.753	4.655	1.356	3.512	2.700	6.430	229.450
4.151	6.600	4.717	4.755	4.656	1.896	3.503	2.308	6.100	225.890
4.153	6.600	4.720	4.759	4.659	2.802	3.580	2.301	6.130	227.910
4.158	6.300	4.725	4.765	4.661	3.614	3.823	3.270	6.370	239.500
4.165	6.300	4.727	4.768	4.662	3.604	3.987	3.068	6.850	249.200
4.170	6.200	4.732	4.770	4.665	3.679	3.892	3.157	6.730	251.870
4.176	6.100	4.734	4.773	4.663	3.852	3.878	2.387	6.580	252.780
4.183	6.000	4.739	4.777	4.663	4.199	3.865	2.483	6.730	254.540
4.186	5.900	4.742	4.781	4.662	4.184	3.935	2.101	7.220	255.080
4.201	6.000	4.745	4.786	4.667	4.264	4.089	2.185	7.290	253.850
4.206	5.800	4.748	4.788	4.666	4.429	4.079	1.804	6.690	254.400
4.211	5.700	4.750	4.791	4.669	4.241	4.068	1.990	6.770	258.210
4.211	5.700	4.754	4.795	4.673	4.046	4.224	1.792	6.830	258.890
4.216	5.700	4.755	4.797	4.675	3.860	4.213	1.883	6.580	257.000
4.218	5.700	4.758	4.802	4.677	3.761	4.281	1.878	6.580	261.200
4.223	5.400	4.764	4.806	4.686	3.915	4.174	2.522	6.870	263.500
4.223	5.600	4.766	4.810	4.690	3.905	4.160	2.702	7.090	272.550
4.225	5.400	4.771	4.814	4.691	3.888	4.397	2.602	7.510	283.750
4.227	5.400	4.775	4.817	4.693	4.047	4.383	2.974	7.750	276.620
4.232	5.600	4.779	4.820	4.697	4.030	4.368	3.340	8.010	276.530
4.228	5.400	4.783	4.826	4.700	4.100	4.511	3.893	8.190	271.880
4.234	5.400	4.787	4.830	4.710	4.173	4.409	4.323	8.300	274.530
4.236	5.300	4.790	4.833	4.718	4.158	4.478	5.134	8.350	274.190
4.240	5.300	4.793	4.836	4.721	4.317	4.546	5.209	8.760	284.350
4.242	5.400	4.797	4.840	4.728	4.385	4.528	5.544	9.120	286.730
4.238	5.200	4.801	4.843	4.736	4.542	4.596	6.150	9.360	287.210
4.241	5.000	4.806	4.847	4.736	4.777	4.577	5.871	9.850	285.120
4.240	5.200	4.813	4.850	4.734	4.912	4.399	4.861	9.840	282.600
4.233	5.200	4.818	4.854	4.731	5.142	4.463	4.141	9.810	280.130
4.234	5.300	4.821	4.858	4.736	5.040	4.445	4.485	9.530	282.580
4.225	5.200	4.824	4.861	4.741	4.939	4.431	4.827	9.240	277.220
4.234	5.200	4.824	4.864	4.743	4.518	4.340	4.635	8.990	278.020
4.231	5.300	4.827	4.867	4.749	4.340	4.085	4.879	9.020	274.590
4.230	5.300	4.832	4.872	4.768	4.485	4.223	5.771	8.840	270.320
4.233	5.400	4.835	4.876	4.767	4.550	4.286	4.968	8.550	265.600
4.240	5.400	4.839	4.880	4.766	4.535	4.349	4.526	8.450	260.600
4.234	5.400	4.848	4.884	4.766	5.067	4.332	3.731	8.230	260.410
4.243	5.300	4.852	4.888	4.766	5.129	4.469	3.024	8.240	264.000
4.248	5.200	4.857	4.894	4.767	5.105	4.677	3.109	8.280	271.300
4.247	5.400	4.859	4.898	4.770	4.604	4.737	3.539	8.260	273.060
4.249	5.400	4.861	4.901	4.781	4.273	4.645	4.988	8.180	278.440
4.251	5.200	4.867	4.906	4.793	4.568	4.775	5.711	8.290	277.490
4.250	5.500	4.871	4.911	4.803	4.707	4.982	6.175	8.150	276.550
4.252	5.700	4.880	4.917	4.809	5.546	5.338	6.574	8.130	271.100
4.254	5.900	4.887	4.921	4.804	5.987	5.395	5.475	8.200	273.090
4.247	5.900	4.893	4.924	4.809	6.184	5.221	4.079	8.110	263.070
4.235	6.200	4.896	4.927	4.802	6.011	5.129	3.509	7.810	261.380
4.228	6.300	4.899	4.932	4.798	6.067	5.183	3.183	7.310	258.130
4.223	6.400	4.903	4.938	4.798	5.493	5.451	3.268	6.910	255.690
4.217	6.600	4.904	4.943	4.801	5.176	5.498	3.430	6.250	255.970
4.212	6.800	4.904	4.945	4.799	4.709	5.111	3.180	6.120	255.130
4.214	6.700	4.906	4.948	4.797	4.698	5.021	2.678	5.910	253.760
4.224	6.900	4.910	4.951	4.798	4.912	5.006	1.746	5.780	248.280
4.233	6.900	4.913	4.954	4.800	4.589	4.840	0.661	5.900	243.290
4.233	6.800	4.914	4.958	4.803	4.275	4.675	0.000	5.820	246.830
4.234	6.900	4.917	4.962	4.807	3.729	4.509	-0.163	5.660	241.250
4.243	6.900	4.920	4.966	4.806	3.340	4.493	0.246	5.450	244.530
4.241	7.000	4.921	4.968	4.804	2.809	4.338	-0.491	5.210	242.120
4.240	7.000	4.926	4.971	4.806	3.020	4.395	0.410	4.810	242.540
4.236	7.300	4.929	4.975	4.807	2.937	4.307	0.903	4.430	238.240
4.230	7.300	4.929	4.977	4.808	2.638	3.936	0.984	4.030	237.110
4.238	7.400	4.932	4.979	4.811	2.780	3.642	1.063	4.060	237.780
4.246	7.400	4.935	4.983	4.815	3.140	3.771	1.634	3.980	241.560
4.253	7.400	4.937	4.986	4.815	3.133	3.761	1.800	3.730	244.790
4.256	7.600	4.939	4.989	4.815	2.979	3.819	1.716	3.820	245.510
4.257	7.800	4.942	4.991	4.818	2.970	3.670	1.795	3.760	249.520
4.265	7.700	4.945	4.995	4.822	3.108	3.657	1.869	3.250	245.350
4.260	7.600	4.947	4.997	4.821	3.028	3.439	1.379	3.300	243.580
4.262	7.600	4.949	4.998	4.822	2.949	3.225	1.542	3.220	244.480
4.270	7.300	4.954	5.003	4.824	3.227	3.488	1.948	3.100	239.960
4.273	7.400	4.957	5.005	4.826	3.073	3.409	1.943	3.090	238.630
4.274	7.400	4.958	5.008	4.828	2.924	3.330	2.102	2.920	235.270
4.279	7.300	4.961	5.011	4.834	3.202	3.388	2.579	3.020	237.970
4.282	7.100	4.964	5.015	4.834	3.195	3.514	2.253	3.030	238.510
4.282	7.000	4.965	5.016	4.830	2.975	3.303	1.448	3.070	238.580
4.285	7.100	4.968	5.020	4.829	3.108	3.427	1.449	2.960	235.760
4.281	7.100	4.971	5.023	4.819	3.170	3.349	0.404	3.000	233.810
4.283	7.000	4.972	5.025	4.821	2.954	3.343	0.323	3.040	233.260
4.287	6.900	4.973	5.026	4.822	2.807	3.135	0.000	3.060	234.830
4.287	6.800	4.975	5.029	4.824	2.801	3.259	0.241	3.030	236.100
4.292	6.700	4.977	5.030	4.824	2.726	3.190	0.161	3.090	234.740
4.299	6.800	4.981	5.033	4.827	2.715	3.045	0.321	2.990	238.960
4.303	6.600	4.984	5.036	4.828	2.708	3.102	0.240	3.020	243.060
4.308	6.500	4.986	5.039	4.829	2.772	3.093	0.080	2.960	245.440
4.312	6.600	4.986	5.040	4.829	2.421	2.889	-0.478	3.050	249.470
4.313	6.600	4.988	5.042	4.829	2.485	2.751	-0.478	3.250	253.270
4.323	6.500	4.991	5.045	4.830	2.617	2.940	0.000	3.340	252.640
4.328	6.400	4.992	5.047	4.834	2.337	2.672	0.478	3.560	255.990
4.334	6.100	4.994	5.049	4.838	2.263	2.665	1.839	4.010	256.710
4.340	6.100	4.997	5.052	4.835	2.464	2.788	1.440	4.250	253.770
4.342	6.100	5.000	5.054	4.832	2.663	2.848	1.041	4.260	261.970
4.347	6.000	5.004	5.057	4.837	2.859	2.775	1.357	4.470	266.620
4.350	5.900	5.006	5.059	4.841	2.922	2.964	1.753	4.730	267.900
4.358	5.800	5.007	5.061	4.843	2.576	2.828	1.669	4.760	270.750
4.364	5.600	5.009	5.064	4.846	2.569	2.756	1.745	5.290	276.730
4.375	5.500	5.011	5.064	4.847	2.564	2.559	1.822	5.450	285.980
4.378	5.600	5.014	5.069	4.850	2.830	2.871	2.057	5.530	288.960
4.378	5.400	5.017	5.071	4.850	2.823	2.928	2.135	5.920	284.610
4.379	5.400	5.019	5.075	4.850	2.749	2.919	2.055	5.980	282.990
4.379	5.800	5.023	5.078	4.852	3.077	3.102	1.813	6.050	288.590
4.381	5.600	5.025	5.080	4.851	3.071	3.032	1.338	6.010	290.470
4.384	5.600	5.027	5.082	4.853	2.997	2.961	1.732	6.000	298.060
4.380	5.700	5.028	5.084	4.855	2.791	2.955	2.284	5.850	291.250
4.394	5.700	5.030	5.086	4.857	2.584	2.948	2.041	5.740	292.560
4.398	5.600	5.031	5.089	4.862	2.513	2.940	2.110	5.800	292.960
4.396	5.500	5.034	5.092	4.865	2.707	3.058	2.182	5.760	294.170
4.398	5.600	5.035	5.094	4.865	2.570	2.989	1.946	5.800	295.450
4.403	5.600	5.036	5.094	4.871	2.500	2.987	2.404	5.600	289.100
4.396	5.600	5.041	5.098	4.874	2.752	2.913	2.475	5.560	285.890
4.412	5.500	5.043	5.100	4.874	2.681	2.845	2.397	5.220	285.880
4.411	5.500	5.047	5.102	4.877	2.804	2.775	2.702	5.310	289.330
4.418	5.600	5.050	5.104	4.877	2.793	2.585	2.469	5.220	299.990
4.425	5.600	5.052	5.106	4.880	2.788	2.641	2.852	5.240	309.620
4.434	5.300	5.054	5.108	4.881	2.782	2.634	2.772	5.270	308.350
4.433	5.500	5.056	5.110	4.886	2.843	2.629	3.068	5.400	311.880
4.439	5.100	5.058	5.112	4.887	2.773	2.563	2.910	5.220	312.620
4.444	5.200	5.061	5.115	4.890	2.960	2.617	2.746	5.300	304.170
4.444	5.200	5.064	5.117	4.890	3.016	2.489	2.513	5.240	289.640
4.453	5.400	5.067	5.119	4.888	3.201	2.544	2.287	5.310	289.150
4.459	5.400	5.070	5.120	4.887	3.323	2.602	1.596	5.290	288.220
];

% ln(IP)	UE	Log(CPI)	Log (Core CPI)	Log(PPI)	PiCPI	PiCCPI	PiPPI	EFFR	COMP
IP=Z(:,1);
UE=Z(:,2);
CPI=Z(:,3);
CPIc=Z(:,4);
PPI=Z(:,5);
PiCPI=Z(:,6);
PiCPIc=Z(:,7);
PiPPI=Z(:,8);
FFR=Z(:,9);
PCOM=Z(:,10);
clear Z