clear
set more off
#delimit;
tempfile data;
local datasetname TAQ;

/*************************************************************************************************************
This do-file loads data from the WRDS TAQ database via PC-SAS. TAQ contains intraday price and volume for stocks
listed on the NYSE. The file writes a SAS file and then executes it.

SAS programming notes
*libname defines the path where the dataset will be saved.
*The line letwrds = ... initiates a login to a remote session.
*rsubmit is a remote submit command to the WRDS server. The inheritlib option puts the local work folder into the remote server with 
 the name pcwork. Otherwise folders in the remote server are unavailable once the remote session has ended.
*Obtaining the full trading day for each BHC would result in too large a data set. Instead, this file specifies a separate
 intraday window for each announcement date. It has SAS append the dates together.

*************************************************************************************************************/
qui unzipfile "$DataPath/CRSPQ_BHC_stocknames", replace;
qui use crspq_bhc_stocknames;
erase crspq_bhc_stocknames.dta;
qui levelsof ticker, local(tickers);

local j = 1;
foreach ticker of local tickers {;
	if length(`"`symbol_list`j''"')<1000 {;
		local symbol_list`j' `"`symbol_list`j''"`ticker'","';
	};
	else {;
		local symbol_list `"`symbol_list' `"`symbol_list`j''"' _n"';
		local j = `j'+1; 
		local symbol_list`j' `""`ticker'","';
	};
};
local symbol_list `"`symbol_list' `"`symbol_list`j''"'"';

capture erase SAS_PC_`datasetname'.sas;
capture erase "$DataPath/sas7bdat/`datasetname'_BHC.sas7bdat";

foreach datetime of global datetimes {;

	if inlist(`datetime',`=tC(25nov2008 8:15:00)',`=tC(12aug2009 14:16:10)',`=tC(4nov2009 14:19:00)',`=tC(27aug2010 10:00:00)',`=tC(31aug2012 10:00:00)',`=tC(12dec2012 12:30:02)',`=tC(18dec2013 14:00:00)') {; 
		continue; /*Dates without any "action" in the Treasury market*/
	};

	/*Identify TAQ dataset. TAQ has a separate dataset for each day*/
	local date = string(dofC(`datetime'),`"%td"'); 
	foreach unit in year month day {;
		local `unit' = `unit'(td(`date'));
		if ``unit''<10 {; /*Requires two digit month and day*/
			local `unit' 0``unit'';
		};
	};
	local dataset `"`"`datasetname'.ct_`year'`month'`day'"' _n "';
	
	/*Identify intraday window*/
	local timemin = string(`datetime'-msofminutes(31),`"%tCHH:MM:SS"');
	local timemax = string(`datetime'+msofminutes(121),`"%tCHH:MM:SS"');

	/*Write SAS program*/
	#delimit cr
	file open sassteps using SAS_PC_`datasetname'.sas, write append
	file write sassteps ///
	`"libname raw '$DataPath\sas7bdat';"' _n ///
	`"%let wrds = wrds.wharton.upenn.edu 4016;options comamid = TCP remote=WRDS;signon username=_prompt_;"' _n ///
	`"rsubmit inheritlib=(work=pcwork);"' _n ///
	`"data pcwork.`datasetname';"' _n ///
	`"set"' _n ///
	`dataset' `";"' _n ///
	`"by symbol date time;"' _n ///
	`"where SYMBOL in ("' _n ///
	`symbol_list' ///
	`")"' _n /// 
	`"and time >= '`timemin''t and time <='`timemax''t;"' _n ///
	`"run;"' _n `"endrsubmit;"' _n `"run;"' _n ///
	`"proc append base=raw.`datasetname'_BHC data=work.`datasetname';"' _n ///
	`"run;"' _n(2)
	file close sassteps
	#delimit;
};


*Run the .sas file and load the .dta dataset. Need to point to SAS executable location;
!"C:\Program Files\SASHome\SASFoundation\9.3\sas.exe" SAS_PC_`datasetname';


