/*************************************************************************************************************
Program to construct event time variable. The program defines a new variable with 0 at the time of the event,
-1 from lower minus band to lower, and 1 from upper to band plus upper.

Required variables:
datetime: variable containing date-time
lower: minimum time between event and lower window
upper: minimum time between event and upper window
band: length of band of each window
generate: new variable name containing event time
*************************************************************************************************************/

capture program drop eventtime
program define eventtime
version 12.1
syntax varlist(min=1 max=1) [if] [in], lower(integer) upper(integer) band(string) GENerate(name) 
#delimit;

local datetimevar `varlist';
run QE_dates;
global dates;
forvalues q = 1/4 {;
	local i = 1;
	while `"${QE`q'_`i'}"'!=`""' {; 
		local datelist `"`datelist' QE`q'_`i'"';
		local i = `i'+1;
	};
}; 

qui gen `generate' = .;

foreach date of local datelist {;

	local datetimesec = Clock(`"${`date'}"',`"DMYhms"');
	local datetime = Cdhms(dofc(`datetimesec'),hhC(`datetimesec'),mmC(`datetimesec'),0);
	local datetime0 = `datetime' - msofminutes(`lower');
	local datetime1 = `datetime' + msofminutes(`upper');

	qui replace `generate' = -1 if inrange(`datetimevar',`=`datetime0' - tC(`band')',`datetime0');
	qui replace `generate' = 1 if inrange(`datetimevar',`datetime1',`=`datetime1'+ tC(`band')');
	qui replace `generate' = 0 if `datetimevar'==`datetime';
	
};

end;
