clear
set more off
#delimit;
tempfile data;
local datasetname TRACE;

/*************************************************************************************************************
This do-file loads data from the WRDS TRACE database via PC-SAS. TRACE contains intraday quotes for corporate bonds. 
The file writes a SAS file and then executes it. The cusip_id list contains the 5 most actively traded investment grade and high yield
cusips, according to http://wrds-web.wharton.upenn.edu/wrds/support/Data/_001Manuals%20and%20Overviews/_130Trace/Trace%20User%20Guide.pdf.cfm
p. 56.

SAS programming notes
*libname defines the path where the dataset will be saved.
*The line letwrds = ... initiates a login to a remote session.
*rsubmit is a remote submit command to the WRDS server. The inheritlib option puts the local work folder into the remote server with 
 the name pcwork. Otherwise folders in the remote server are unavailable once the remote session has ended.

*Code to sort first. I decided this in fact was not more efficient.
`"PROC SORT DATA=`dataset' OUT=sorted;"' _n ///
`"BY company_symbol trd_exctn_dt;"' _n ///
`"run;"' _n ///
*************************************************************************************************************/
foreach ticker of global LI_tickers {;
	local symbol_list `"`symbol_list'"`ticker'","';
};
local symbol_list = regexr(`"`symbol_list'"',`",$"',`""');

foreach date of global dates {;
	local date_list `"`date_list''`date''d,"';
};
local date_list = regexr(`"`date_list'"',`",$"',`""');
local dataset `"TRACE.TRACE"';

#delimit cr
file open sassteps using SAS_PC_`datasetname'.sas, write replace
file write sassteps ///
`"libname raw '$DataPath\sas7bdat';"' _n ///
`"%let wrds = wrds.wharton.upenn.edu 4016;options comamid = TCP remote=WRDS;signon username=_prompt_;"' _n ///
`"rsubmit inheritlib=(work=pcwork);"' _n ///
`"data pcwork.`datasetname';"' _n ///
`"set `dataset';"' _n ///
`"where (COMPANY_SYMBOL in (`symbol_list') OR CUSIP_ID in ("78387GAQ6","61746SBC2","172967BF7","345397UC5","172967BH3","370425RZ5","13134VAA1","521865AE5","247126AD7","345370CA6"))"' _n ///
`"and trd_exctn_dt in (`date_list');"' _n ///
`"run;"' _n `"endrsubmit;"' _n `"run;"' _n ///
`"data raw.`datasetname'_LI;"' _n `"set work.`datasetname';"' _n ///
`"run;"' 
file close sassteps
#delimit;

*Run the .sas file and load the .dta dataset. Need to point to SAS executable location;
!"C:\Program Files\SASHome\SASFoundation\9.3\sas.exe" SAS_PC_`datasetname';


