/*************************************************************************************************************
Program to embed .tex regression output in a tex file that will compile.

Required:
infilename: name of .tex file(s) containing regression output
using: name of output .tex file that will compile

Options:
append: inserts the table at the bottom of an existing file of tables (this and only this part of the file relies on a command line instruction that may be system-dependent)
replace: replaces existing embed file with a new file containing the single table
title: title of latex file
author: author of latex file
landscape: make all pages landscape
pdflscape: use pdflscape package instead of lscape package. The result is to rotate landscape pages on the screen.

This includes my standard latex options. Need to modify the file to add any others.

Written by Gabriel Chodorow-Reich and provided without any warranty
This version: August 2014
*************************************************************************************************************/

capture program drop EmbedTex
program define EmbedTex
version 12.1
syntax anything(name=infilename) using/, [title(string)] [author(string)] [landscape pdflscape thousands append replace]
#delimit;

tokenize `infilename'; /*Creates macros 1,2,.etc containing words of infilename, with last macro set to missing*/
while `"`1'"'!="" {;
	if !regexm(`"`1'"',`"^\\"') {;
		local inputs `"`inputs' `"\input{`1'}"' _n"';
	};
	else {;
		local inputs `"`inputs' `"`1'"' _n"';
	};
	macro shift; /*Discards 1 and changes macro 2 to 1, etc*/
};

if "`landscape'"=="landscape" {;
	local input `" "\begin{landscape}" _n `inputs' "\end{landscape}" _n(2) "';
};
else {;
	local input `" `inputs' _n "';
};
local lscape_package = substr(`"`pdflscape'"',1,3) + `"lscape"';	


if "`append'"=="append" {;
	local using2 = subinstr(`"`using'"',`"/"',`"\"',.);
	!type "`using2'" | findstr /v "\end{document}" >temp.tex; *Command line instruction. If system is incompatible, append will not work;
	copy temp.tex "`using'", replace;
	erase temp.tex;
	file open outfile using `"`using'"', write append;
	file write outfile `input' "\end{document}";
	file close outfile;
};
	
else {;	

	if `"`thousands'"'==`"thousands"' {;
		local group_digits group-digits;
		local group_separator group-separator;
	};
	else {;
		local group_digits %group-digits;
		local group_separator %group-separator;
	};
	
	file open outfile using `"`using'"', write `replace';
	file write outfile 
	"\documentclass[12pt] {article}" _n
	"\usepackage{booktabs}" _n
	"\usepackage{fullpage}" _n
	"\usepackage{tabularx}" _n
	"\renewcommand{\tabularxcolumn}[1]{>{\centering\arraybackslash}m{#1}}" _n
	"\newcolumntype{L}{>{\centering}X}" _n
	"\usepackage{`lscape_package'}" _n
	"\usepackage{longtable}" _n
	"\usepackage{dcolumn}" _n
	"\usepackage{amssymb}" _n
	"\usepackage{amsfonts}" _n
	"\usepackage{amsmath}" _n
	"\usepackage{graphicx}" _n
	"\usepackage[dvipsnames,table]{xcolor}" _n
	"\definecolor{light-gray}{gray}{0.90}" _n	
	"\usepackage{epsfig}" _n
	"\usepackage{epstopdf}" _n
	"\usepackage{hyperref}" _n
	"\usepackage{refstyle}" _n
	"\usepackage[noabbrev]{cleveref}" _n
	"\usepackage{siunitx}" _n
	"\sisetup{ detect-mode, " _n
	"          group-digits            = false ," _n
	"          input-signs             = ," _n
	"          input-symbols           = ()[]-+* ," _n
	"          input-open-uncertainty  = ," _n
	"          input-close-uncertainty = ," _n
	"          table-align-text-post   = false," _n
	"          table-number-alignment  = center," _n
	"          `group_digits'            = integer," _n
	"          `group_separator'         = {,}" _n
	"        }" _n(2)

	"\title{`title'}" _n
	"\author{`author'}" _n
	"\topmargin=6pt" _n
	"\setlength{\footskip}{15pt}" _n
	"\begin{document}" _n
	"\maketitle" _n(2)

	`input'

	"\end{document}"
	;
	file close outfile;
}; 

end;

