clear
set more off
#delimit;
tempfile data;
local datasetname CUSIPM;

/*************************************************************************************************************
This do-file loads data from CUSIP via PC-SAS. The file writes a SAS file and then executes it.

SAS programming notes
*libname defines the path where the dataset will be saved.
*The line letwrds = ... initiates a login to a remote session.
*rsubmit is a remote submit command to the WRDS server. The inheritlib option puts the local work folder into the remote server with 
 the name pcwork. Otherwise folders in the remote server are unavailable once the remote session has ended.

*************************************************************************************************************/
local j = 1;
local symbol_list `"`" '912795','912796','912810','912827','912828' "'"';
local datasets `"`"`datasetname'.issue"'"';

#delimit cr
file open sassteps using SAS_PC_`datasetname'.sas, write replace
file write sassteps ///
`"libname raw '$DataPath\sas7bdat';"' _n ///
`"%let wrds = wrds.wharton.upenn.edu 4016;options comamid = TCP remote=WRDS;signon username=_prompt_;"' _n ///
`"rsubmit inheritlib=(work=pcwork);"' _n ///
`"data pcwork.`datasetname';"' _n ///
`"set"' _n ///
`datasets' `";"' _n ///
`"where issuer_num in ("' _n ///
`symbol_list' ///
`")"' _n /// 
`";"' _n ///
`"run;"' _n `"endrsubmit;"' _n `"run;"' _n ///
`"data raw.`datasetname'_UST;"' _n `"set work.`datasetname';"' _n ///
`"run;"' 
file close sassteps
#delimit;

*Run the .sas file and load the .dta dataset. Need to point to SAS executable location;
!"C:\Program Files\SASHome\SASFoundation\9.3\sas.exe" SAS_PC_`datasetname';


