clear
set more off
#delimit;
tempfile data;
local datasetname COMPM;

/*************************************************************************************************************
This do-file loads data from the WRDS Compustat database via PC-SAS. The file writes a SAS file and then executes it.

SAS programming notes
*libname defines the path where the dataset will be saved.
*The line letwrds = ... initiates a login to a remote session.
*rsubmit is a remote submit command to the WRDS server. The inheritlib option puts the local work folder into the remote server with 
 the name pcwork. Otherwise folders in the remote server are unavailable once the remote session has ended.
*Obtaining the full trading day for each BHC would result in too large a data set. Instead, this file specifies a separate
 intraday window for each announcement date. It has SAS append the dates together.

*************************************************************************************************************/

capture erase SAS_PC_`datasetname'.sas;
capture erase "$DataPath/sas7bdat/`datasetname'.sas7bdat";

local dataset `"`datasetname'.spidx_cst"';

#delimit cr
file open sassteps using SAS_PC_`datasetname'.sas, write replace
file write sassteps ///
`"libname raw '$DataPath\sas7bdat';"' _n ///
`"%let wrds = wrds.wharton.upenn.edu 4016;options comamid = TCP remote=WRDS;signon username=_prompt_;"' _n ///
`"rsubmit inheritlib=(work=pcwork);"' _n ///
`"data pcwork.`datasetname';"' _n ///
`"set `dataset';"' _n ///
`"where datadate>'1jan2008'd"' _n ///
`"and indexid in ("500");"' _n ///
`"run;"' _n `"endrsubmit;"' _n `"run;"' _n ///
`"data raw.`datasetname'_SP500CONSTITUENTS;"' _n `"set work.`datasetname';"' _n ///
`"run;"' 
file close sassteps
#delimit;

*Run the .sas file and load the .dta dataset. Need to point to SAS executable location;
!"C:\Program Files\SASHome\SASFoundation\9.3\sas.exe" SAS_PC_`datasetname';


