clear
set more off
#delimit;

/*************************************************************************************************************
This do-file sets up a spreadsheet to load CDX prices from Bloomberg, then reads them into stata. 

1. Outsheet to Bloomberg 
2. Insheet from Bloomberg
*************************************************************************************************************/
do paths;

/*************************************************************************************************************
1. Outsheet list of tickers
*************************************************************************************************************/
local sources `"CBGN CBGL CBGT"';

capture qui erase "$ExcelPath/CDX-empty.xlsx";
foreach rating in IG HY {;
	forvalues s = 1/21 {;
		foreach source of local sources {;
			clear;
			qui set obs 3;
			qui gen index = "CDX `rating' CDSI S`s' 5Y `source' Corp" in 1;
			qui replace index = "Date" in 2;
			foreach var in PX_OPEN PX_LOW PX_HIGH PX_LAST {;
				qui gen `var' = "`var'" in 2; 
			};
			
			#delimit cr
			qui replace index = `"=BDH(A1,B2:E2,"1/1/2003","","Dir=V","DTS=S","Sort=A","Quote=C","QtTyp=P","Days=T","Per=cd","DtFmt=D","UseDPDF=Y","cols=5;rows=2400")"' in 3
			#delimit;
			qui export excel using "$ExcelPath/CDX-empty.xlsx", sheet("CDX `rating' CDSI S`s' 5Y `source' Corp") sheetreplace;
		};
	};
};

/*************************************************************************************************************
2. CDS data
*************************************************************************************************************/
tempfile CDX;
foreach rating in IG HY {;
	forvalues s = 1/21 {;
		foreach source of local sources {;
			qui import excel using "$ExcelPath/CDX-Bloomberg.xlsx", sheet("CDX `rating' CDSI S`s' 5Y `source' Corp") clear;
			qui gen CDX_code = A[1];
			qui gen CDX_code_short = "`rating'_S`s'_`source'";
			qui replace CDX_code_short = subinstr(CDX_code_short,"-","_",.);
			qui gen rating = "`rating'";
			qui gen series = `s';
			qui gen source = "`source'";
			foreach var in A B C D E {;
				local varname = `var'[2];
				rename `var' `varname';
			};
			qui drop in 1/2;
			capture qui append using `CDX';
			qui save `CDX', replace;
		};
	};
};
qui gen date = date(Date,"MDY");
qui format date %td;
qui drop Date;
qui destring PX*, replace ignore(#N/A);

qui encode CDX_code, gen(id);
qui tsset id date;

qui save "$SavePath/CDX-Bloomberg", replace;




