/*************************************************************************************************************
This ado-file sets up a spreadsheet to load CDS prices from Bloomberg, then reads them into stata. 

1. Outsheet to Bloomberg 
2. Insheet from Bloomberg
*************************************************************************************************************/

capture program drop CDSIntradayBloomberg
program define CDSIntradayBloomberg
version 12.1
syntax name(name=sector id="Sector LI or BHC")

clear
set more off
#delimit;
tempfile data;
do paths;
local measure CDS;

/*************************************************************************************************************
1. Outsheet list of tickers
*************************************************************************************************************/
capture qui erase "$ExcelPath/`measure'Intraday_`sector'-empty.xlsx";

if regexm(`"`sector'"',`"LI"') {;
	local tickers `"MET PRU ALL LNC HIG AFL"';
};
else if regexm(`"`sector'"',`"BHC"') {;
	qui unzipfile "$DropboxPath/BPEA 2014/data/CRSPQ_BHC_stocknames", replace;
	qui use crspq_bhc_stocknames;
	erase crspq_bhc_stocknames.dta;
	qui drop if missing(ticker) | nameenddt<td(1jan2008);
	qui levelsof ticker, local(tickers);
};

local date0 = td($S_DATE) - dofm(6);
local date0string = string(`date0',`"%tdnn/dd/CCYY"');
foreach ticker of local tickers {;
	clear;
	qui set obs 4;
	qui gen index = "`ticker' CDS USD SR 5Y Corp" in 1;
	qui replace index = "BarTp=T" in 2;
	qui replace index = "Date" in 3;
	foreach var in LAST_PRICE {;
		qui gen `var' = "`var'" in 3; 
	};
	
	#delimit cr
	qui replace index = `"=BDH(A1,B3:B3,"`date0string' 12:00:00 AM","","Dir=V","BarSz=1","DTS=S","Sort=A","Quote=C","UseDPDF=Y","cols=2;rows=10000")"' in 4
	#delimit;
	qui export excel using "$ExcelPath/`measure'Intraday_`sector'-empty.xlsx", sheet("`ticker' CDS USD SR 5Y Corp") sheetreplace;
};

/*************************************************************************************************************
2. Insheet
Note: There is a problem converting excel datetimes to stata datetimes. See datetime-example.do. I can get around
it by ensuring the dates are imported in numeric rather than string format. Importing in numeric keeps the seconds
component of the excel date. I can then change times with 0:59.999 to the next minute.
*************************************************************************************************************/
tempfile `measure';
foreach ticker of local tickers {;

	qui import excel using "$ExcelPath/`measure'Intraday_`sector'-Bloomberg.xlsx", sheet("`ticker' CDS USD SR 5Y Corp") clear;
	local `measure'_code = A[1];
	local rowmax = _N;
	if `rowmax' <5 {;
		continue;
	};
	qui import excel using "$ExcelPath/`measure'Intraday_`sector'-Bloomberg.xlsx", sheet("`ticker' CDS USD SR 5Y Corp") cellrange(A3:B`rowmax') firstrow clear;
	
	qui gen `measure'_code = `"``measure'_code'"';
	qui gen ticker = `"`ticker'"';
	
	if `"`first'"'==`""' {;
		local first no;
	};		
	else {;
		qui append using ``measure'';
	};
	qui save ``measure'', replace;
};

qui use ``measure'', clear;
qui gen double datetime = round(Date);
qui format datetime %tcddmonCCYY_HH:MM:SS;
qui format date %tcddmonCCYY_HH:MM;
rename Date ExcelDate;
qui drop if missing(datetime);
qui destring LAST_PRICE, replace ignore(#N/A);

qui encode `measure'_code, gen(id);
qui tsset id datetime, delta(1 minute);

qui save "$SavePath/`measure'Intraday_`sector'-Bloomberg", replace;



end;




