/*************************************************************************************************************
This ado-file zips files.

Required:
File path: file paths of files to be zipped.
Saving: Path of folder to contain zipped files.

Options:
Replace: replace existing zipped path. May specify replace either inside or outside the saving option.
zipexecutable: location of 7za executable file
mac: For use on OSX. Requires installation of brew and p7za in Terminal. Tested on OSX 10.9.

Written by Gabriel Chodorow-Reich and provided without any warranty
This version: August 2014
*************************************************************************************************************/

capture program drop gzipfile
program define gzipfile
syntax anything(name=filenames id="File path"), SAVing(string asis) [replace] [ZIPEXEcutable(string)] [mac]

local dir "`c(pwd)'"
if `"`zipexecutable'"' != `""' {
	local ZipExe `"`zipexecutable'"'
}
else {
	local ZipExe `"`=regexr(`"`=c(pwd)'"',`"Dropbox.*$"',`"Dropbox"')'\7-Zip"'
}

tokenize `"`filenames'"'
forvalues i = 1/`:word count `filenames'' {
	if regexm(`"``i''"',`"^([aA-zZ]:)|(/)"') {
		local infilenames `"`infilenames' "``i''""'
	}
	else {
		local infilenames `"`infilenames' "`dir'/``i''" "'
	}
} 

if regexm(`"`saving'"',`",( )?(replace)$"') {
	local replace replace
	local saving = regexr(`"`saving'"',`",( )?(replace)$"',`""') 
}
capture qui di `saving'
if _rc==0 {
	local saving = `saving'
}

if regexm(`"`saving'"',`"\."') {
	local extension = regexr(`"`saving'"',`"^.*\."',`""')
}
else {
	local extension 7z
}

if `"`replace'"'==`"replace"' {
	local overwrite `"-y"'
}

if `"`mac'"'==`"mac"' {
	di `"shell 7za a  `overwrite'  -o "`outfile'" "`infile'""'
	shell 7za a `overwrite' -o "`outfile'" "`infile'"
}
else {
	di `"!cd "`ZipExe'" & 7za a -t`extension' `overwrite' "`saving'" `infilenames' "'
	!cd "`ZipExe'" & 7za a -t`extension' `overwrite' "`saving'" `infilenames' 
}

end

