/*************************************************************************************************************
This ado-file unzips files.

Required:
File path: file paths of folder to be unzipped.

Options:
Replace: replace existing files. 
Outfolder: specify folder to unzip files into.
zipexecutable: location of 7za executable file
mac: for use on OSX. Requires installation of unar command line. Tested on OSX 10.9.

Written by Gabriel Chodorow-Reich and provided without any warranty
This version: August 2014
*************************************************************************************************************/

capture program drop gunzipfile
program define gunzipfile
syntax anything(name=infilename id="File path"), [outfolder(string)] [replace] [ZIPEXEcutable(string)] [mac]


local dir "`c(pwd)'"
if `"`zipexecutable'"' != `""' {
	local ZipExe `"`zipexecutable'"'
}
else {
	local ZipExe `"`=regexr(`"`=c(pwd)'"',`"Dropbox.*$"',`"Dropbox"')'\7-Zip"'
}


local s out
if `"``s'folder'"'==`""' {
	local `s'file `"`dir'"'
}
else if regexm(`"``s'folder'"',`"([aA-zZ]:)|(/)"') {
	local `s'file `"``s'folder'"'
}
else {
	local `s'file `"`dir'/``s'folder'"'
}
 
 
capture qui di `infilename'
if _rc==0 {
	local infilename = `infilename'
}
if !regexm(`"`infilename'"',`"^.*\."') {
	local infile = `"`infilename'"' + `".7z"'
}
else {
	local infile `"`infilename'"'
}
if !regexm(`"`infile'"',`"^([aA-zZ]:)|(/)"') {
	local infile `"`dir'/`infile'"'
}


if `"`replace'"'==`"replace"' {
	if `"`mac'"'==`"mac"' {
		local overwrite `"-f"'
	}
	else {
		local overwrite `"-y"'
	}
}

if `"`mac'"'==`"mac"' {
	di `"shell unar  `overwrite'  -o "`outfile'" "`infile'""'
	shell unar `overwrite' -o "`outfile'" "`infile'"
}
else {
	di `"!cd "`ZipExe'" & 7za x `overwrite' "`infile'" -o"`outfile'""'
	!cd "`ZipExe'" & 7za x `overwrite' "`infile'" -o"`outfile'"
}

end

