clear all
set more off
#delimit;
tempfile data;

/*************************************************************************************************************
This do-file calls various programs to load data from WRDS via PC-SAS.
*************************************************************************************************************/
do Paths;
do QE_dates;

global dates;
global datetimes;
forvalues q = 1/4 {;
	local i = 1;
	while `"${QE`q'_`i'}"'!=`""' {; 
		local date: word 1 of ${QE`q'_`i'};
		global dates `"$dates `date'"';
		local datetime = Clock(`"${QE`q'_`i'}"',`"DMYhms"');
		global datetimes `"$datetimes `datetime'"';
		local i = `i'+1;
	};
}; 

global LI_tickers `"MET PRU MFC AIG HIG AEG VOYA LNC AB PFG AMP AFL ALL SLF AZSEY GNW NYLI NWMA PALF NATB PUK MMLI TIAA"'; 
/*The following are not publicly-traded: TIAA-CREF, New York Life, Northwestern Mutual, Mass Mutual, Pacific Life, Nationwide, Jackson National, Thrivent, Statefarm. 
I can't find stock or bond tickers for Thrivent, Statefarm.
VOYA is ING following its IPO in 2013. AB is Alliance Bernstein, a subsidiary of AXA. AMP is Ameriprise, the parent of River Source.*/

global BHC_permcos;
qui insheet using http://www.newyorkfed.org/research/banking_research/data/crsp_20120930.csv, comma names double;
/*List of publicly-traded bank holding companies with RSSID linked to permco*/
keep if date(string(dt_end,`"%12.0f"'),`"YMD"')>=td(1jan2008);
forvalues n = 1/`=_N' {;
	global BHC_permcos `"$BHC_permcos `=permco[`n']'"';
};

/*************************************************************************************************************
1. Call programs that write and execute WRDS SAS PC connect files to load .sas7bdat datasets
*************************************************************************************************************/
*do TAQ_LI;
*do TAQ_BHC;
*do GovPX;
*do TRACE_LI; /*Note: the file doesn't run when called from stata but does run if I open and run in sas*/
*do TRACE_BHC; /*Note: the file doesn't run when called from stata but does run if I open and run in sas*/
*do Markit_LI;
*do Markit_BHC;
*do CRSPQ_LI_stocknames;
*do CRSPQ_LI_DSF;
*do CRSPQ_BHC_DSF; /*Note: the file doesn't run when called from stata but does run if I open and run in sas*/
*do CRSPQ_BHC_STOCKNAMES; /*Note: the file doesn't run when called from stata but does run if I open and run in sas*/
*do CRSPQ_UST_ISS;
*do CRSPQ_UST_DLY;
*do CUSIPM;
*do CUSIPM_UST;
*do COMPM_SP500CONSTITUENTS;
*do TAQ_SP500;
*do CRSPQ_SP500_STOCKNAMES;
*do CRSPQ_SP500_DSF;
/*************************************************************************************************************
2. Write a .sas file to convert datasets from SAS to stata
*************************************************************************************************************/
#delimit;
local datasets: dir `"$DataPath/sas7bdat"' files `"*.sas7bdat"';
#delimit cr
file open SASStata using SASStata.sas, write replace
file write SASStata `"libname raw '$DataPath/sas7bdat';"' _n
foreach dataset of local datasets {
	local name = regexr(`"`dataset'"',`"\.sas7bdat$"',`""')
	capture erase `"`name'.dta"'
	file write SASStata `"proc export data=raw.`name' outfile="`name'.dta";"' _n
}
file write SASStata `"run;"'
file close SASStata	
#delimit;

*Run the .sas file and load the .dta dataset. Need to point to SAS executable location;
!"C:\Program Files\SASHome\SASFoundation\9.3\sas.exe" SASStata;

foreach dataset of local datasets {;
	local name = regexr(`"`dataset'"',`"\.sas7bdat$"',`""');
	local shortname = regexr(`"`name'"',`"_.*$"',`""');
	zipfile `name'.dta, saving(`"$DataPath/`name'"', replace);
	erase `name'.dta;	erase `"$DataPath/sas7bdat/`dataset'"';
	erase SAS_PC_`shortname'.sas;
	copy SAS_PC_`shortname'.log `"$LogPath/SAS_PC_`name'.log"', replace;
	erase SAS_PC_`shortname'.log;
};
