clear all
set more off
#delimit;


/*************************************************************************************************************
This do-file makes figures of intraday Treasury yields on announcement dates.
*************************************************************************************************************/
do Paths;
local sectype 5;
local sectype_name Five;

/*Figures of yield to maturity time plot, 5 year note*/
qui use `"$DataPath/Treasuries-event-study-on-the-run"', replace;
eventtime datetime, lower(10) upper(20) band(0:04:59) gen(eventtime);
local tfmt `"%tCHH:MM"';
local filenames;
qui replace ytm = 100*ytm;
qui levelsof date, local(dates);
local j = 0; local k = 0; local l = 0;
foreach date of local dates {;
	local labsize medsmall;
	sum datetime if date==`date' & eventtime==0, meanonly;
	local eventtime = r(mean);
	local lower = `eventtime' - msofminutes(2);
	local upper = `eventtime' + msofminutes(18);
	local tvalues `"`=tC(`=string(`date',`"%td"')' 08:00)' (`=msofminutes(120)') `=tC(`=string(`date',`"%td"')' 17:00)'"';
	sum ytm if date==`date' & sectype==`sectype', meanonly;
	if r(max)-r(min)<0.4 {;
		local topyval = 0.1*ceil(10*r(mean))+0.2; 
	};
	else {;
		local topyval = 0.1*ceil(10*r(max));
	};
	local yvalues `"`=`topyval'-0.5' (0.1) `topyval'"';
	local legend off;
	twoway (tsline ytm if sectype==`sectype', lpattern(solid) lwidth(medthick) lcolor(blue)) if date==`date' & inrange(hhC(datetime),8,17), tline(`lower', lpattern(dash)) tline(`upper', lpattern(dash)) subtitle("Yield to maturity (percent)", position(11) span size(`labsize') color(black)) legend(`legend') scheme(s2mono) graphregion(color(white) margin(l=`l_m_p' r=`r_m_p')) plotregion(style(none) margin(zero)) ylabel(`yvalues',nogrid tposition(outside) angle(horizontal) labsize(`labsize')) ytitle("") ttitle("", size(`labsize')) tlabel(`tvalues',tposition(outside) labsize(`labsize') format(`tfmt')) ysize(3.5) xsize(6);
	local filename = `"`sectype_name'-year-yield-to-maturity-"' + string(`date',`"%td"');
	qui graph export `"$OutputPath/Yields to maturity/`filename'.pdf"', replace;
	local title = `"`sectype_name' year note yield to maturity, "' + string(`date',`"%tdMonth_dd,_CCYY"');
	local label `"`filename'"';
	TexFigure `"`filename'.pdf"' using `"$OutputPath/Yields to maturity/`filename'.tex"', headtitle(`title') label(`label') note(`fullnote') position(!t) replace;
	local filenames `"`filenames' `filename'.tex"';
	local j = `j'+1;
	if `j'>12 {;
		local filenames `"`filenames' \clearpage"';
		local j = 0;
	};
	
	/*Presentation figures*/
	if inlist(`date',`=dofC(tC(16dec2008 14:21:17))',`=dofC(tC(18mar2009 14:17:00))',`=dofC(tC(22may2013 10:30:30))',`=dofC(tC(19jun2013 14:00:00))',`=dofC(tC(10jul2013 16:45:00))',`=dofC(tC(18sep2013 14:00:00))') {;
		local labsize medlarge;
		twoway (tsline ytm if sectype==`sectype', lpattern(solid) lwidth(medthick) lcolor(blue)) if date==`date' & inrange(hhC(datetime),8,17), tline(`lower', lpattern(dash)) tline(`upper', lpattern(dash)) subtitle("Yield to maturity (percent)", position(11) span size(`labsize') color(black)) legend(`legend') scheme(s2mono) graphregion(color(white) margin(l=`l_m_p' r=`r_m_p')) plotregion(style(none) margin(zero)) ylabel(`yvalues',nogrid tposition(outside) angle(horizontal) labsize(`labsize')) ytitle("") ttitle("", size(`labsize')) tlabel(`tvalues',tposition(outside) labsize(`labsize') format(`tfmt')) ysize($ysize_p) xsize($xsize_p);
		local filename = `"`sectype_name'-year-yield-to-maturity-"' + string(`date',`"%td"');
		local title = `"`sectype_name' year note, "' + string(`date',`"%tdMonth_dd,_CCYY"');
		qui graph export `"$PresentationPath/`filename'.eps"', replace;
		TexFigure `"input-files/`filename'.eps"' using `"$PresentationPath/`filename'.tex"', headtitle(`title') label(`label') note() position(!t) replace;
		local labsize medsmall;
	};
	
	/*Figures combined*/
	if inlist(`date',`=dofC(tC(25nov2008 8:15:00))',`=dofC(tC(12aug2009 14:16:10))',`=dofC(tC(4nov2009 14:19:00))',`=dofC(tC(27aug2010 10:00:00))',`=dofC(tC(3nov2010 14:16:00))',`=dofC(tC(31aug2012 10:00:00))',`=dofC(tC(12dec2012 12:30:02))') {; 
		continue;
	};
	else {;
		local k = `k'+1;
		local title = string(`date',`"%tdMonth_dd,_CCYY"');
		local labsize small;
		twoway (tsline ytm if sectype==`sectype', lpattern(solid) lwidth(medthick) lcolor(blue)) if date==`date' & inrange(hhC(datetime),8,17), tline(`lower', lpattern(dash)) tline(`upper', lpattern(dash)) title("`title'", position(12) span size(`labsize') color(black)) legend(`legend') scheme(s2mono) graphregion(color(white) margin(l=`l_m_p' r=`r_m_p')) plotregion(style(none) margin(zero)) ylabel(`yvalues',nogrid tposition(outside) angle(horizontal) labsize(`labsize')) ytitle("") ttitle("", size(`labsize')) tlabel(`tvalues',tposition(outside) labsize(`labsize') format(`tfmt')) name(_`k');
		local graphs `"`graphs' _`k'"';	
		if `k'==8 | `date'==td(18sep2013) {;
			local l = `l' + 1; 
			qui graph combine `graphs', cols(2) scheme(s2mono) graphregion(color(white)) plotregion(style(none) margin(zero)) ysize(`k') xsize(6.5);
			local filename `sectype_name'-year-yield-to-maturity-`l';
			local title `"`sectype_name' year note yield to maturity, percent"';
			if `l'>1 {;
				local title `"`title' (continued)"';
			};
			local label `"`filename'"';
			qui graph export `"$PaperPath/`filename'.eps"', replace;
			TexFigure `"input-files/`filename'.eps"' using `"$PaperPath/`filename'.tex"', headtitle(`title') label(fig:`label') note(`fullnote') position(!t) replace;
			qui graph drop _all;
			local k = 0; local graphs;
		};
	};
};
EmbedTex `"`filenames'"' using `"$OutputPath/Yields to maturity/`sectype_name' year note.tex"', title(Yields to maturity) author(Gabriel Chodorow-Reich) replace;
x;

/*Figures of change in yield to maturity*/
#delimit;
local labsize medsmall;
qui use `"$DataPath/Treasuries-event-study-on-the-run"', replace;
eventtime datetime, lower(10) upper(20) band(0:04:59) gen(eventtime);
qui keep if inlist(eventtime,-1,1);
qui egen double maxtime = max(datetime), by(eventtime date);
qui egen double mintime = min(datetime), by(eventtime date);
qui replace datetime = cond(eventtime==-1,maxtime,mintime);
qui collapse (mean) ytm Macaulay, by(eventtime datetime date cusip);
qui replace ytm = 100*ytm;
qui levelsof date, local(dates);
foreach date of local dates {;
	forvalues j = -1(2)1 {;
		sum datetime if date==`date' & eventtime==`j', meanonly;
		local legend`=regexr(`"`j'"',`"-"',`"_"')' = string(r(max),`"%tChh:MMam"');
	};
	local legend `"on row(2) rowgap(0) size(`labsize') position(11) region(lcolor(white)) ring(0) label(1 `"`legend_1'"') label(2 `"`legend1'"')"';
	twoway (scatter ytm Macaulay if eventtime==-1, msymbol(circle) msize(small) mcolor(red)) (scatter ytm Macaulay if eventtime==1, msymbol(circle) msize(small) mcolor(blue)) if date==`date', subtitle("Yield to maturity (percent)", position(11) span size(`labsize') color(black)) legend(`legend') scheme(s2mono) graphregion(color(white) margin(l=`l_m_p' r=`r_m_p')) plotregion(style(none) margin(zero)) ylabel(,nogrid tposition(outside) angle(horizontal) labsize(`labsize')) ytitle("") xtitle("Macaulay duration (years)", size(`labsize')) xlabel(,tposition(outside) labsize(`labsize')) ysize(3.5) xsize(6);
	local filename = `"Yields-to-maturity-"' + string(`date',`"%td"');
	qui graph export `"$OutputPath/Yields to maturity/`filename'.pdf"', replace;
	local title = `"Yields to maturity, "' + string(`date',`"%tdMonth_dd,_CCYY"');
	local label `"`filename'"';
	TexFigure `"`filename'.pdf"' using `"$OutputPath/Yields to maturity/`filename'.tex"', headtitle(`title') label(`label') note(`fullnote') position(!t) replace;
	local filenames `"`filenames' `filename'.tex"';
};
EmbedTex `"`filenames'"' using `"$OutputPath/Yields to maturity/Yields to maturity.tex"', title(Yields to maturity) author(Gabriel Chodorow-Reich) replace;


