/*************************************************************************************************************
Program to insert a figure into a tex document.

Required: 
Name of figure file (must specify path if in a different location from output file and extension, either .pdf or .eps).
Name of output file.

Options:
headtitle
foottitle
note
label
position (default is top of page)
replace

Written by Gabriel Chodorow-Reich and provided without any warranty
This version: August 2014
*************************************************************************************************************/

capture program drop TexFigure
program define TexFigure
version 12.1
syntax anything(name=infilename) using/, [headtitle(string) foottitle(string) note(string) label(string) position(string) replace]
#delimit;
local infilename `infilename';
/*Options*/
if `"`position'"'==`""' {;
	local position `"!t"';
}; 

if `"`headtitle'"'!=`""' {;
	local prefigure `"`"\caption{`headtitle'}"' _n"';
};	
if `"`foottitle'"'!=`""' {;
	local postfigure `"`"\caption{`foottitle'}"' _n"';
};
if `"`label'"'!=`""' {;
	local postfigure `" `postfigure' `"\label{`label'}"' _n"';
};
if `"`note'"'!=`""' {;
	local postfigure `"`postfigure' `"\begin{minipage}{\hsize} \rule{0pt}{9pt}"' _n `"\footnotesize"' _n `"\vspace{-.15cm}"' _n(2) `"\noindent"' _n"'; 
	local postfigure `"`postfigure' `"`note'"' _n"';
	local postfigure `"`postfigure' `"\end{minipage}"' _n"';
};

if `"`replace'"'==`"replace"' {;
	file open outfile using `"`using'"', write replace;
};
else {;
	file open outfile using `"`using'"', write;
};

file write outfile
`"\begin{figure}[`position']"' _n
`prefigure'
`"\centerline{\includegraphics{`infilename'}}"' _n
`postfigure'
`"\end{figure}"'
;
file close outfile;

end;

