clear
set more off
#delimit;
tempfile data;
local datasetname TAQ;

/*************************************************************************************************************
This do-file loads data from the WRDS TAQ database via PC-SAS. TAQ contains intraday price and volume for stocks
listed on the NYSE. The file writes a SAS file and then executes it.

SAS programming notes
*libname defines the path where the dataset will be saved.
*The line letwrds = ... initiates a login to a remote session.
*rsubmit is a remote submit command to the WRDS server. The inheritlib option puts the local work folder into the remote server with 
 the name pcwork. Otherwise folders in the remote server are unavailable once the remote session has ended.

*************************************************************************************************************/
foreach ticker of global LI_tickers {;
	local symbol_list `"`symbol_list'"`ticker'","';
};
local symbol_list = regexr(`"`symbol_list'"',`",$"',`""');

foreach date of global dates {;
	foreach unit in year month day {;
		local `unit' = `unit'(td(`date'));
		if ``unit''<10 {; /*Requires two digit month and day*/
			local `unit' 0``unit'';
		};
	};
	local datasets `" `datasets' `"`datasetname'.ct_`year'`month'`day'"' _n "';
};

#delimit cr
file open sassteps using SAS_PC_`datasetname'.sas, write replace
file write sassteps ///
`"libname raw '$DataPath\sas7bdat';"' _n ///
`"%let wrds = wrds.wharton.upenn.edu 4016;options comamid = TCP remote=WRDS;signon username=_prompt_;"' _n ///
`"rsubmit inheritlib=(work=pcwork);"' _n ///
`"data pcwork.`datasetname';"' _n ///
`"set"' _n ///
`datasets' `";"' _n ///
`"by symbol date time;"' _n ///
`"where SYMBOL in (`symbol_list') and time >= '07:30:00't and time <='18:00:00't;"' _n ///
`"run;"' _n `"endrsubmit;"' _n `"run;"' _n ///
`"data raw.`datasetname'_LI;"' _n `"set work.`datasetname';"' _n ///
`"run;"' 
file close sassteps
#delimit;

*Run the .sas file and load the .dta dataset. Need to point to SAS executable location;
!"C:\Program Files\SASHome\SASFoundation\9.3\sas.exe" SAS_PC_`datasetname';


