clear all
set more off
#delimit;
tempfile data;

/*************************************************************************************************************
This do-file makes a table of the QE dates.
*************************************************************************************************************/
do Paths;
do QE_dates;

/*Create data set of dates and event*/
qui gen datestring = "";
qui gen event = "";
qui gen date = .;
qui gen time = .;
qui gen episode = "";
forvalues q = 1/4 {;
	local i = 1;
	while `"${QE`q'_`i'}"'!=`""' {; 
		if inlist(`"${QE`q'_`i'}"',`"25nov2008 8:15:00"',`"12aug2009 14:16:10"',`"4nov2009 14:19:00"',`"27aug2010 10:00:00"',`"3nov2010 14:16:39"',`"31aug2012 10:00:00"',`"12dec2012 12:30:02"',`"18dec2013 14:00:00"') {; 
			local i = `i'+1;
			continue; /*Dates without any "action" in the Treasury market*/
		};
		else {;
			qui set obs `=`=_N' + 1';
			local date: word 1 of ${QE`q'_`i'};
			local time: word 2 of ${QE`q'_`i'};
			qui replace date = td(`date') in `=_N';
			qui replace time = tC(`time') in `=_N';
			qui replace event = regexr(`"${QE`q'_`i'event}"',`",.*$"',`""') in `=_N';
			qui replace episode = `"QE`q'"' in `=_N';
			local i = `i'+1;
		};
	};
};
qui format date %td;
qui format time %tChh:MMam;

/*Merge daily rates*/
preserve;
local irates `"DGS2 DGS5 DGS10"';
qui freduse `irates', clear;
qui drop date;
rename daten date;
foreach var of local irates {;
	qui gen d`var' = 100*(`var' - `var'[_n-1]);
	local dirates `"`dirates' d`var'"';
};
qui format dD* %9.0f;
qui save `data';
restore;
merge 1:1 date using `data', keep(master matched) keepusing(`irates' `dirates') nogenerate;

/*Merge intraday rates*/
preserve;
local lower 2;
local upper 18;
local sectype 5;
qui use `"$DataPath/Treasuries-event-study-on-the-run"' if sectype==`sectype' & !missing(datetime), replace;
eventtime datetime, lower(`lower') upper(`upper') band(0:04:59) gen(eventtime);
qui drop if missing(eventtime);
qui collapse (mean)  ytm, by(date eventtime);
qui tsset date eventtime, delta(1);
foreach var of varlist ytm {;
	qui gen D`var' = S2.`var';
};
qui keep if eventtime == 1;
qui gen DytmBP = 10^4 * Dytm; /*Converts units to basis points*/
qui save `data', replace;
restore; 
merge 1:1 date using `data', keep(master matched) keepusing(DytmBP) nogenerate;

qui sort date;
qui replace datestring = string(date,`"%tdMonth"') + " " + string(date,`"%tddd"') + ", " + string(date,`"%tdCCYY"');
qui gen timestring = string(time,`"%tChh:MMam"');
qui replace episode = "FG" if episode=="QE4";
list;

foreach var of varlist episode datestring timestring event {;
	qui gen `var'_string = `"\multicolumn{1}{l}{"' + `var' + `"}"' + `"\hspace{0.2cm}"';
	local vars_string `"`vars_string' `var'_string"';
};
qui gen Dytm_string = string(round(DytmBP,0.1));
	
local filename QE-dates;
local title `"Unconventional monetary policy announcement dates"';
local headlines1 `""\multicolumn{1}{l}{Episode}&\multicolumn{1}{l}{Date}& \multicolumn{1}{l}{Time}& \multicolumn{1}{l}{Event}& \multicolumn{1}{c}{Effect on 5yr Treasury note$^{\text{a}}$}\\""';
local headlines2 `""&&&& \multicolumn{1}{c}{(Basis points)}\\""';
local si_fmt `"2.2"';
local notes `"a. Change in the yield to maturity of the on-the-run five year Treasury note from the 5 minute window ending 2 minutes before the announcement to the 5 minute window beginning 18 minutes after the announcement. The yield to maturity is based on the mean of the indicative bid and ask prices in each window."';
local ncol 5;
listtex `vars_string' Dytm_string using `"$PaperPath/`filename'.tex"', 
replace rstyle(tabular) headline("\begin{table}[htb]\centering" "\def\sym#1{\ifmmode^{#1}\else\(^{#1}\)\fi}" "\sisetup{table-format=`si_fmt'}" "\caption{`title'}" "\begin{tabularx}{\textwidth}{*{4}{l}S}" "\\" "\hline \hline" `headlines1' `headlines2' "\hline") footline("\hline \hline" "\multicolumn{`ncol'}{l}{" "\begin{minipage}{\hsize}" "\rule{0pt}{9pt}" "\footnotesize" "\noindent" "`notes'"  "\end{minipage}" "}\\" "\end{tabularx}" "\label{tab:`filename'}" "\end{table}"); 

/*Presentation table*/
local notes;
local title `"Announcement dates"';
local headlines1 `""\multicolumn{1}{l}{Episode}&\multicolumn{1}{l}{Date}& \multicolumn{1}{l}{Time}& \multicolumn{1}{l}{Event}\\""';
local headlines2;
local ncol 4;
listtex `vars_string' using `"$PresentationPath/`filename'.tex"', 
replace rstyle(tabular) headline("\begin{table}[htb]\centering" "\def\sym#1{\ifmmode^{#1}\else\(^{#1}\)\fi}" "\sisetup{table-format=`si_fmt'}" "\caption{`title'}" "\begin{tabularx}{\textwidth}{*{4}{l} }"      "\hline \hline" `headlines1' `headlines2' "\hline") footline("\hline \hline" "\multicolumn{`ncol'}{l}{" "\begin{minipage}{\hsize}" "\rule{0pt}{9pt}" "\footnotesize" "\noindent" "`notes'"  "\end{minipage}" "}\\" "\end{tabularx}" "\label{tab:`filename'}" "\end{table}"); 
