clear all
set more off
#delimit;

/*************************************************************************************************************
This do-file calls all of the programs used in 
Chodorow-Reich, Gabriel, "Effects of Unconventional Policy on Financial Institutions," Brookings Papers on Economic Activity, Fall 2014.
*************************************************************************************************************/

/*************************************************************************************************************
Preliminaries
*************************************************************************************************************/
do Treasuries-event-study-on-the-run;
/*Constructs data set of on-the-run Treasuries with minute-by-minute yields*/
/*Calls Treasuries-load-data.do: loads data from GovPX and CRSPQ_UST_ISS*/
	/*Calls coupondate.ado: marks coupon dates*/
/*Calls ytm.ado: computes yield to maturity using prices*/
/*Calls Macaulay.ado: computes Macaulay duration*/

do 5500-clean;
/*Loads 5500-merged.dta*/

/*************************************************************************************************************
Table 1
*************************************************************************************************************/
do QE-dates-table;
/*Loads Treasuries-event-study-on-the-run.dta*/
/*Calls QE-dates.do: defines QE dates and announcement times*/

/*************************************************************************************************************
Tables 2 and 3
*************************************************************************************************************/
do event-studies;
/*Calls EventStudyCDS.ado: see below*/
/*Calls EventStudyBond.ado: see below*/
/*Calls EventStudyStock.ado: see below*/
/*Calls EventStudyStock SP500*/
	/*Loads taq_SP500_1*/
	/*Loads taq_SP500_2*/
	/*Loads taq_LI.dta*/
	/*Loads taq_BHC.dta*/
	/*Loads COMPM_SP500CONSTITUENTS.dta*/
	/*Loads Treasuries-event-study-on-the-run.dta*/
	/*Loads crspq_SP500_dsf.dta*/
	/*Loads crspq_SP500_stocknames.dta*/
	/*Calls QE-dates.do: defines QE dates and announcement times*/
	/*Calls eventtime.ado: translates clock time into event time*/
/*Calls EventStudyCDX*/
	/*Loads CDX-Bloomberg.dta*/
	/*Loads Treasuries-event-study-on-the-run.dta*/
	/*Calls QE-dates.do: defines QE dates and announcement times*/
	/*Calls eventtime.ado: translates clock time into event time*/
	
/*************************************************************************************************************
Table 4
*************************************************************************************************************/
do betas-intraday.do;
/*Calls EventStudyStock.ado*/
/*Loads SP500-by-minute-tickdata.dta: S&P 500 from tickdata.com*/

/*************************************************************************************************************
Table 5 and Figure 10
*************************************************************************************************************/
do MMF-analyzer-analysis-annual.do;
/*Calls MMF-analyzer-clean.do*/
	/*Loads MMF-analyzer-data.dta: data from iMoneyNet*/
	
/*************************************************************************************************************
Table 6 and Figures 11-13
*************************************************************************************************************/
do MMF-analyzer-analysis-weekly.do;
/*Calls MMF-analyzer-clean.do*/
	/*Loads MMF-analyzer-data.dta: data from iMoneyNet*/	
	
/*************************************************************************************************************
Tables 7 and 8
*************************************************************************************************************/	
do 5500-analysis_gcr.do;
/*Loads 5500-cleaned2004.dta*/
/*Loads 5500-cleaned2006.dta*/
	
/*************************************************************************************************************
Figures 2 and 3
*************************************************************************************************************/
EventStudyCDS LI, paperplot;
/*Loads markit_LI.dta*/
/*Loads CDS_LI-Bloomberg.dta*/
/*Loads Treasuries-event-study-on-the-run.dta*/
/*Loads crspq_LI_dsf.dta*/
/*Loads crspq_LI_stocknames.dta*/
/*Calls QE-dates.do: defines QE dates and announcement times*/
/*Calls eventtime.ado: translates clock time into event time*/

/*************************************************************************************************************
Figure 4
*************************************************************************************************************/
EventStudyBond LI, yield;
/*Loads trace_LI.dta*/
/*Loads cusipm_LI.dta*/
/*Loads Treasuries-event-study-on-the-run.dta*/
/*Loads crspq_LI_dsf.dta*/
/*Loads crspq_LI_stocknames.dta*/
/*Calls QE-dates.do: defines QE dates and announcement times*/
/*Calls eventtime.ado: translates clock time into event time*/

/*************************************************************************************************************
Figure 5
*************************************************************************************************************/
EventStudyStock LI;
/*Loads taq_LI.dta*/
/*Loads Treasuries-event-study-on-the-run.dta*/
/*Loads crspq_LI_dsf.dta*/
/*Loads crspq_LI_stocknames.dta*/
/*Calls QE-dates.do: defines QE dates and announcement times*/
/*Calls eventtime.ado: translates clock time into event time*/

/*************************************************************************************************************
Figures 6 and 7
*************************************************************************************************************/
EventStudyCDS BHC, paperplot;
/*Loads markit_BHC.dta*/
/*Loads CDS_BHC-Bloomberg.dta*/
/*Loads Treasuries-event-study-on-the-run.dta*/
/*Loads crspq_BHC_dsf.dta*/
/*Loads crspq_BHC_stocknames.dta*/
/*Calls QE-dates.do: defines QE dates and announcement times*/
/*Calls eventtime.ado: translates clock time into event time*/

/*************************************************************************************************************
Figure 8
*************************************************************************************************************/
EventStudyBond BHC, yield;
/*Loads trace_BHC.dta*/
/*Loads cusipm_BHC.dta*/
/*Loads Treasuries-event-study-on-the-run.dta*/
/*Loads crspq_BHC_dsf.dta*/
/*Loads crspq_BHC_stocknames.dta*/
/*Calls QE-dates.do: defines QE dates and announcement times*/
/*Calls eventtime.ado: translates clock time into event time*/

/*************************************************************************************************************
Figure 9
*************************************************************************************************************/
EventStudyStock BHC;
/*Loads taq_BHC.dta*/
/*Loads Treasuries-event-study-on-the-run.dta*/
/*Loads crspq_BHC_dsf.dta*/
/*Loads crspq_BHC_stocknames.dta*/
/*Calls QE-dates.do: defines QE dates and announcement times*/
/*Calls eventtime.ado: translates clock time into event time*/

/*************************************************************************************************************
Figure C.1
*************************************************************************************************************/
do Treasuries-on-the-run-intraday-figures;
/*Loads Treasuries-event-study-on-the-run.dta*/
/*Calls eventtime.ado: translates clock time into event time*/

/*************************************************************************************************************
Figure C.2
*************************************************************************************************************/
do MMF-analyzer-FFA-benchmark;
/*Loads MMF-analyzer-data.dta*/
/*Loads FoF.dta*/

	

