clear
set more off
#delimit;
tempfile data;
local datasetname GovPX;

/*************************************************************************************************************
This do-file loads data from the WRDS GovPX database via PC-SAS. GovPX contains intraday price and data for U.S.
Treasury bills, notes, and bonds. The file writes a SAS file and then executes it.

SAS programming notes
*libname defines the path where the dataset will be saved.
*The line letwrds = ... initiates a login to a remote session.
*rsubmit is a remote submit command to the WRDS server. The inheritlib option puts the local work folder into the remote server with 
 the name pcwork. Otherwise folders in the remote server are unavailable once the remote session has ended.

*************************************************************************************************************/
foreach yy in 08 09 10 11 12 13 {;
	local datasets `" `datasets' `"`datasetname'.TICKS`yy'"' _n "';
};
foreach date of global dates {;
	local date_list `"`date_list''`date''d,"';
};
local date_list = regexr(`"`date_list'"',`",$"',`""');

#delimit cr
file open sassteps using SAS_PC_`datasetname'.sas, write replace
file write sassteps ///
`"libname raw '$DataPath\sas7bdat';"' _n ///
`"%let wrds = wrds.wharton.upenn.edu 4016;options comamid = TCP remote=WRDS;signon username=_prompt_;"' _n ///
`"rsubmit inheritlib=(work=pcwork);"' _n ///
`"data pcwork.`datasetname';"' _n ///
`"set"' _n ///
`datasets' `";"' _n ///
`"by date;"' _n ///
`"where date in (`date_list') and time >= '07:30:00't and time <='19:00:00't;"' _n ///
`"run;"' _n `"endrsubmit;"' _n `"run;"' _n ///
`"data raw.`datasetname';"' _n `"set work.`datasetname';"' _n ///
`"run;"' 
file close sassteps
#delimit;

*Run the .sas file and load the .dta dataset. Need to point to SAS executable location;
!"C:\Program Files\SASHome\SASFoundation\9.3\sas.exe" SAS_PC_`datasetname';


