clear all
set more off
/*************************************************************************************************************
This do-file loads 5500 pension report data from DOL.
*************************************************************************************************************/
do Paths_MG
/*************************************************************************************************************
1. Load data
*************************************************************************************************************/
forvalues yyyy = 2004/2005 {
	local formlist F_5500 F_SCH_H F_SCH_D_Part1 F_SCH_D_Part2 F_SCH_I
	if `yyyy'>2008 {
		local formlist `" `formlist' F_SCH_MB F_SCH_SB"'
	}
	else if `yyyy'<2008 {
		local formlist `" `formlist' F_SCH_B"'
	}
	/* There are no MB/SB/B in 2008 */
	foreach form of local formlist{
		if `yyyy'>=2009 {
				qui copy http://askebsa.dol.gov/FOIA%20Files/`yyyy'/Latest/`form'_`yyyy'_Latest.zip `form'_`yyyy'_Latest.zip, replace
				qui unzipfile `form'_`yyyy'_Latest.zip, replace
				qui insheet using `form'_`yyyy'_Latest.csv, comma names double clear
				foreach ext in `".zip"' `".csv"' `"_layout.txt"' {
					erase `form'_`yyyy'_Latest`ext'
				}
			}
		else {
				qui copy http://askebsa.dol.gov/FOIA%20Files/`yyyy'/`form'_`yyyy'.zip `form'_`yyyy'.zip, replace
				qui unzipfile `form'_`yyyy'.zip, replace
				qui insheet using oracle/Directories/Foia/`form'_`yyyy'.csv, comma names double clear
				erase `form'_`yyyy'.zip
				foreach ext in `".csv"' `"_layout.txt"' {
					erase oracle/Directories/Foia/`form'_`yyyy'`ext'
				}
				local path `"oracle/Directories/Foia"'
				foreach folder in Foia Directories oracle {
					capture rmdir `path'
					local path = regexr(`"`path'"',`"/`folder'"',`""')
			
				}
			}
		qui save `form'_`yyyy', replace
		zipfile `form'_`yyyy'.dta, saving("$DataPath/5500s/`form'_`yyyy'", replace)
		erase `form'_`yyyy'.dta
	}
}

