clear all
set more off
set matsize 11000
set maxvar 11000
*mata: mata set matafavor speed
do Paths
local sector `"DB"'
local sector_name `"Defined benefit pension fund"'
local OUTPUT_PS ""


/****************************************************************************************************
This do-file analysis panel data of S500
 What is 9 for type_plan entity_ind. It is not written in reseach firl where limited to 1-4 Make sure type=9 does not involve double counting. What is defined ad DFE? 

Flow of Fund measure asset compositionin the following way: Example of mortgage: Assets in registered investment companies, plus a portion of Assets in common/collective trusts and Assets in master trusts, where the portion is estimated using DFE Table 2 and Table 12. Thefore ok at the aggregate level but does not work for us

Thinsgs  not really cleant: accounting for asset_t=asset_t+1+inconme

Information on funding_ratio measure. Enter the three segment rates used to calculate the funding target and target normal cost as provided under Code section 430(h)(2)(C) and ERISA section 303(h)(2)(C) and as published by the IRS, unless the plan sponsor has elected to use the full yield curve. If the sponsor has elected to use the full yield curve, check the N/A, full yield curve used box. 
NPV value measures future benefits with a certain interet rate (given in the form SB: Assumptions Used to Determine Funding Target and Target Normal Cost). There might be a reverse causality problem if we're not controlling for it. 

Clustering: clustering by ein assumes that year shock is homogenous across all pension funds, which pretty much means they have the same exposure to the market.  Ideally we would cluster from bins constructed by porftolio holding. Or we could cluster by bin for the funding measure? Otherwise fama mac beth with the fixed effect gives the CI -0.69 1.91 so we don't have enough  power to reject that it is zero.  
****************************************************************************************************/

cap program drop clean
program define clean
qui sum `1',d
qui replace `1'=r(p50)+5*(r(p75)-r(p25)) if `1'>=r(p50)+5*(r(p75)-r(p25))&`1'~=.
qui replace `1'=r(p50)-5*(r(p75)-r(p25)) if `1'<=r(p50)-5*(r(p75)-r(p25))&`1'~=.
end

cap log close
log using "$LogPath/5500-analysis_gcr.log", replace

/*
qui unzipfile "$DataPath/5500-cleaned2006", replace
qui unzipfile "$DataPath/5500-cleaned2004", replace
*/

/*****************************************************************************************************
3. Summary  Table
*****************************************************************************************************/
/* Load data */
qui use 5500-cleaned2006 if !flag_id_dfe & !flag_id_missing & !flag_id_truncated, clear
/*Drop plans that don't start on January 1*/
keep if month(sch_h_plan_year_begin_date)==1 & day(sch_h_plan_year_begin_date)==1
/*Drop plans where funding ratio is not given for first day of year*/
foreach pre in sb mb actrl {
	drop if (sch_h_plan_year!=`pre'_value_date) & !missing(`pre'_value_date)
}
/*Option to use alternative return measure that excludes other "other income"*/
if regexm(`"`OUTPUT_PS'"',`"-alt"') {
	qui replace return = return_alt
	qui replace sd_return = sd_return_alt
}
/*Rebalance panel*/
qui egen nyears = count(year), by(id)
qui sum nyears
drop if nyears<r(max)
/*Rescale return to be in percentage points*/
qui replace return=100*return	

/*Generate summary statistics*/
#delimit;
local vars `"return funding_ratio_yearly funding_expenses_yearly"';
local stats `"mean sd N"';
qui sum year;
local year_min = r(min);
local year_max = r(max);
foreach var of local vars {;
	clean `var';
	forvalues yyyy = `year_min'/`year_max' {;
		qui sum `var' if year==`yyyy';
		foreach stat of local stats {;
			local `var'`stat'`yyyy' = r(`stat');
		};
	};
};

/*Data set of summary statistics*/
clear;
foreach var of local vars {;
	foreach stat of local stats {;
		qui gen `var'`stat' = .;
	};
};
qui gen year = .;
forvalues yyyy = `year_min'/`year_max' {;
	qui set obs `=`=_N'+1';
	qui replace year = `yyyy' in `=_N';
	foreach var of local vars {;
		foreach stat of local stats {;
			if inlist(`"`var'"',`"return"') {;
				qui replace `var'`stat' = round(``var'`stat'`yyyy'',0.1) in `=_N';
			};
			else {;
				qui replace `var'`stat' = round(``var'`stat'`yyyy'',0.01) in `=_N';
			};
		};
	};
};
/*Merge return on S&P 500*/
preserve;
qui freduse SP500, clear;
qui keep if year(daten)<year(daten[_n+1]);
qui gen year = year(daten);
qui tsset year;
qui gen returnSP500 = round(100*(SP500/L.SP500 - 1),0.1);
tempfile SP500;
qui save `SP500';
restore;
merge 1:1 year using `SP500', nogenerate keep(matched) assert(matched using);
order year returnSP500;

/*Make table*/
local j = 1;
foreach heading in "Fund return" "Expenses/Assets" "Benefits NPV/Assets" {;
	local j = `j'+2;
	local header `"`header' & \multicolumn{2}{c}{`heading'}"';
	local midrules `"`midrules' \cmidrule(lr{.75em}){`j'-`=`j'+1'}"';
	foreach stat in Mean "St. dev." {;
		local table_stats `"`table_stats' & \multicolumn{1}{L}{`stat'}"';
	};
};
local table_vars `"year returnSP500 returnmean returnsd funding_expenses_yearlymean funding_expenses_yearlysd funding_ratio_yearlymean funding_ratio_yearlysd funding_expenses_yearlyN"';
local nvars: word count `table_vars';
local nstats 2;
local filename `sector'-summary-statistics`OUTPUT_PS';
local notes `"Notes: The table reports cross-sectional statistics, by year. Data for funding status in 2008 are not available from the Department of Labor."'; 
local title `"`sector_name' summary statistics"';
local headlines1 `""&\multicolumn{1}{L}{S\&P 500} `header' & \\ `midrules'" "';
local headlines2 `"" \multicolumn{1}{c}{Year} & \multicolumn{1}{L}{return} `table_stats' & \multicolumn{1}{c}{Obs.} \\ ""';
local si_fmt `"1.1"';
listtex `table_vars' using `"$PaperPath/`filename'.tex"', 
replace rstyle(tabular) headline("\begin{table}[tb]\centering" "\def\sym#1{\ifmmode^{#1}\else\(^{#1}\)\fi}" "\sisetup{table-format=`si_fmt'}" "\caption{`title'}" "\begin{tabularx}{\textwidth}{c *{`=`nvars'-2'}{S} c}" "\\" "\hline \hline" `headlines1' `headlines2' "\hline") footline("\hline \hline" "\multicolumn{`nvars'}{l}{" "\begin{minipage}{\hsize}" "\rule{0pt}{9pt}" "\footnotesize" "\noindent" "`notes'"  "\end{minipage}" "}\\" "\end{tabularx}" "\label{tab:`filename'}" "\end{table}"); 

/*Presentation table*/
local j = 1;
local table_stats;
foreach heading in `"Fund&return"' `"Expenses/&Assets"' `"Benefits NPV/&Assets"' {;
	local j = `j'+2;
	tokenize `heading', parse(&);
	forvalues h = 1/2 {;
		if `h'==1 {;
			local n = `h';
		};
		else {;
			local n = `h' + 1;
		};
		local header`h' `"`header`h'' & \multicolumn{2}{c}{``n''}"';
	};
	local midrules `"`midrules' \cmidrule(lr{.75em}){`j'-`=`j'+1'}"';
	foreach stat in Mean SD {;
		local table_stats `"`table_stats' & \multicolumn{1}{L}{`stat'}"';
	};
};
local notes; 
local title `"Summary statistics"';
local headlines1 `" "&\multicolumn{1}{L}{S\&P} `header1' & \\" "';
local headlines2 `" "&\multicolumn{1}{L}{500} `header2' & \\ `midrules'" "';
local headlines3 `" " \multicolumn{1}{c}{Year} & \multicolumn{1}{L}{return} `table_stats' & \multicolumn{1}{c}{Obs.} \\ ""';
local headlines `"`headlines1' `headlines2' `headlines3'"';
listtex `table_vars' using `"$PresentationPath/`filename'.tex"', 
replace rstyle(tabular) headline("\begin{table}[tb]\centering" "\def\sym#1{\ifmmode^{#1}\else\(^{#1}\)\fi}" "\sisetup{table-format=`si_fmt'}" "\caption{`title'}" "\begin{tabularx}{\textwidth}{c *{`=`nvars'-2'}{S} c}" "\hline \hline" `headlines' "\hline") footline("\hline \hline" "\multicolumn{`nvars'}{l}{" "\begin{minipage}{\hsize}" "\rule{0pt}{9pt}" "\footnotesize" "\noindent" "`notes'"  "\end{minipage}" "}\\" "\end{tabularx}" "\label{tab:`filename'}" "\end{table}"); 


/*****************************************************************************************************
Summary Figure
*****************************************************************************************************/

/*****************************************************************************************************
4. Main regression tables
*****************************************************************************************************/
#delimit cr
estimates clear
local funding_var funding_ratio_yearly
local expenses_var funding_expenses_yearly
local xlist `"`funding_var' `expenses_var'"' 
local base 2006

foreach prefix in "" sd_ {

	di `"`prefix'return"'
		
	local controls
	local controlfootnote

	if "`prefix'"~="sd_"{
		local year_min `base'
	}
	else if "`prefix'"=="sd_"{
		local year_min 2004
	}

	/* Load data */
	qui use 5500-cleaned`year_min' if !flag_id_dfe & !flag_id_missing & !flag_id_truncated, clear
	/*Drop plans that don't start on January 1*/
	keep if month(sch_h_plan_year_begin_date)==1 & day(sch_h_plan_year_begin_date)==1
	/*Drop plans where funding ratio is not given for first day of year*/
	foreach pre in sb mb actrl {
		drop if (sch_h_plan_year!=`pre'_value_date) & !missing(`pre'_value_date)
	}
	/*Rebalance panel*/
	qui egen nyears = count(year), by(id)
	qui sum nyears
	drop if nyears<r(max)
	/*Option to use alternative return measure that excludes other "other income"*/
	if regexm(`"`OUTPUT_PS'"',`"-alt"') {
		qui replace return = return_alt
		qui replace sd_return = sd_return_alt
	}
	/*Merge Fama French factors*/
	preserve
	FamaFrench annual
	qui drop if year==2013
	qui gen sd_Mkt_RF = .
	foreach yyyy in 2004 2009 {
		qui egen sd_Mkt_RF`yyyy' = sd(Mkt_RF) if inrange(year,`yyyy',`yyyy'+4)
		qui replace sd_Mkt_RF = sd_Mkt_RF`yyyy' if year==`yyyy'
	}
	tempfile FF
	save `FF'
	restore
	merge m:1 year using `FF', nogenerate assert(matched using) keep(matched)
	qui xtset id year
	
	/*Rescale return and standard deviation to be in percentage points*/
	qui replace `prefix'return=100*`prefix'return	
	
	/* Generate age control variable */
	egen control_age=median(year(plan_eff_date)), by(id)
	qui replace control_age=. if control_age<1900 & control_age>2012

	if "`prefix'"=="sd_"{
		keep if inlist(year,2004,2009)
	}		

	/* Generate log assets as possible weight */
	egen a_weight=max(a_boy*(year==`year_min')), by(id)
	gen a_lweight=log(a_weight)
	foreach t of numlist `=`year_min'+1'/2012{ 
		qui gen DD`t'=(year==`t')
	}
		
	/* Generate control variables interacted with year */
	local controlfootnote "Controls are age and log assets in 2006."
	local controltitle "(with controls)"
	gen control_size=a_lweight
	foreach x in control_size control_age{
		clean `x'
		local controls `"`controls' i.year#c.`x'"'
	}
	
	/* Categorical variable for whether ever part of MB plan */
	qui egen flag_MB = max(!missing(funding_ratio_MB)), by(id)
		
	/* Loop for regressions */
	foreach x of local xlist {
	
		di `"`x'"'
	
		clean `x'
		
		capture drop x
		qui gen x = `x'
		label variable x `"Plan measure"'
		
		foreach specification in ols {			
			if "`specification'"=="ols"{
				local weight `""'
			}
			else  if `"`specification'"'==`"wls"' {
				local weight `"[aw = a_lweight]"'
			}
			if `"`x'"'==`"`funding_var'"' & `"`prefix'"'==`""' {
				preserve
				qui drop if flag_MB
				qui drop nyears
				qui drop if missing(`x')
				qui egen nyears = count(id), by(id)
				qui drop if nyears!=6
				
				qui eststo `prefix'`x'DD: reg `prefix'return i.year `controls' c.Mkt_RF#c.x ib`base'.year#c.Mkt_RF#c.x `weight', cluster(ein)	
				qui estadd local FFload `"No"'
				qui estadd local FundFE `"No"'
				qui estadd local Controls `"Yes"'
				qui estadd local YearFE `"Yes"'
				qui levelsof year if e(sample), local(sample_years)				
				qui estadd scalar N_unique = e(N)/`:word count `sample_years''
				
				keep if mod(id,20)==0
				if regexm(`"`OUTPUT_PS'"',`"2$"') {
					qui eststo `prefix'`x': reg `prefix'return i.year i.id#c.Mkt_RF i.year#c.Mkt_RF#c.x `weight', cluster(ein)
					qui estadd local FundFE `"No"'
				}
				else if regexm(`"`OUTPUT_PS'"',`"3$"') {
					 eststo `prefix'`x': xtabond2 `prefix'return i.year i.id#c.Mkt_RF i.year#c.Mkt_RF#c.x `weight', gmmstyle(i.year i.id#c.Mkt_RF i.year#c.Mkt_RF#c.x) 
					qui estadd local FundFE `"Yes"'
				}
				else {
					qui eststo `prefix'`x': xtreg `prefix'return i.year i.id#c.Mkt_RF i.year#c.Mkt_RF#c.x `weight', fe cluster(ein)
					qui estadd local FundFE `"Yes"'
				}
				qui estadd local FFload `"Yes"'
				qui estadd local Controls `"No"'
				qui levelsof year if e(sample), local(sample_years)				
				restore
			}
				
			else if `"`x'"'==`"`expenses_var'"' & `"`prefix'"'==`""' {
				qui eststo `prefix'`x': reg `prefix'return i.year `controls' c.Mkt_RF#c.x ib`base'.year#c.Mkt_RF#c.x `weight', cluster(ein)
				qui estadd local FFload `"No"'
				qui estadd local FundFE `"No"'
				qui estadd local Controls `"Yes"'
				qui levelsof year if e(sample), local(sample_years)
			}
			
			else if `"`prefix'"'==`"sd_"' {
				preserve
				qui replace year = `base' if year==2004
				/*Esttab can't handle multiple base levels of the same variable. This is a cheap work-around if base is 2006*/
				if `"`x'"'==`"`funding_var'"' {
					qui drop if flag_MB
				}
				if regexm(`"`OUTPUT_PS'"',`"4"') {
					qui eststo `prefix'`x': reg `prefix'return i.year `controls' x ib`base'.year#c.x `weight', cluster(ein)
				}
				else {
					qui eststo `prefix'`x': reg `prefix'return i.year `controls' c.sd_Mkt_RF#c.x ib`base'.year#c.sd_Mkt_RF#c.x `weight', cluster(ein)
				}
				qui estadd local FFload `"No"'
				qui estadd local FundFE `"No"'
				qui estadd local Controls `"Yes"'
				qui levelsof year if e(sample), local(sample_years)
				restore
			}
			
			/*Change factor variables to have labels in output*/
			if `"`prefix'"'==`""' {
				local marketvar `"LatexMath rsub{m}^e$"'
			}
			else if `"`prefix'"'==`"sd_"' {
				local marketvar `"LatexMath \sigma \left( rsub{m}^e \right)$"'
			}
			local bnames: colnames e(b)
			foreach bname of local bnames {
				if regexm(`"`bname'"',`"^2[0-9][0-9][0-9][b]?\.year#c.`prefix'Mkt_RF#c.x"') | (regexm(`"`bname'"',`"^2[0-9][0-9][0-9][b]?\.year#co.`prefix'Mkt_RF#co.x"') & `"`prefix'"'!=`"sd_"') {
					local year = substr(`"`bname'"',1,4)
					local varlabels `"`varlabels' `bname' `"`year' X `marketvar' X (`:variable label x')"' "'
					local keepvars `"`keepvars' `bname'"'
				}
				else if regexm(`"`bname'"',`"c.`prefix'Mkt_RF#c.x"') {
					local varlabels `"`varlabels' `bname' `"`marketvar' X (`:variable label x')"' "'
					local keepvars `"`keepvars' `bname'"'
				}
			}				
				
			qui estadd local YearFE `"Yes"'
			qui estadd local type = upper(`"`specification'"')
			qui estadd scalar N_unique = e(N)/`:word count `sample_years''
			qui estadd local period `"`: word 1 of `sample_years''-`=substr(`"`:word `:word count `sample_years'' of `sample_years''"',3,2)'"' 
			
			local C_list `" `C_list' C`x'`specification'"'
			local n_C=`n_C'+1
		}
	}	
}
di `"`keepvars'"'
#delimit;
local order `"c.Mkt_RF#c.x `base'b.year#co.Mkt_RF#co.x"';
forvalues yyyy = `=`base'+1'/2012 {;
	local order `"`order' `yyyy'.year#c.Mkt_RF#c.x"';
};
local nregs = `n_C' + 1;
local groups1 `"& \multicolumn{`nregs'}{c}{Plan measure:}"'; 
local midrules1 `"\cmidrule(lr{.75em}){2-`=`nregs'+1'}"';
local groups2 `"& \multicolumn{2}{c}{Benefits / Assets} & \multicolumn{3}{c}{Benefits NPV / Assets}"'; 
local midrules2 `"\cmidrule(lr{.75em}){2-3} \cmidrule(lr{.75em}){4-6}"'; 
local groups3 `"& \multicolumn{`nregs'}{c}{Dependent variable (p.p.):}"'; 
local midrules3 `"\cmidrule(lr{.75em}){2-`=`nregs'+1'}"';
local groups4 `"& \multicolumn{1}{c}{LatexMath rsub{i,t}$} & \multicolumn{1}{c}{LatexMath \sigma\left(rsub{i,t}\right)$}& \multicolumn{1}{c}{LatexMath rsub{i,t}$} & \multicolumn{1}{c}{LatexMath \sigma\left(rsub{i,t}\right)$}& \multicolumn{1}{c}{LatexMath rsub{i,t}$}"'; 
local midrules4 `"\cmidrule(lr{.75em}){2-2} \cmidrule(lr{.75em}){3-3} \cmidrule(lr{.75em}){4-4} \cmidrule(lr{.75em}){5-5} \cmidrule(lr{.75em}){6-6}"'; 
local groups `" "`groups1'\\ `midrules1'" "`groups2'\\" "`midrules2'" "`groups3'\\" "`midrules3'" "`groups4'\\" "`midrules4'" "';	
local stats "YearFE Controls FundFE FFload N_unique N_clust N";
local stats_fmt "%3s %3s %3s %3s %12.0fc %12.0fc %12.0fc";
local stats_label `" `"Year FE"' `"Size, age controls"' `"Fund FE"' `"Fund-specific LatexMath rsub{m}^e$ loading"' `"Unique funds"' `"Fund sponsor clusters"' `"Observations"' "';
local num_stats: word count `stats'; 
local layout;
forvalues l = 1/`num_stats' {;
	local layout `"`layout' "\multicolumn{1}{c}{@}" "';
};
local si 1.3;
local title "`sector_name' reaching for yield regressions";
local table_preamble `" "\begin{table}[htbp]\centering \def\sym#1{\ifmmode^{#1}\else\(^{#1}\)\fi}" "\caption{`title'}" "\begin{tabularx}{\hsize}{@{\hskip\tabcolsep\extracolsep\fill}l*{`nregs'}{S}}" "\\" "\hline\hline" "';
local prehead `"prehead(`table_preamble' `groups')"';			
local posthead `"posthead(`"\hline"' `"\multicolumn{`=`nregs'+1'}{l}{Right hand side variables:}\\"' `"\\"')"';
local notes `"Notes: The pension return LatexMath rsub{i,t}$ is the annual earnings on investments divided by the sum of beginning of year assets plus one half net transfers and contributions. LatexMath \sigma\left(rsub{i,t}\right)$ is the standard deviation of the pension return over 2004-08 or 2009-12.  LatexMath rsub{m}^e$ is the Fama-French stock market excess return. Benefits NPV/assets are not available for 2008, and in all years specifications including this variable remove multiemployer (MB) plans. If included, size (log assets) and age controls interacted with year. Observations with a distance to the median larger than five times the interquartile range are winsorized. Standard errors in parentheses and clustered by fund sponsor. +,*,** indicate significance at the 0.1, 0.05, 0.01 levels respectively."';
local filename `"`sector'-reaching-regressions`OUTPUT_PS'"';
local estimates `" `expenses_var' sd_`expenses_var' `funding_var'DD sd_`funding_var' `funding_var'"';
esttab `estimates' using "$OutputPath/`filename'.tex",  replace cells(b(star fmt(%9.2f)) se(par fmt(%9.2f) abs)) starlevels(\$^{+}$ 0.1 \$^{*}$ 0.05 \$^{**}$ 0.01) drop(, relax) keep(`keepvars', relax) `prehead' `posthead' order(`order') label varlabel(`varlabels') postfoot(`"\hline\hline \multicolumn{@span}{l}{\begin{minipage}{\hsize} \rule{0pt}{9pt} \footnotesize `notes'  \end{minipage} }\\ \end{tabularx} \end{table}"') stats(`stats', layout(`layout') fmt(`stats_fmt') labels(`stats_label')) collabels(,none) numbers nomtitles substitute(LatexMath \$ _ "-" sub _ # " X " tabular* tabularx {1}{c} {1}{L} "\centering" "\centering \sisetup{table-format=`si'}") width(\hsize) prefoot(`indicate' "\label{tab:`filename'}");	
EmbedTex `"`filename'"' using `"$OutputPath/`sector'-reaching-regressions-embedded.tex"', title(`sector' reaching regressions) author(Gabriel Chodorow-Reich) replace;
*copy "$OutputPath/`filename'.tex" "$PaperPath/`filename'.tex", replace;


/*Presentation tables*/
local nregs = 2;
local halfnregs = 1; 
local title "Reaching for yield regressions";
local midrules1 `"\cmidrule(lr{.75em}){2-`=`nregs'+1'}"';
local groups2 `"& \multicolumn{`nregs'}{c}{Plan measure:}"'; 
local midrules2 `"\cmidrule(lr{.75em}){2-`=`nregs'+1'}"';
local groups3 `"& \multicolumn{`halfnregs'}{c}{Benefits expenses / Assets} & \multicolumn{`halfnregs'}{c}{Benefits NPV / Assets}"'; 
local table_preamble `" "\begin{table}[htbp]\centering \def\sym#1{\ifmmode^{#1}\else\(^{#1}\)\fi}" "\caption{`title'}" "\begin{tabularx}{\hsize}{@{\hskip\tabcolsep\extracolsep\fill}l*{`nregs'}{S}}" "\hline\hline" "';
local si 1.3;
local title "`sector_name' reaching for yield regressions";
local notes;

foreach prefix in "" sd_ {;

	if `"`prefix'"'==`"sd_"' {;
		local groups1 `"& \multicolumn{`nregs'}{c}{Dependent variable: LatexMath \sigma\left(rsub{i,t}\right)$}"';
		if regexm(`"`OUTPUT_PS'"',`"4"') {;
			local order `"x 2009.year#c.x"';
			local keepvars `"x 2009.year#c.x"';
		};
		else {;
			local order `"c.sd_Mkt_RF#c.x 2009.year#c.sd_Mkt_RF#c.x"';
		};		
		local stats "YearFE Controls N_unique N_clust N";
		local stats_fmt "%3s %3s %12.0fc %12.0fc %12.0fc";
		local stats_label `" `"Year FE"' `"Size, age controls"' `"Unique funds"' `"Fund sponsor clusters"' `"Observations"' "';
	};
	else {;
		local groups1 `"& \multicolumn{`nregs'}{c}{Dependent variable: LatexMath rsub{i,t}$}"';
		local order `"c.Mkt_RF#c.x `base'b.year#co.Mkt_RF#co.x"';
		forvalues yyyy = `=`base'+1'/2012 {;
			local order `"`order' `yyyy'.year#c.Mkt_RF#c.x"';
		};		
		local stats "YearFE Controls FundFE FFload N_unique N_clust N";
		local stats_fmt "%3s %3s %3s %3s %12.0fc %12.0fc %12.0fc";
		local stats_label `" `"Year FE"' `"Size, age controls"' `"Fund FE"' `"Fund-specific LatexMath rsub{m}^e$ loading"' `"Unique funds"' `"Fund sponsor clusters"' `"Observations"' "';
	};
	local groups `" "`groups1'\\ `midrules1'" "`groups2'\\" "`midrules2'" "`groups3'\\" "';	
	local prehead `"prehead(`table_preamble' `groups')"';			
	local posthead `"posthead(`"\hline"')"';
	local num_stats: word count `stats'; 
	local layout;
	forvalues l = 1/`num_stats' {;
		local layout `"`layout' "\multicolumn{1}{c}{@}" "';
	};
	
	local filename `"`sector'-`=regexr(`"`prefix'"',`"_"',`"-"')'reaching-regressions`OUTPUT_PS'"';
	local estimates `" `prefix'`expenses_var' `prefix'`funding_var' "';
	*esttab `estimates' using "$PresentationPath/`filename'.tex",  replace cells(b(star fmt(%9.2f)) se(par fmt(%9.2f) abs)) starlevels(\$^{+}$ 0.1 \$^{*}$ 0.05 \$^{**}$ 0.01) drop(, relax) keep(`keepvars', relax) `prehead' `posthead' order(`order') label varlabel(`varlabels') postfoot(`"\hline\hline \multicolumn{@span}{l}{\begin{minipage}{\hsize} \rule{0pt}{9pt} \footnotesize `notes'  \end{minipage} }\\ \end{tabularx} \end{table}"') stats(`stats', layout(`layout') fmt(`stats_fmt') labels(`stats_label')) collabels(,none) nonumbers nomtitles substitute( `"(Plan measure)"' `"(Measure)"' LatexMath \$ _ "-" sub _ # " X " tabular* tabularx {1}{c} {1}{L} "\centering" "\centering \sisetup{table-format=`si'}") width(\hsize) prefoot(`indicate' "\label{tab:`filename'}");	
};

estimates drop _all;

/*****************************************************************************************************
5. Uninteracted regressions
*****************************************************************************************************/
#delimit cr
local base 2004

/* Load data */
qui use 5500-cleaned`base' if !flag_id_dfe & !flag_id_missing & !flag_id_truncated, clear
/*Drop plans that don't start on January 1*/
keep if month(sch_h_plan_year_begin_date)==1 & day(sch_h_plan_year_begin_date)==1
/*Drop plans where funding ratio is not given for first day of year*/
foreach pre in sb mb actrl {
	drop if (sch_h_plan_year!=`pre'_value_date) & !missing(`pre'_value_date)
}
/*Rebalance panel*/
qui egen nyears = count(year), by(id)
qui sum nyears
drop if nyears<r(max)
/*Option to use alternative return measure that excludes other "other income"*/
if regexm(`"`OUTPUT_PS'"',`"-alt"') {
	qui replace return = return_alt
	qui replace sd_return = sd_return_alt
}
/*Merge Fama French factors*/
preserve
FamaFrench annual
qui drop if year==2013
tempfile FF
save `FF'
restore
merge m:1 year using `FF', nogenerate assert(matched using) keep(matched)
qui xtset id year

/* Generate age control variable */
egen control_age=median(year(plan_eff_date)), by(id)
qui replace control_age=. if control_age<1900 & control_age>2012

/* Generate log assets as possible weight */
egen a_weight=max(a_boy*(year==`base')), by(id)
gen a_lweight=log(a_weight)
foreach t of numlist `=`base'+1'/2012{ 
	qui gen DD`t'=(year==`t')
}
		
/* Generate control variables interacted with year */
gen control_size=a_lweight
foreach x in control_size control_age{
	clean `x'
	local controls `"`controls' i.year#c.`x'"'
}
	
xtreg return i.id#c.Mkt_RF i.year#c.Mkt_RF `weight', fe cluster(ein)

