// Replicate Cutler using US-Level Data
// Author: Jonathan Holmes
// jholmes.hks@gmail.com
// Created: July 5, 2013

		
clear all			
*********************************************************************
****************** WRITE SIMPLE LITTLE PROGRAMS *********************
*********************************************************************
cap program drop add_stats_estout
program define add_stats_estout
	syntax,  [TESTsum(varlist ts)]
	sum year if e(sample)
	
	estadd scalar yearmin = r(min)
	estadd scalar yearmax = r(max)
	
	//IF WE HAVE A TESTSUM
	if "`testsum'" != "" {
		tempname bmat i
		matrix define `bmat' = e(b)
		
		local testvarsum = 0
		foreach testvar of local testsum {
			matrix define `i' = `bmat'[1, "`testvar'"]
			local il = `i'[1,1]
			local testvarsum = `testvarsum' + `il'
						
			local testcmd = "`testcmd'+`testvar'"
		}
		
		//lincom
		local testcmd `=substr("`testcmd'", 2, .)'
		lincom `testcmd'
		
		
		//test
		local testcmd `testcmd' = 0
		test `testcmd'
		estadd scalar testsum = `testvarsum'
		estadd scalar testF = `=r(F)'
		estadd scalar testp = `=r(p)'
		estadd local testcmd = "`testcmd'"
		
	}
end


*********************************************************************
************************* LOAD DATA *********************************
*********************************************************************

use "../../2data/BEA-gdp.dta", clear
merge 1:1 year using "../../2data/NHE2011-spending-by-location", nogen
merge 1:1 year using "../../2data/NHE2011-spending-by-payer", nogen
merge 1:1 year using "../../2data/BEA-gdpdeflator.dta", nogen 
merge 1:1 year using "../../2data/CENSUS-population-totalUS.dta", nogen


*********************************************************************
******************** GENERATE AND LABEL ****************************
*********************************************************************
tsset year, yearly

//GDP VARS
gen rpcgdp 	= gdp*100*10^6/(gdp_deflator*age_all)
label variable rpcgdp "Real Per Capita GDP"


foreach indvar of varlist rpcgdp  {
	//GROWTH VARS
	gen g_`indvar' = D.`indvar'/L.`indvar'
	label variable  g_`indvar' "Real Per Capita GDP Growth"
	
	forvalues x = 2/8 {
		gen g`indvar'_`x'yrgav = (`indvar'/L`x'.`indvar')^(1/`x')-1
		label variable g`indvar'_`x'yrgav "Average `x'-Year GDP Growth"
	}
}
	
foreach var of varlist totsp perscare insmedicaid insmedicare inspvt oop {
	gen rpc`var'	= `var'*100*10^6/(gdp_deflator*age_all)
	gen g_rpc`var' 	= D.rpc`var'/L.rpc`var'
}




*********************************************************************
************************ growth by  ********************************
*********************************************************************

local indvar rpcgdp
local var totsp 
local cond "year >= 1970 & year <= 2012"
local condname "1970-2012"
		
//Average Growth (All Models, Real)
eststo: reg g_rpc`var' 	g_`indvar'		if `cond', robust
add_stats_estout

eststo: reg g_rpc`var' 	g`indvar'_2yrgav 	if `cond', robust
add_stats_estout

eststo: reg g_rpc`var' 	g`indvar'_3yrgav 	if `cond', robust
add_stats_estout

eststo: reg g_rpc`var' 	g`indvar'_4yrgav 	if `cond', robust
add_stats_estout

eststo: reg g_rpc`var' 	g`indvar'_5yrgav 	if `cond', robust
add_stats_estout

eststo: reg g_rpc`var' 	g`indvar'_6yrgav 	if `cond', robust
add_stats_estout

eststo: reg g_rpc`var' 	g`indvar'_7yrgav 	if `cond', robust
add_stats_estout
		
eststo: reg g_rpc`var' 	g`indvar'_8yrgav 	if `cond', robust
add_stats_estout

#delimit ;
esttab using "../../4Output/taba03-spendingbymodel.tex", booktabs replace 
	mgroups(
		"\specialcell{Dependent Variable: Growth in Real, Per Capita \\ `:variable label `var''}", pattern(1 0 0 0) 
		prefix(\multicolumn{@span}{c}{) suffix(}) span) 
	 nomtitles se
	varlabels(_cons "Constant", prefix(\multirow{2}{3cm}{\hangindent=1.75em) suffix(\\}))
	label
	stats(yearmin  yearmax  r2 N, labels("First Year" "Last Year" "R2" "N"))
	starlevels(\sym{*} .1 \sym{**} .05 \sym{***} .01)
	addnote(
			"\(\sym{*}\) \(p<.10\), \(\sym{**}\) \(p<.05\), \(\sym{***}\) \(p<.01\)"
			"Standard errors in parenthesis. Results are from OLS regressions with robust standard errors.")
	substitute({l} {p{\linewidth}})
	
	nonote
	;
#delimit cr

	//starlevels(* .1 ** .05 *** .01)
eststo clear




*********************************************************************
*********************** GROWTH BY PAYER *****************************
*********************************************************************
local gdpvar g_rpcgdp
local cond  "year >= 1970 & year <= 2012"
local condname "1970-2012"
local insvars g_rpctotsp g_rpcperscare g_rpcinsmedicare g_rpcinsmedicaid g_rpcinspvt g_rpcoop
local institles `""Total" "Personal" "Medicare" "Medicaid" "Private \\ Insurance" "Out of \\ Pocket \\ Spending""'

//Check subcategories of spending
eststo clear

foreach instype of varlist `insvars'{
	eststo `instype'_nolags:   reg `instype' 	`gdpvar'	if `cond', robust
	add_stats_estout
	
	eststo `instype'_3lags:     reg `instype'  	`gdpvar' L.`gdpvar' L2.`gdpvar' L3.`gdpvar' if `cond', robust
	add_stats_estout, testsum(`gdpvar' L.`gdpvar' L2.`gdpvar' L3.`gdpvar') 

	
	eststo `instype'_5lags:     reg `instype'  	`gdpvar' L.`gdpvar' L2.`gdpvar' L3.`gdpvar' L4.`gdpvar'	L5.`gdpvar' if `cond', robust
	add_stats_estout, testsum(`gdpvar' L.`gdpvar' L2.`gdpvar' L3.`gdpvar' L4.`gdpvar' L5.`gdpvar') 
	eststo `instype': combine_models `instype'_nolags `instype'_3lags `instype'_5lags, scalars(yearmin  yearmax testsum testF testp r2 N) eqlist(A B C) locals(vce)
}


#delimit ;
esttab `insvars' using "../../4Output/taba02-spendingbypayer.tex", booktabs replace
	mgroups(
		"\specialcell{Dependent Variable: Growth in Real, Per Capita Costs Paid By:}", pattern(1 0 0 0 0 0 0) 
		prefix(\multicolumn{@span}{c}{) suffix(}) span) 
	 nonumber
	 mlabels(
		`institles', 
		prefix(\specialcell{) suffix(})
		)
	 
	 
	 eqlabels(
		"\emph{Panel A: No Lags}"
		"\emph{Panel B: With 3 Lags}"
		"\emph{Panel C: With 5 Lags}", 
		prefix(\addlinespace \multicolumn{@span}{l}{) suffix(}) span)		
		
	varlabels(
		g_rpcgdp "Real, Per Capita GDP Growth (Current Period)"
		_cons "Constant", 
		prefix(\multirow{2}{5cm}{\hangindent=1.75em) suffix(\\})
		)
	
	drop(L*g_rpcgdp _cons)
		
	label
	stats(
		r21   
		testsum2 testF2 testp2 r22 
		testsum3 testF3 testp3 r23 
		yearmin  yearmax  N, 
	labels(
		"R2 (Model 1)" 
		
		"{\hangindent=1.75em Sum of Current and Lagged `:variable label `gdpvar'' (M2)}" 
		"Wald F Statistic"
		"P-Value"
		 "R2 " 
		
		"{\hangindent=1.75em Sum of Current and Lagged `:variable label `gdpvar'' (M3)}"
		"Wald F Statistic"
		"P-Value"
		"R2" 
		 
		 "First Year" "Last Year" "N")
	fmt(
		%4.3f  
		%4.3f  %5.0g %4.3f %4.3f
		%4.3f  %5.0g %4.3f  %4.3f
		a3  a3  a3)
	)
	starlevels(\sym{*} .1 \sym{**} .05 \sym{***} .01)
	nonote addnote(
			"\(\sym{*}\) \(p<.10\), \(\sym{**}\) \(p<.05\), \(\sym{***}\) \(p<.01\)"
			"Standard errors in parenthesis. Results are from OLS regressions with robust standard errors.
			F statistics are against the null that the current and all lagged coefficients are all equal to zero.")
	substitute({l} {p{\linewidth}})
	
	se;
#delimit cr
		




