// Yearly NHE and GDP Growth
// Author: Jonathan Holmes
// jholmes.hks@gmail.com
// Created: November 9, 2013

*********************************************************************
*************************** LOAD DATA *******************************
*********************************************************************


clear all
use "../../2data/Atlarum-NHEmonthly.dta"
merge 1:1 mthyr using "../../2data/MA-Monthly-GDP.dta", nogen

keep if month(dofm(mthyr)) == 7
tsset year, yearly

gen monthlygdpdeflator = monthlynominalgdpindex*100/monthlyrealgdpindex
gen realtotsp = totsp*100/monthlygdpdeflator

foreach var of varlist realtotsp monthlyrealgdpindex {
	gen g_`var' = D.`var'/L.`var'
}

gen g_nhe_minus_gdp = g_realtotsp-g_monthlyrealgdpindex


*********************************************************************
************************* CREATE TABLE ******************************
*********************************************************************

br year g_* if year >= 2001 

