// Clean up the Make a line graph of OECD data at the aggregate level
// Author: Jonathan Holmes
// jholmes.hks@gmail.com
// Created: September 9, 2013




*********************************************************************
************************* LOAD DATA *********************************
*********************************************************************
clear all
do "../../0ado/recession_line_graph.ado"
use "../../2data/OECD-healthdata.dta", clear
merge 1:1 year country using "../../2data/OECD-population.dta", nogen


//COLLAPSE DATA TO FIND MEAN GROWTH RATES
drop if country == "OECD - Total"
drop if year <= 1990 | year > 2011

drop if country == "United States"
encode country, gen(country_no)

tsset country_no year
foreach var of varlist  rpcppp*{
	gen g`var' = D.`var'/L.`var'
}

tempfile oecd_weighted 
preserve
collapse (mean)  grpcppp_*[pweight = oecd_population], by(year)
gen country = "OECD - Non-US, Weighted" 
save `oecd_weighted', replace
restore


//MERGE COLLAPSED DATA BACK TOGETHER
use `oecd_weighted', clear
merge 1:1 year country using "../../2data/OECD-healthdata.dta", nogen
keep if inlist(country, "United States",  "OECD - Non-US, Weighted")

encode country, gen(country_no)
tsset country_no year

foreach var of varlist  rpcppp_*{
	replace g`var' = D.`var'/L.`var' if missing(g`var')
}

gen country_cd = ""
replace country_cd = "_us" if country == "United States"
replace country_cd = "_oecd_wght"   if country == "OECD - Non-US, Weighted" 

drop country rpcppp_* country_no
reshape wide grpcppp_*, i(year) j(country_cd) string


//MERGE IN US DATA
merge 1:1 year using "../../2data/NHE2011-spending-by-payer", nogen
merge 1:1 year using "../../2data/NHE2011-spending-by-payer-prescription", nogen
merge 1:1 year using "../../2data/BEA-gdpdeflator.dta", nogen 
merge 1:1 year using "../../2data/CENSUS-population-totalUS.dta", nogen

tsset year, yearly
gen insmedicare_no_part_d = insmedicare - insmedicare_drug
foreach var of varlist   totalsp insmedicare insmedicare_no_part_d  {
	gen rpc`var' 	= `var'*100*10^6/(gdp_deflator*age_all)
	gen grpc`var'	= D.rpc`var'/L.rpc`var'
}



*********************************************************************
************************* DRAW GRAPH ********************************
*********************************************************************

#delimit ;
recession_line_graph if year > 2000, date(year)
	graphvars(
		"grpctotalsp Total (US)"
		"grpcinsmedicare_no_part_d Medicare (US)"
		"grpcppp_healthtotsp_oecd_wght Total (Other OECD)"
		"grpcppp_healthgovtsp_oecd_wght Public (Other OECD)"
	)
	twoway_options(
		ytitle("Real Health Spending Growth")
	)
	zeroline
;
#delimit cr
graph export "../../4Output/fig03-us-vs-oecd.png", replace width(800) height(600)




