//Subroutine: Code Industry and Occupation Variables
//Author: Jonathan Holmes
//jholmes.hks@gmail.com
//Date Created: June 3, 2013

*********************************************************************
********************* ARGUMENTS PASSED TO DO-FILE *******************
*********************************************************************

if strpos(upper("`1'"), "SKIP_OCC") == 1 {
	local skip_occ = 1
}

if strpos(upper("`1'"), "SKIP_IND") {
	local skip_ind = 1
}


*********************************************************************
************************** PROGRAMS TO USE **************************
*********************************************************************

cap program drop gen_replace
program define gen_replace 
	syntax anything(name=genreplace)
	local genreplace `genreplace'
	gettoken var: genreplace
	
	cap gen byte `genreplace'
	if _rc {
		replace `genreplace' if missing(`var')
	}
end

*********************************************************************
************************** VALUE LABELS *****************************
*********************************************************************

#delimit ; 
label define hcoccd
	1 "Health managers"
	2 "Physicians"
	3 "Dentists"
	4 "Optometrists"
	5 "Registered nurses"
	6 "Licenced nurses"
	7 "Psychologists "
	8 "Therapists"
	9 "Pharmacists"
	10 "Other health diagnosing"
	11 "Dental hygenists/lab techs"
	12 "Dental assistant"
	13 "Health record technicians"
	14 "Other Lab Techs"
	15 "Assistants"
	16 "Medical Scientists"
	17 "Podiatrist"
; 

label define hcoccc
	1 "Health Managers"
	2 "Physicians"
	3 "Podiatrists"
	4 "Dentists"
	5 "Optometrists"
	6 "Registered Nurses"
	7 "Therapists"
	8 "Pharmacists"
	9 "Other health diagnosing"
	10 "Assistants/LN/Lab Tech"
	11 "Medical Scientists"
; 

label define hcindd
	1 "Offices of physicians and outpatient care centers"
	2 "Offices of dentists"
	3 "Offices of chiropractors"
	4 "Offices of optometrists"
	5 "Offices of other health practitioners"
	6 "Home health care services and other health services"
	7 "Hospitals"
	8 "Nursing care facilities"
	9 "Residential care facilities, without nursing"
	10 "Other health-related social services"
	11 "Insurance Sector"
	12 "Medical equipment and supplies manufacturing"
;

label define hcindc 
	1 "Ambulatory Services"
	2 "Hospital"
	3 "Nursing or Residential Care"
	4 "Other health-related social services"
;

#delimit cr

set trace off
foreach lbl in hcoccd hcoccc hcindd hcindc{ 
	global `lbl'tbl ""
	label list `lbl'
	forvalues n = 1/`=r(max)' {
		local dump : label `lbl' `n'  
		global `lbl'tbl `"${`lbl'tbl} c`n' "`dump'" "'
		global `lbl'cmd `"${`lbl'cmd} `n' "`dump'" "'
	}
}


*********************************************************************
************************ CREATE VARIABLES ***************************
*********************************************************************

if "`skip_occ'" == "" {
	//Dummy variables (are you in a healthcare industry?)
	
	cap confirm var occ00 
	if !_rc{
		gen byte d_hcocc00b = (occ00 >= 3000) & (occ00 <= 3655)
		replace d_hcocc00b = 1 if occ00 == 350  //Medical and health services managers
		replace d_hcocc00b = 1 if occ00 == 1650 //Medical scientists
		replace d_hcocc00b = 1 if occ00 == 1820 //Psychologists
		replace d_hcocc00b = 1 if occ00 == 8760 //Medical dental and ophthalmic lab techs
		replace d_hcocc00b = 1 if occ00 == 9110 //Ambulance drivers and attendants, except emergency medical technicians
		label variable d_hcocc00b "Healthcare industry worker (broad def, 2000  occupation codes)"
	}
		
	cap confirm var occ80
	if !_rc{
		gen byte d_hcocc80b = 0 if !missing(occ80)
		replace d_hcocc80b = 1 if occ80== 15
		replace d_hcocc80b = 1 if occ80== 83
		replace d_hcocc80b = 1 if occ80== 84
		replace d_hcocc80b = 1 if occ80== 85
		replace d_hcocc80b = 1 if occ80== 87
		replace d_hcocc80b = 1 if occ80== 88
		replace d_hcocc80b = 1 if occ80== 89
		replace d_hcocc80b = 1 if occ80== 95
		replace d_hcocc80b = 1 if occ80== 96
		replace d_hcocc80b = 1 if occ80== 97
		replace d_hcocc80b = 1 if occ80== 98
		replace d_hcocc80b = 1 if occ80== 99
		replace d_hcocc80b = 1 if occ80== 103
		replace d_hcocc80b = 1 if occ80== 104
		replace d_hcocc80b = 1 if occ80== 105
		replace d_hcocc80b = 1 if occ80== 106
		//Remove teachers
		//replace d_hcocc80b = 1 if occ80== 133
		//replace d_hcocc80b = 1 if occ80== 134
		replace d_hcocc80b = 1 if occ80== 167
		replace d_hcocc80b = 1 if occ80== 203
		replace d_hcocc80b = 1 if occ80== 204
		replace d_hcocc80b = 1 if occ80== 205
		replace d_hcocc80b = 1 if occ80== 206
		replace d_hcocc80b = 1 if occ80== 207
		replace d_hcocc80b = 1 if occ80== 208
		replace d_hcocc80b = 1 if occ80== 445
		replace d_hcocc80b = 1 if occ80== 446
		replace d_hcocc80b = 1 if occ80== 447
		replace d_hcocc80b = 1 if occ80== 677
		replace d_hcocc80b = 1 if occ80== 678
		
		label variable d_hcocc80b "Healthcare industry worker (broad def, 1980  occupation codes)"
	}
	

	//Detailed categories (By Occupation)
	cap confirm var occ70
	if !_rc{
		gen byte hcocc70d = . 
		replace hcocc70d = 1 if inlist(occ70, 212)
		replace hcocc70d = 2 if inlist(occ70, 65)
		replace hcocc70d = 3 if inlist(occ70, 62)
		replace hcocc70d = 4 if inlist(occ70, 63)
		replace hcocc70d = 5 if inlist(occ70, 75, 923)
		replace hcocc70d = 6 if inlist(occ70, 926)
		replace hcocc70d = 7 if inlist(occ70, 93)
		replace hcocc70d = 8 if inlist(occ70, 76)
		replace hcocc70d = 9 if inlist(occ70, 64)
		replace hcocc70d = 10 if inlist(occ70, 61, 73, 74)
		replace hcocc70d = 11 if inlist(occ70, 81, 426)
		replace hcocc70d = 12 if inlist(occ70, 921)
		replace hcocc70d = 13 if inlist(occ70, 82)
		replace hcocc70d = 14 if inlist(occ70, 80, 83, 85, 	506)			
		replace hcocc70d = 15 if inlist(occ70, 84, 924, 922, 925)
		replace hcocc70d = 16 if inlist(occ70,	44)
		replace hcocc70d = 17 if inlist(occ70, 	71)
		label variable hcocc70d "Detailed Health Care Occupation (1980 codes)"
		label values hcocc70d hcoccd
		
		gen_replace "hcoccd = hcocc70d"
		cap label values hcoccd hcoccd
		
	}
	
	cap confirm var occ80
	if !_rc{
		gen byte hcocc80d = . 
		replace hcocc80d = 1 if inlist(occ80, 15)
		replace hcocc80d = 2 if inlist(occ80, 84)
		replace hcocc80d = 3 if inlist(occ80, 85)
		replace hcocc80d = 4 if inlist(occ80, 87)
		replace hcocc80d = 5 if inlist(occ80, 95)
		replace hcocc80d = 6 if inlist(occ80, 207)
		replace hcocc80d = 7 if inlist(occ80, 167)
		replace hcocc80d = 8 if inlist(occ80, 98, 99, 103, 104, 105)
		replace hcocc80d = 9 if inlist(occ80, 96)
		replace hcocc80d = 10 if inlist(occ80, 89, 97)
		replace hcocc80d = 11 if inlist(occ80, 204, 678)
		replace hcocc80d = 12 if inlist(occ80, 445)
		replace hcocc80d = 13 if inlist(occ80, 205)
		replace hcocc80d = 14 if inlist(occ80, 203,  206,  208, 677)
		replace hcocc80d = 15 if inlist(occ80, 446, 447, 106)
		replace hcocc80d = 16 if inlist(occ80, 83)
		replace hcocc80d = 17 if inlist(occ80, 88)
		label variable hcocc80d "Detailed Health Care Occupation (1980 codes)"
		label values hcocc80d hcoccd
		
		gen_replace "hcoccd = hcocc80d"
		cap label values hcoccd hcoccd
	}
	

	
	cap confirm var occ00
	if !_rc{
		gen byte hcocc00d = . 
		replace hcocc00d = 1 if inlist(occ00, 350)
		replace hcocc00d = 2 if inlist(occ00, 3060)
		replace hcocc00d = 3 if inlist(occ00, 3010)
		replace hcocc00d = 4 if inlist(occ00, 3040)
		replace hcocc00d = 5 if inlist(occ00, 3130)
		replace hcocc00d = 6 if inlist(occ00, 3500)
		replace hcocc00d = 7 if inlist(occ00, 1820)
		replace hcocc00d = 8 if inlist(occ00, 3140, 3210, 3150, 3240, 3230, 3220, 3160)
		replace hcocc00d = 9 if inlist(occ00, 3050)
		replace hcocc00d = 10 if inlist(occ00, 3260, 3000, 3030)
		replace hcocc00d = 11 if inlist(occ00, 3310, 8760)
		replace hcocc00d = 12 if inlist(occ00, 3640)
		replace hcocc00d = 13 if inlist(occ00, 3510)
		replace hcocc00d = 14 if inlist(occ00, 3200, 3300, 3320, 3400, 3410, 3520, 3523, 3530, 3540, 3200, 3620, 3650, 8760, 3110)
		replace hcocc00d = 15 if inlist(occ00, 3600, 3610, 3620, 3650, 4610, 9110)
		replace hcocc00d = 16 if inlist(occ00, 1650)
		replace hcocc00d = 17 if inlist(occ00, 3120)
		label variable hcocc00d "Detailed Health Care Occupation (2000 codes)"
		label values hcocc00d hcoccd
		
		gen_replace "hcoccd = hcocc00d"
		cap label values hcoccd hcoccd
		
	}
	
	
	
	
	//Coarse categories (By Occupation)
	
	cap confirm var occ70
	if !_rc{
		gen byte hcocc70c = . 
		replace hcocc70c = 1 if inlist(occ70, 212)
		replace hcocc70c = 2 if inlist(occ70, 65)
		replace hcocc70c = 3 if inlist(occ70, 71)
		replace hcocc70c = 4 if inlist(occ70, 62)
		replace hcocc70c = 5 if inlist(occ70, 63)
		replace hcocc70c = 6 if inlist(occ70, 75, 923)
		replace hcocc70c = 7 if inlist(occ70, 76)
		replace hcocc70c = 8 if inlist(occ70, 64)
		replace hcocc70c = 9 if inlist(occ70, 61, 73, 74)				
		replace hcocc70c = 10 if inlist(occ70, 426, 926, 925, 83, 922, 921, 81, 80, 82, 85, 506, 924, 84)
		replace hcocc70c = 11 if inlist(occ70, 44)
		label variable hcocc70c "Coarse Health Care Occupation (1980 codes)"
		label values hcocc70c hcoccc
		
		gen_replace "hcoccc = hcocc70c"
		cap label values hcoccc hcoccc
		
	}
	
	cap confirm var occ80
	if !_rc{
		gen byte hcocc80c = . 
		replace hcocc80c = 1 if inlist(occ80, 15)
		replace hcocc80c = 2 if inlist(occ80, 84)
		replace hcocc80c = 3 if inlist(occ80, 88)
		replace hcocc80c = 4 if inlist(occ80, 85)
		replace hcocc80c = 5 if inlist(occ80, 87)
		replace hcocc80c = 6 if inlist(occ80, 95)
		replace hcocc80c = 7 if inlist(occ80, 98, 99, 103, 104, 105)
		replace hcocc80c = 8 if inlist(occ80, 96)
		replace hcocc80c = 9 if inlist(occ80, 89, 97)
		replace hcocc80c = 10 if inlist(occ80, 204, 205, 678, 203,  206,  208, 677, 445, 446, 447, 106, 207)
		replace hcocc80c = 11 if inlist(occ80, 83)
		label variable hcocc80c "Coarse Health Care Occupation (1980 codes)"
		label values hcocc80c hcoccc
		
		gen_replace "hcoccc = hcocc80c"
		cap label values hcoccc hcoccc
	}
	
	cap confirm var occ00
	if !_rc{
		gen byte hcocc00c = . 
		replace hcocc00c = 1 if inlist(occ00, 350)	
		replace hcocc00c = 2 if inlist(occ00, 3060)	
		replace hcocc00c = 3 if inlist(occ00, 3120)	
		replace hcocc00c = 4 if inlist(occ00, 3010)	
		replace hcocc00c = 5 if inlist(occ00, 3040)	
		replace hcocc00c = 6 if inlist(occ00, 3130)	
		replace hcocc00c = 7 if inlist(occ00, 3140, 3210, 3150, 3240, 3230, 3220, 3160)	
		replace hcocc00c = 8 if inlist(occ00, 3050)	
		replace hcocc00c = 9 if inlist(occ00, 3260, 3000, 3030)	
		replace hcocc00c = 10 if inlist(occ00, 3310, 8760, 3200, 3300, 3320, 3400, 3410, 3520, 3523, 3530, 3540, 3200, 3620, 3650, 8760, 3110, 3510, 3600,  3500, 3610, 3620, 3640, 3650,  4610, 9110)	
		replace hcocc00c = 11 if inlist(occ00, 1650)	
		label variable hcocc00c "Coarse Health Care Occupation (2000 codes)"
		label values hcocc00c hcoccc
		
		gen_replace "hcoccc = hcocc00c"
		cap label values hcoccc hcoccc
		
	}
	
	
	cap confirm var occ2011
	if !_rc{
		gen byte hcocc11c = . 
		replace hcocc11c  = 2 if inlist(occ2011, 3060)
		
		/*
		replace hcocc00c = 1 if inlist(occ00, 350)	
		replace hcocc00c = 2 if inlist(occ00, 3060)	
		replace hcocc00c = 3 if inlist(occ00, 3120)	
		replace hcocc00c = 4 if inlist(occ00, 3010)	
		replace hcocc00c = 5 if inlist(occ00, 3040)	
		replace hcocc00c = 6 if inlist(occ00, 3130)	
		replace hcocc00c = 7 if inlist(occ00, 3140, 3210, 3150, 3240, 3230, 3220, 3160)	
		replace hcocc00c = 8 if inlist(occ00, 3050)	
		replace hcocc00c = 9 if inlist(occ00, 3260, 3000, 3030)	
		replace hcocc00c = 10 if inlist(occ00, 3310, 8760, 3200, 3300, 3320, 3400, 3410, 3520, 3523, 3530, 3540, 3200, 3620, 3650, 8760, 3110, 3510, 3600,  3500, 3610, 3620, 3640, 3650,  4610, 9110)	
		replace hcocc00c = 11 if inlist(occ00, 1650)	
		*/
		label variable hcocc11c "Coarse Health Care Occupation (2000 codes)"
		label values hcocc11c hcoccc
		
		gen_replace "hcoccc = hcocc11c"
		cap label values hcoccc hcoccc
		
	}
	
	
}


if "`skip_ind'" == "" {
	//INDUSTRY CODING

	/*	CODING SYSTEM 1 (DETAILED) 
		
		(a) Offices of physicians and outpatient care facilities
		(b) Offices of dentists
		(c) Offices of chiropractors
		(d) Offices of optometrists (dubious)
		(e)	Offices of Other health services (dubious)
		(f) Hospitals
		(g) Nursing care facilities (some issues)
		(h) Residential care facililities, without nursing (dubious)
		(i) OTHER (dubious, and not as useful)
	*/


	/*	CODING SYSTEM 2 (COARSE) 
		
		(a) Non-hospital medical care
		(b) Hospital 
		(c) Nursing and residential care facilities
		(d) OTHER (dubious, and not as useful)
	*/
	
	
	//Detailed categories (By Industry)
	cap confirm var ind70
	if !_rc{
	gen byte hcind70d = . 
		replace hcind70d = 1 if inlist(ind70, 828)
		replace hcind70d = 2 if inlist(ind70, 829)
		replace hcind70d = 3 if inlist(ind70, 837)
		replace hcind70d = 4 if inlist(ind70, 847)
		replace hcind70d = 5 if inlist(ind70, -10)
		replace hcind70d = 6 if inlist(ind70, 848)
		replace hcind70d = 7 if inlist(ind70, 838)
		replace hcind70d = 8 if inlist(ind70, 839)
		replace hcind70d = 9 if inlist(ind70, 879)
		replace hcind70d = 10 if inlist(ind70, 878) 
		replace hcind70d = 11 if inlist(ind70, 717)
		replace hcind70d = 12 if inlist(ind70, 247)
		label variable hcind70d "Detailed Healthcare Industry (1970 codes)"
		label values hcind70d hcindd
	}
	
	
	cap confirm var ind80
	if !_rc{
	gen byte hcind80d = . 
		replace hcind80d = 1 if inlist(ind80, 812)
		replace hcind80d = 2 if inlist(ind80, 820)
		replace hcind80d = 3 if inlist(ind80, 821)
		replace hcind80d = 4 if inlist(ind80, 822)
		replace hcind80d = 5 if inlist(ind80, 830)
		replace hcind80d = 6 if inlist(ind80, 840)
		replace hcind80d = 7 if inlist(ind80, 831)
		replace hcind80d = 8 if inlist(ind80, 832)
		replace hcind80d = 9 if inlist(ind80, 870)
		replace hcind80d = 10 if inlist(ind80, 871, 861, 862) 
		replace hcind80d = 11 if inlist(ind80, 711)
		replace hcind80d = 12 if inlist(ind80, 372)
		label variable hcind80d "Detailed Healthcare Industry (1980 codes)"
		label values hcind80d hcindd
	}
	
	cap confirm var ind02
	if !_rc{
		gen byte hcind02d = . 
		replace hcind02d = 1 if inlist(ind02, 7970, 8090)
		replace hcind02d = 2 if inlist(ind02, 7980)
		replace hcind02d = 3 if inlist(ind02, 7990)
		replace hcind02d = 4 if inlist(ind02, 8070)
		replace hcind02d = 5 if inlist(ind02, 8080)
		replace hcind02d = 6 if inlist(ind02, 8170, 8180)
		replace hcind02d = 7 if inlist(ind02, 8190)
		replace hcind02d = 8 if inlist(ind02, 8270)
		replace hcind02d = 9 if inlist(ind02, 8290)
		replace hcind02d = 10 if inlist(ind02, 8370, 8380, 8390, 8470)
		replace hcind02d = 11 if inlist(ind02, 6990)
		replace hcind02d = 12 if inlist(ind02, 3960)
		label variable hcind02d "Detailed Healthcare Industry (2002 codes)"
		label values hcind02d hcindd
	}
	
	
	//Coarse categories (By Industry)
	cap confirm var ind70
	if !_rc{
		gen byte hcind70c = . 
		replace hcind70c = 1 if inlist(ind70, 828, 829, 837, 847, 848)		
		replace hcind70c = 2 if inlist(ind70, 838)
		replace hcind70c = 3 if inlist(ind70, 839, 879)
		replace hcind70c = 4 if inlist(ind70, 878, 857, 887, 867)
		label variable hcind70c "Coarse Healthcare Industry (1970 codes)" 
		label values hcind70c hcindc
		
		//Healthcare Industry Dummies 
		gen byte d_hcindb70 = inlist(hcind70c, 1, 2, 3, 4)
		gen byte d_hcindr70 = inlist(hcind70c, 1, 2, 3)
		label variable d_hcindb70 "Healthcare industry worker (broad def, 1970 codes)"
		label variable d_hcindr70 "Healthcare industry worker (rest def, 1970 codes)"
		
		gen_replace "hcindc = hcind70c"
		gen_replace "d_hcindr = d_hcindr70"
		cap label values hcindc hcindc
	
		gen byte ind70miss = missing(ind70)
		gen_replace "indmiss = ind70miss"
		
	}
	
	cap confirm var ind80
	if !_rc{
		gen byte hcind80c = . 
		replace hcind80c = 1 if inlist(ind80, 812, 820, 821, 822, 830, 840)
		replace hcind80c = 2 if inlist(ind80, 831)
		replace hcind80c = 3 if inlist(ind80, 832, 870)
		replace hcind80c = 4 if inlist(ind80, 871, 861, 862)
		label variable hcind80c "Coarse Healthcare Industry (1980 codes)" 
		label values hcind80c hcindc
		
		//Healthcare Industry Dummies 
		gen byte d_hcindb80 = inlist(hcind80c, 1, 2, 3, 4)
		gen byte d_hcindr80 = inlist(hcind80c, 1, 2, 3)
		label variable d_hcindb80 "Healthcare industry worker (broad def, 1980 codes)"
		label variable d_hcindr80 "Healthcare industry worker (rest def, 1980 codes)"
		
		gen_replace "hcindc = hcind80c"
		gen_replace "d_hcindr = d_hcindr80"
		cap label values hcindc hcindc
		
		gen byte ind80miss = missing(ind80)
		gen_replace "indmiss = ind80miss"
	}
	
	gen byte d_hcindNAICS02 = . 
	cap confirm var ind02
	if !_rc{
		gen byte hcind02c = . 
		replace hcind02c = 1 if inlist(ind02, 7970, 7980, 7990, 8070, 8080, 8090, 8170, 8180)
		replace hcind02c = 2 if inlist(ind02, 8190)
		replace hcind02c = 3 if inlist(ind02, 8270, 8290)
		replace hcind02c = 4 if inlist(ind02, 8370, 8380, 8390, 8470) 
		label variable hcind02c "Coarse Healthcare Industry (2002 codes)" 
		label values hcind02c hcindc
		
		//Healthcare Industry Dummies 
		gen byte d_hcindb02 = inlist(hcind02c, 1, 2, 3, 4)
		gen byte d_hcindr02 = inlist(hcind02c, 1, 2, 3)
		label variable d_hcindb02 "Healthcare industry worker (broad def, 2002 codes)"
		label variable d_hcindr02 "Healthcare industry worker (rest def, 2002 codes)"
		
		gen_replace "d_hcindr = d_hcindr02"
		gen_replace "hcindc = hcind02c"
		cap label values hcindc hcindc
		
		gen byte ind02miss = missing(ind02)
		gen_replace "indmiss = ind02miss"
		
		//Healthcare Industry Dummy (NAICS Codes)
		replace d_hcindNAICS02 = inlist(hcind02c, 1, 2, 3) | inlist(ind02, 7860, 7870, 7880, 7890, 8390, 8470, 8370, 8380)
		
	}
		
		
	

	
	

	

	

}

