// Clean up the OECD Data on Health Spending by Country
// Author: Jonathan Holmes
// jholmes.hks@gmail.com
// Created: August 26, 2013


*********************************************************************
************************* LOAD DATA *********************************
*********************************************************************
version 11.2
clear
insheet using "../../1raw/OECD-healthdata.csv"


*********************************************************************
********************* CHOOSE DATA TO KEEP ***************************
*********************************************************************

keep if unit == "/capita, US$ at 2005 PPP rates"
keep if function == "Total  expenditure HC.1-HC.9; HC.R.1"

gen finagent_tag = ""
replace finagent_tag = "govtsp" if financingagent == "General government"
replace finagent_tag = "pvtsp" if financingagent == "Private sector"
replace finagent_tag = "totsp" if financingagent == "Total expenditure HF.1-HF.3"
drop financingagent flags

ren value rpcppp_health
reshape wide rpcppp_health, i(country year) j(finagent_tag) string

drop function-provider

//ren value rpcppp_healthtotsp
label variable rpcppp_healthtotsp  "Total Expenditures, $ Per Capita at 2005 PPP rates"
label variable rpcppp_healthgovtsp "Total Govt Expenditures, $ Per Capita at 2005 PPP rates"
label variable rpcppp_healthpvtsp  "Total Private Expenditures, $ Per Capita at 2005 PPP rates"



save "../../2data/OECD-healthdata.dta", replace
