// Convert NYSE Index Data from CSV to .dta 
// Author: Jonathan Holmes
// jholmes.hks@gmail.com
// Created: September 4, 2013




version 11.2

*********************************************************************
******************* LOAD NYSE COMPOSITE DATA ************************
*********************************************************************

//Source: Dwijen Gandhi, private communication
clear
insheet using "../../1raw/NYSE-composite-indx.csv"

destring, replace ignore(",")

gen date = date(filedate, "MDY")
format date %td

ren total nysecomp_totreturn
ren price nysecomp_price
drop filedate

destring, replace ignore("$,")


save "../../2data/NYSE-composite-indx.dta", replace




*********************************************************************
****************** LOAD NYSE HEALTH INDEX DATA **********************
*********************************************************************

//Source: Dwijen Gandhi, private communication
clear
insheet using "../../1raw/NYSE-health-indx.csv", comma names


destring, replace ignore(",")

gen date = date(filedate, "MDY")
format date %td

ren total nysehlth_totreturn
ren price nysehlth_price
drop filedate

save "../../2data/NYSE-health-indx.dta", replace
